#include <stdio.h>
#include "elapsedtime.h"
#ifndef VAX
#include <sys/time.h>
#include <sys/resource.h>

extern void getrusage(int, rusage*);
extern long time(long*);
#endif


inline void ptime(FILE* f, char* label, int secs)
{
    fprintf(f, "%s %d:%d:%d", label, secs/3600, (secs/60)%60, secs%60);
}


void elapsed_time::delta(FILE* f)
{
    elapsed_time e;
    if (f) {
#ifdef VAX
	fprintf(f, "[elapsed not impelmented for VAX]\n");
#else
	ptime(f, "[elapsed", e.realtime - realtime);
	ptime(f, " sys", e.sys - sys);
	ptime(f, " proc", e.proc - proc);
	fprintf(f, "]\n");
#endif
    }
    *this = e;
}


elapsed_time::elapsed_time()
{
#ifndef VAX
    rusage usage;
    getrusage(0, &usage);
    realtime = time(0);
    proc = usage.ru_utime.tv_sec;
    sys = usage.ru_stime.tv_sec;
#endif
}
