#ifndef gring
#include <generic.h>
#include "basictypes.h"
#include "fault.h"
#include "giterator.h"
/*
    gring.h -- generic singly-linked rings.

    Use -- instances of class foo contain a reference to a ring of
    instances of class bar:

    gring_define(_next,bar); 
    // Defines classes gring(rec_ring,type), gringroot(rec_ring,type).
    // First parameter is name of member to be created in the following
    // class to link the ring.  Second is the name of the class to be linked.

    class bar {
        int j; // Some random value of interest

        gring_inst(_next,bar);
	// Declares member "_next" which links the ring.
	// Second argument MUST match class name.
	// May be private -- class gringroot(_next,bar) is automatically
	//    made a friend.
    public:
        int i; // Some random value of interest


    };

    gring_inline(_next,bar);
    // Defines the inline member functions for gringroot(_next,bar).
    // MUST follow definition of class bar. May also follow definition of
    // class foo.

    class foo {
    public:
        int i; // Some random value of interest

        gringroot(_next,bar) bars;
	// Same arguments as gring.
	// "class" omitted here as I have already defined gringroot(...)

        int j; // Some random value of interest
    };

    // For ring building, foo->bars has the following member funcions:
        void insert_front(bar*);
        void insert(bar* b) { insert_front(b); }
        void insert_rear(bar*);
        void append(bar* b) { insert_rear(b); }
        void insert_after(bar* to_insert, bar* predecessor);

    // For ring traversal foo->bars has member functions:
        bar* first();
        bar* last();
        bar* next(bar*); // returns successor

    // For ring deletion, foo->bars has the following members.  They return
    // the object removed from the ring.
    // Note that remove_successor(0) is equivalent to remove_first().
	bar* remove_successor(bar* predecessor);
	bar* remove_first();

    // Merge rings -- *this gets all of the elements, other gets emptied.
        void merge_front(const THIS& other);
        void merge_rear(const THIS& other);
     
    // Ring rotation -- second element becomes first, first becomes last
	void rotate();

    // Example. -- this will create a ring of 10 members with
    // distinct values of i.
    int i;
    foo* a_foo = new foo;   // Create the object that binds a ring of bars
    bar* a_bar;
    
    for (i = 10; i; i--) {
	a_bar = new bar;
	a_bar->i = i;

        a_foo->bars.insert_front(a_bar);
    }

*/


#define gring(member,type) name3(ring_,type,member)
#define gringroot(member,type) name3(ringroot_,type,member)
#define gringiterator(member,type) GITERATOR(member,type)


#define gring_inst(member,type)\
    friend gringroot(member,type);  gring(member,type) member


#define gring_define_classes(member,type,specifier)\
\
class type;\
\
class gring(member,type) {\
    friend class gringroot(member,type);\
    type* forward;\
    void clear() { forward = 0; }\
public:\
    gring(member,type)() { clear(); }\
    void operator=() { } \
};\
\
class gringroot(member,type) : public collection_base {\
    type* tailp;\
public:\
    /* note that clear() does not clean up members -- it just 0s the root */\
    void clear() { tailp = 0; }\
    gringroot(member,type)() { clear(); }\
\
    /* Insertion */\
    specifier void insert_front(type*);\
    specifier void insert(type*);\
    specifier void insert_rear(type*);\
    specifier void append(type*);\
    specifier void insert_after(type* rec, type* prev);\
\
    /* merge */\
    specifier void merge_front(gringroot(member,type)&);\
    specifier void merge_rear(gringroot(member,type)&);\
\
    /* Removal */\
    specifier type* remove_successor(type* prev);\
    specifier type* remove_first();\
\
    /* Traversal */\
    specifier type* first();\
    type* last() { return tailp; }\
    specifier type* next(type* rec);\
\
    /* rotation -- second element becomes head, head becomes rearmost */\
    specifier void rotate();\
\
};\
\
/* definition of generic iterator class */\
class gringiterator(member,type) : public iterator_base {\
protected:\
    type* pos;\
public:\
    specifier gringiterator(member,type)(const gringroot(member,type)& r);\
    specifier void init();\
    const gringroot(member,type)& collection() \
	{ return *(gringroot(member,type)*)&iterator_base::collection(); }\
    specifier type* operator()(); \
}


#define gring_define(member,type) gring_define_classes(member,type,)


/*
    The following must come after the definition of class "type".
*/
#define gring_functions(member,type,specifier)\
/* Insertion */\
specifier void gringroot(member,type)::insert_front(type* rec)\
{\
    AS(!(rec->member.forward));\
    if (!tailp) tailp = rec->member.forward = rec;\
    else {\
	rec->member.forward = tailp->member.forward;\
	tailp->member.forward = rec;\
	}\
}\
specifier void gringroot(member,type)::insert(type* rec)\
    { insert_front(rec); }\
specifier void gringroot(member,type)::insert_rear(type* rec)\
    { insert_front(rec); tailp = tailp->member.forward; /* rotate */ }\
specifier void gringroot(member,type)::append(type* rec)\
    { insert_front(rec); tailp = tailp->member.forward; /* rotate */ }\
specifier void gringroot(member,type)::insert_after(type* rec, type* prev)\
{\
    AS(prev);  AS(rec);\
    AS(prev->member.forward);  AS(!(rec->member.forward));\
    rec->member.forward = prev->member.forward;\
    prev->member.forward = rec;\
    if (tailp == prev) tailp = rec;\
}\
\
/* merge */\
specifier void gringroot(member,type)::merge_front(gringroot(member,type)& o)\
{\
     if (o.tailp) {\
	 if (!tailp) tailp = o.tailp;\
	 else {\
	     type* first = tailp->member.forward;\
	     tailp->member.forward = o.tailp->member.forward;\
	     o.tailp->member.forward = first;\
	 }\
	 o.tailp = 0;\
     }\
}\
specifier void gringroot(member,type)::merge_rear(gringroot(member,type)& o)\
    { o.merge_front(*this);  tailp = o.tailp;  o.tailp = 0; }\
\
/* Removal */\
specifier type* gringroot(member,type)::remove_first()\
{\
    type* toremove = 0;\
    if (tailp) {\
	toremove = tailp->member.forward;\
	tailp->member.forward = toremove->member.forward;\
	if (tailp == toremove) clear();\
	toremove->member.clear();\
    }\
    return toremove;\
}\
specifier type* gringroot(member,type)::remove_successor(type* prev)\
{\
    type* toremove;\
    if (!prev) toremove = remove_first();\
    else {\
	AS(tailp);\
	toremove = prev->member.forward;\
	prev->member.forward = toremove->member.forward;\
	if (tailp == toremove) tailp = prev;\
	toremove->member.clear();\
	}\
    return toremove;\
}\
\
/* Traversal */\
specifier type* gringroot(member,type)::first()\
    { return tailp ? tailp->member.forward : 0; }\
specifier type* gringroot(member,type)::next(type* rec)\
    { return rec == tailp ? 0 : rec->member.forward; }\
\
/* rotation -- second element becomes head, head becomes rearmost */\
specifier void gringroot(member,type)::rotate() \
    { if (tailp) tailp = tailp->member.forward; }\
\
/* generic iterator */\
specifier gringiterator(member,type)::\
gringiterator(member,type)(const gringroot(member,type)& r) : (r)\
    { pos = 0; }\
specifier void gringiterator(member,type)::init() \
    { pos = 0; }\
specifier type* gringiterator(member,type)::operator()() \
{\
    type* val = pos ? collection().next(pos) : collection().first();\
    if (val) pos = val;\
    return val;\
}


#define gring_inline(member,type) gring_functions(member,type,inline)


/* ring traversal */
#define gring_walk(root,lvalue)\
    for ((lvalue) = (root).first(); (lvalue); (lvalue)=(root).next(lvalue))
#endif
