
function avl_compare(*obj1, obj2: avl_object_ptr; 
                      kind: avl_type): compare_type;*);
  { compare the 2 avl objects as appropriate for their type }
begin
#if AVLDEBUG
  if not ((obj1.tag = obj2.tag) and (obj2.tag = kind)) then 
    begin 
      assert(245);
      avl_compare := LT; 
    end 
 else 
#endif
    case kind of

    { ---------  Compare complemented actuals (signal definitions)--------}

      AVL_COMPLEMENTED_ACTUAL:

        { This tree consists of signal definitions for signals with
	  complemented polarity.  Lookups may compare them with 
	  their uncomplemented counterpart, so comparisons must be based on
	  signal definition NAMES (ignoring the polarity).  These names are
	  all in the string table, so the comparison is done on the
	  ord of the pointer for speed (which is portable to all of our
	  current platforms. }

        if obj1.complemented_actual = NIL then
	  if obj2.complemented_actual = NIL then avl_compare := EQ
	                                    else avl_compare := LT
	else if obj2.complemented_actual = NIL then avl_compare := GT
        else if obj1.complemented_actual^.signal^.name =
	        obj2.complemented_actual^.signal^.name then avl_compare := EQ
        else if ord(obj1.complemented_actual^.signal^.name) <
	        ord(obj2.complemented_actual^.signal^.name) then
	  avl_compare := LT
	else avl_compare := GT;

    { ---------  Compare invokes  -----------------------------------------}

      AVL_INVOKE:

        { This tree is kept for detection of duplicate PATH property names,
	  so it is strictly a path value comparison.  The comparison
	  based on the ord of the string pointer for speed.  (This is
	  portable to all platforms we currently support.) }

 
        if obj1.invoke = NIL then
	  if obj2.invoke = NIL then avl_compare := EQ
	                            else avl_compare := LT
        else if obj2.invoke = NIL then avl_compare := GT
        else if obj1.invoke^.path = obj2.invoke^.path then avl_compare := EQ
	else if ord(obj1.invoke^.path) < ord(obj2.invoke^.path) then
	  avl_compare := LT
	else avl_compare := GT;

    { ---------  Compare context_definitions by number  -------------------}

      AVL_CONTEXT_NUMBER:

        if obj1.context_number = NIL then
	  if obj2.context_number = NIL then avl_compare := EQ
	                               else avl_compare := LT
        else if obj2.context_number = NIL then avl_compare := GT
        else if obj1.context_number^.number = obj2.context_number^.number then
          avl_compare := EQ
	else if obj1.context_number^.number < 
	     obj2.context_number^.number then
	  avl_compare := LT
	else avl_compare := GT;

    { ---------  Compare context_definitions by parameters -----------------}

      AVL_CONTEXT:

        if obj1.context = NIL then
	  if obj2.context = NIL then avl_compare := EQ
	                        else avl_compare := LT
        else if obj2.context = NIL then avl_compare := GT
        else avl_compare := compare_parameter_lists(obj1.context^.parameters,
	                                            obj2.context^.parameters);

    { ----  Compare strings by ord of the pointer ------------------------}

      AVL_STRING: 
	if ord(obj1.str) < ord(obj2.str) then avl_compare := LT
	else if ord(obj1.str) = ord(obj2.str) then avl_compare := EQ
	else avl_compare := GT;

    { ----  Compare comperr_drawings by macro name (ptr) ----------------}

      AVL_COMPERR_DRAWING:

        if obj1.cerr_drawing = NIL then
	  if obj2.cerr_drawing = NIL then avl_compare := EQ
	                                     else  avl_compare := LT
        else if obj2.cerr_drawing = NIL then avl_compare := GT
        else if ord(obj1.cerr_drawing^.macro_name) <
                ord(obj2.cerr_drawing^.macro_name) then avl_compare := LT
        else if ord(obj1.cerr_drawing^.macro_name) =
                ord(obj2.cerr_drawing^.macro_name) then avl_compare := EQ
        else avl_compare := GT;

    { ---------  Compare context_definitions by parameters -----------------}

      AVL_COMPERR_MODULE:

        if obj1.cerr_module = NIL then
	  if obj2.cerr_module = NIL then avl_compare := EQ
	                        else avl_compare := LT
        else if obj2.cerr_module = NIL then avl_compare := GT
        else avl_compare := 
	  compare_param_property_lists(obj1.cerr_module^.context,
                                       obj2.cerr_module^.context);

    { ---------------- end of legitimate avl types -----------------------}

      OTHERWISE
        begin
          assert(244 { not allowed });
          avl_compare := LT;
        end;
    end;
end { avl_compare } ;


