type
{----------------------------------------------------------------------}
{ The following types are used to construct AVL (height-balanced       }
{ binary) trees.  An AVL record contains all of the tree maintenance   }
{ fields and an field which points to the object entered in the tree.  }
{ The AVL_OBJECT_PTR can point to any 1 of a list of objects.  It      }
{ also can (using conditional complilation mechanism) contain a TAG    }
{ field which can remember what kind of object is presumed to be       }
{ represented.  This allows a run-time type checking to be performed   }
{ within the avl_compare function.   The BALANCE_FACTOR field of an    }
{ AVL keeps track of the difference between the left subtree of the    }
{ node and the right subtree of the node.  As long as the tree is      }
{ balanced, these heights can never differ by more than 1, so an       }
{ enumerated type is used.                                             }
{----------------------------------------------------------------------}
  balance_factor_type = (LEFT_HEAVY_BF, EVEN_BF, RIGHT_HEAVY_BF);
  avl_type = (AVL_FIRST,
              AVL_COMPLEMENTED_ACTUAL, 
	      AVL_INVOKE, 
	      AVL_CONTEXT,
	      AVL_CONTEXT_NUMBER,
	      AVL_STRING,
	      AVL_NUMBSTRING_BY_LENGTH,
	      AVL_COMPERR_DRAWING,
	      AVL_COMPERR_MODULE,
	      AVL_LAST);

  avl_object_ptr = record
    case
#if AVLDEBUG
         tag:
#endif 
              avl_type of
      AVL_FIRST:
        (dummy_first: longint);                     { never used }
      AVL_COMPLEMENTED_ACTUAL: 
        (complemented_actual: signal_definition_ptr);
      AVL_INVOKE:
        (invoke: invoke_list_ptr);
      AVL_CONTEXT:
        (context: context_definition_ptr);          { sort by parameters }
      AVL_CONTEXT_NUMBER:
        (context_number: context_definition_ptr);   { sort by number }
      AVL_STRING:
        (str: xtring);                              { sort by ord of pointer }
      AVL_COMPERR_DRAWING:
        (cerr_drawing: comperr_drawing_ptr);        { sort by macro name (not
	                                              necessarily 
						      lexicographically) }
      AVL_COMPERR_MODULE:
        (cerr_module: comperr_module_ptr);          { sort by context }
      AVL_LAST:
        (dummy_last: longint);                      { never used }
  end;

{ avl_ptr = ^avl; } { given a forward reference earlier }
  avl = record
    left_child: avl_ptr;
    right_child: avl_ptr;
    balance_factor: balance_factor_type;
    object: avl_object_ptr;
  end;

