  {------- string consts ---------------}

  HASH_STRING_TABLE_SIZE    = 1110; { hash string table size - 1 }


 {----------------------------  CONSTS  --------------------------------}

  WELCOME_MESSAGE = ' Valid Logic Systems, Inc.  ValidCOMPILER  ';
  COPYRIT_MESSAGE = ' (C) Copyright 1985,1989 Valid Logic Systems, Inc.';

  DEFAULT_ROT     = 0;                     { rotation of the body }
  VERSION         = 1;                     { version number }
  PAGE_NUMBER     = 1;                     { page number }

#if !VAX
  MAXINT          = 2147483647;    { Maximum longint }
#endif 

  EOL                   = 0;       { end of line character }
  TAB_CHAR              = 9;       { ASCII tab character }
  CONTINUATION_CHAR     = '~';     { line continuation character }

  ID_LENGTH           = 16;        { number of characters in an id }
  MAX_ERROR_NUM       = 255;       { maximum error number }
  MAX_BIT_VALUE       = MAXINT;    { maximum bit value for bit subscripts }

  ERROR_MESSAGE_LENGTH = 44;

  MAX_OUTPUT_FILE_LENGTH = 76;     { length of output files }

  MAX_STACK           = 10;        { maximum text macro nesting }

  NAME_TABLE_SIZE           = 126;  { size of the identifier name table - 1 }
  SYNTAX_TABLE_SIZE         = 5;    { # elements of signal syntax }

  MIN_RADIX           = 2;         { minimum allowed input radix }
  MAX_RADIX           = 16;        { maximum allowed input radix }

  

  CLOCK_UNITS         = 1000;      { basic CLOCK time units }

#if VAX
  SUCCESSFUL_COMPLETION = 1; 
  WARNING_COMPLETION    = 0; 
  OVERSIGHT_COMPLETION  = 3; 
  ERROR_COMPLETION      = 2; 
  FATAL_COMPLETION      = 4; 
#endif
#if UNIX
  SUCCESSFUL_COMPLETION = 0; 
  WARNING_COMPLETION    = 8; 
  OVERSIGHT_COMPLETION  = 9; 
  ERROR_COMPLETION      = 10; 
  FATAL_COMPLETION      = 11;
#endif
  NULL_ALPHA          = '                ';  

  OUTPUT_QUOTE_CHAR   = '''';      { quote character for output files }
  ERROR_POSITION_CHAR = '^';       { pointer to position of error in line}




  MAX_CLI_ARG_NUMBER = 10; { maximum number of command line arguments 
			     other than the program name }

  { -- a display constant -- }

  INDENT              = 4;         { indent space for broken output lines }



  { -- file name constants -- }


  EXTENSION_SUFFIX            = '_CONN           ';
  DIRECTORY_SUFFIX            = '_DIR            ';
  LOGIC_PREFIX                = 'LOGIC           ';
  PRIM_PREFIX                 = 'PRIM            ';
  PART_PREFIX                 = 'PART            ';
  EXPANSION_FILE_TYPE         = 'EXPANSION       ';
  CHIPS_FILE_TYPE             = 'LIBRARY_PARTS   ';

#if UNIX
#if S32 || PC_AT
  DISTRIBUTION_DIR    = '/u0/            '; 
  DIST_LANGUAGE       = 'scald/          '; 
#endif
#if SUN || PMAX
  DISTRIBUTION_DIR    = '/usr/valid/     '; 
  DIST_LANGUAGE       = 'tools/language/ '; 
#endif
  DEFAULT_CONFIG_FILE = 'config.dat      '; 
  DEFAULT_PROP_FILE   = 'property.dat    '; 
  DEFAULT_TEXT_MACROS = 'textmacro.dat   '; 
  DEFAULT_MASTER_FILE = 'master.lib      '; 
#endif UNIX

#if VAX
  DISTRIBUTION_DIR    = 'SCALD$ROOT:     '; 
  DIST_LANGUAGE       = '[LANGUAGE]      '; 
  DEFAULT_CONFIG_FILE = 'CONFIG.DAT      '; 
  DEFAULT_PROP_FILE   = 'PROPERTY.DAT    '; 
  DEFAULT_TEXT_MACROS = 'TEXTMACRO.DAT   '; 
  DEFAULT_MASTER_FILE = 'MASTER.LIB      '; 
#endif VAX

  { -- logical output file names -- }

  MONITOR_FILE_NAME         = 'MONITOR         ';
  CONFIG_FILE_NAME          = 'CONFIG          ';
  CMPEXP_FILE_NAME          = 'CMPEXP          ';
  CHIPS_FILE_NAME           = 'CHIPS           ';
  CMPSYN_FILE_NAME          = 'CMPSYN          ';
  CMPERR_FILE_NAME          = 'CMPERR          ';
  CMPLST_FILE_NAME          = 'CMPLST          ';
  CMPLOG_FILE_NAME          = 'CMPLOG          ';

  { Secret SCALD passwords !! (ooooooooh) }

  DEBUG_PASSWORD            = 'FRAMITZ         ';
  CONTEXT_PASSWORD          = 'ROOT_CONTEXT    ';
  CONFIGURE_PASSWORD        = 'ZZYZYX          ';

  { -- time constants -- }

#if VAX
  TIME_BUFFER_LENGTH  = 11; 
#endif
#if UNIX
  TIME_BUFFER_LENGTH  = 26;
#endif


  { -- et interface constants -- }

  PASS_THE_PROPERTY = 0;             { value for filter flag }
  FILTER_THE_PROPERTY = 1;           { value for filter flag }
  DWG_NOT_FOUND = -2;                { drawing_get return value }
  HIERARCHICHAL = 2;                 { expansion style }
  FLAT = 0;                          { expansion style }
  SINGLE_LEVEL = 1;                  { expansion style }
  NO_SYNONYMS = 0;                   { synonym style }
  PAGE_BY_PAGE = 1;                  { synonym style }
  NODE_BY_NODE = 2;                  { synonym style }

  BUBBLED_ENUM = -32768;
  OUTPUT_TYPE_ENUM = -32767;
  INIT_PROPERTY_ENUM = -32766;
