{ ValidLINKER (et) 1.3 external declaration template for sun PASCAL }
{ bh 9 Jan 87 }

{ Summary of changes from 1.2 to 1.3:

    1. Parameters passed only TO et are passed by value (most were
       previously passed by reference.  This allows you to write code like
          const
	    FILTER_OTHER_PROPS = 1;
	    EXPAND_FLAT = 0;
             ...
	  if drawing_get(root_drawing, nullstring, sim_string, 
	                 FILTER_OTHER_PROPS, synonym_style, EXPAND_FLAT)
             <> 0 then blow_up;
       rather than having to stuff constants into a variable so that
       PASCAL can pass it by reference.

    2. The iterators return a boolean value -- TRUE if a value has
       been returned and FALSE (and a NIL object name) if done.
       This allows code like
          while (property_get(prop_name, prop_value, prop_enum)) do
	    begin
	      ...
	    end;
       in place of 
          property_get(prop_name, prop_value, prop_enum);
	  while (prop_name <> NIL) do
	    begin
	      ...
              property_get(prop_name, prop_value, prop_enum);
	    end;
       though the latter code will still work if you modify the external
       declarations to be procedures again (you do not HAVE to change
       the old code).

    3. drawing_get returns a status code as a function value rather than
       as a parameter.  The return code has 4 possible values.  Note that
       these are DIFFERENT than the values returned before.  You WILL need
       to accomodate this change in your code.  New values are:

          0  -> No errors -- proceed.
          1  -> Errors discovered -- can proceed but at own risk.
          -1 -> Fatal error(s) occured.  Can not proceed.
          -2 -> Fatal error(s) occured, one of which is that the root
	        drawing was not found.
}


function drawing_get(BYVALUE drawing, context, compile_type: xtring; 
                     BYVALUE default_filter, synonym_style, expansion_style: 
	             longint): longint;
cexternal;


function primitive_get(var name, path_name: xtring;
                       var size_value, is_a_primitive: longint;
		       var prim_enum: longint): boolean;
cexternal;


function primpin_get(var pin_name: xtring;
                     var left, right: longint): boolean;
cexternal;


function netname_get(var signal_name: xtring; var left, right: longint;
                     var sig_ptr: longint): boolean;
cexternal;


function synonym_get(var signal_name, base_name: xtring;
                     var signal_left, signal_right, 
	                 base_left, base_right, scope: longint;
                     var base_ptr: longint): boolean;
cexternal;


procedure init_property(BYVALUE prop_name: xtring; 
                        BYVALUE prop_enum: longint;
                        BYVALUE filter_flag: longint);
cexternal;


function property_get(var prop_name, prop_val: xtring;
                      var prop_enum: longint): 
		      boolean;
cexternal;


procedure error_get(var comp_errors, comp_oversights, comp_warnings,
                        link_errors, link_oversights, link_warnings: longint);
cexternal;


function signal_get(var sig_name: xtring;  var sig_left, sig_right: longint;
                    var sig_ptr: longint): boolean;
cexternal;
