procedure dumpfiles;

var 
  dwg_exists,
  def_filter,
  exp_style,
  syn_style,
  prop_enum : longint;

  prop_name,
  SIM_string,
  TIME_string,
  bubbled_string,
  outtype_string,
  compile_type : xtring;   { to convert specified_compile_type to string }

{  ___________________________________________________________________  }
{                                                                       }
{      procedure to print primitive information to compiler expansion   }
{          file and synonym information to compiler synonym file        }
{          using generalized interface                                  }
{                                                                       }
{  ___________________________________________________________________  }


procedure doprinting;


var
  prim_path,
  prim_name,
  temp_path,
  prop_value,
  pin_name,
  sname,
  dwg_page,
  dwg_version,
  dwg_type,
  bname,
  sig_name,
  net_name,
  linker_name,
  linker_value,
  type_string,
  version_string,
  page_string : xtring;

  prim_prim,
  prim_size,
  prim_enum,
  dsigptr,                         { dummy signal pointer for interface}
  sig_left,
  sig_right,
  net_left,
  net_right,
  pin_left,
  pin_right,
  syn_left,
  syn_right,
  syn_scope,
  base_left,
  base_right : longint;
  
  first_signal,
  first_prim_prop,
  first_sig_prop,
  first_pin_prop,
  first_prop,
  printing_sig_sec,
  printing_pin_sec : boolean;

  prim_prop_assigned,
  current_prop   : temp_prop_ptr;
  current_signal : sig_ptr;
  pin_assigned   : pin_ptr;        { pins assigned }


  procedure print_pin_sec;
  begin

    if not printing_pin_sec then 
    begin
      if PrintCmpExp then writeln(CmpExp,' PIN');
      printing_pin_sec := TRUE;
    end;
    if first_prop then 
    begin
      first_prop := FALSE;
      if PrintCmpExp then 
      begin
        print_char_continue(CmpExp,' ');
        print_char_continue(CmpExp,' ');
        print_string_quoted_continue(CmpExp,pin_name);
        print_subrange(CmpExp,pin_left,pin_right);
        if pin_left <> -1 then print_char_continue(CmpExp,' ');
        print_char_continue(CmpExp,concatenation_char);
      end;
    end;
    if PrintCmpExp then 
    begin
      print_property(CmpExp,prop_name,prop_value);
      print_char_continue(CmpExp,';');
      print_CRLF_continue(CmpExp);
    end;
  end; {print_pin_sec}


  procedure print_synonym_heading;
  begin
    print_alpha_continue(CmpSyn,'DRAWING=        ');
    print_char_continue(CmpSyn,OUTPUT_QUOTE_CHAR);
    if (temp_path <> nullstring) then
      print_string_repeat_quotes_continue(CmpSyn,temp_path);
    print_string_repeat_quotes_continue(CmpSyn,prim_name);
    print_char_continue(CmpSyn,OUTPUT_QUOTE_CHAR);
    print_char_continue(CmpSyn,'.');
    print_string_continue(CmpSyn,dwg_type);
    print_char_continue(CmpSyn,'.');
    print_string_continue(CmpSyn,dwg_version);
    print_char_continue(CmpSyn,'.');
    print_string_continue(CmpSyn,dwg_page);
    print_char_continue(CmpSyn,';');
    print_CRLF_continue(CmpSyn);
  end { print_synonym_heading };


begin { doprinting }

  prim_prop_assigned := NIL;
  pin_assigned := NIL;
  page_string:=nullstring;
  type_string:=nullstring;
  version_string:=nullstring;
  dwg_page := nullstring;
  dwg_type := nullstring;
  dwg_version := nullstring;

  copy_to_string('PAGE            ',page_string);
  copy_to_string('TYPE            ',type_string);
  copy_to_string('VER             ',version_string);

  { get properties of the root drawing }

  
  while property_get(linker_name,linker_value,prop_enum) do
  begin
    if PrintCmpExp then 
    begin
      print_char_continue(CmpExp,' ');
      print_property(CmpExp, linker_name, linker_value);
      print_char_continue(CmpExp,';');
      print_CRLF_continue(CmpExp);
    end;
  end;


  if PrintCmpExp then writeln(CmpExp,'END_DIRECTIVES;');

  while primitive_get(linker_name,prim_path,prim_size,prim_prim,prim_enum) do
  begin
    prim_name := nullstring;
    copy_string(linker_name,prim_name);
    temp_path := nullstring;
    if (prim_path <> NIL) then copy_string(prim_path,temp_path);

    if (prim_prim <> 0) then 
    begin { it is a primitive ! }

      if PrintCmpExp then 
      begin
        print_alpha_continue(CmpExp,'PRIMITIVE       ');
        print_char_continue(CmpExp,' ');
        print_string_quoted_continue(CmpExp,prim_name);
        print_char_continue(CmpExp,';');
        print_CRLF_continue(CmpExp);
      end;
      if PrintChips then 
      begin
        print_alpha_continue(Chips,'PRIMITIVE       ');
        print_char_continue(Chips,' ');
        print_string_quoted_continue(Chips,prim_name);
        print_char_continue(Chips,';');
        print_CRLF_continue(Chips);
      end;
      first_prim_prop := TRUE;
      while property_get(linker_name,linker_value,prop_enum) do
      begin
	prop_name := nullstring;
	prop_value := nullstring;
        copy_string(linker_name,prop_name);
        copy_string(linker_value,prop_value);
        if first_prim_prop then 
	begin
          append_to_prop_list(prim_prop_assigned,prop_name,prop_value);
          current_prop := prim_prop_assigned;
          first_prim_prop := FALSE;
        end
        else 
	begin
          append_to_prop_list(current_prop^.next,prop_name,prop_value);
          current_prop := current_prop^.next;
        end;
      end;

      printing_pin_sec := FALSE;
      if PrintChips then
      begin
        print_alpha_continue(Chips,' PIN            ');
        print_CRLF_continue(Chips);
      end;

      while primpin_get(linker_name,pin_left,pin_right) do
      begin
	pin_name := nullstring;
        copy_string(linker_name,pin_name);
        add_to_pin_list(pin_assigned,pin_name,pin_left,pin_right);
	if PrintChips then
	begin
          print_char_continue(Chips,' ');
          print_char_continue(Chips,' ');
	  print_string_quoted_continue(Chips,pin_name);
	  print_subrange(Chips,pin_left,pin_right);
          if pin_left <> -1 then print_char_continue(Chips,' ');
          print_char_continue(Chips,concatenation_char);
          print_CRLF_continue(Chips);
	end;
        first_prop := TRUE;
        first_pin_prop := TRUE;
        while property_get(linker_name,linker_value,prop_enum) do
        begin
	  prop_name := nullstring;
	  prop_value := nullstring;
          copy_string(linker_name,prop_name);
          copy_string(linker_value,prop_value);
          if first_pin_prop then 
          begin
            append_to_prop_list(pin_assigned^.proptr,prop_name,prop_value);
            current_prop := pin_assigned^.proptr;
            first_pin_prop := FALSE;
          end
          else 
          begin
            append_to_prop_list(current_prop^.next,prop_name,prop_value);
            current_prop := current_prop^.next;
          end;
	  if PrintChips then
	  begin
            print_char_continue(Chips,' ');
            print_char_continue(Chips,' ');
            print_char_continue(Chips,' ');
	    print_property(Chips,prop_name,prop_value);
	    print_char_continue(Chips,';');
            print_CRLF_continue(Chips);
	  end;
          if not special_compile then print_pin_sec;
        end;


        first_signal := TRUE;
        while netname_get(linker_name,net_left,net_right,dsigptr) do
        begin
	  net_name := nullstring;
          copy_string(linker_name,net_name);
          if first_signal then 
          begin
            append_to_signal_list(pin_assigned^.sigptr,
              net_name,net_left,net_right);
            current_signal := pin_assigned^.sigptr;
            first_signal := false;
          end
          else 
          begin
            append_to_signal_list(current_signal^.next,
	      net_name,net_left,net_right);
            current_signal := current_signal^.next;
          end;
          first_sig_prop :=TRUE;
          while property_get(linker_name,linker_value,prop_enum) do
          begin
	    prop_name := nullstring;
	    prop_value := nullstring;
            copy_string(linker_name,prop_name);
            copy_string(linker_value,prop_value);
            if first_sig_prop then 
            begin
              append_to_prop_list(current_signal^.proptr,
				  prop_name,prop_value);
              current_prop := current_signal^.proptr;
              first_sig_prop := FALSE;
            end
            else 
            begin
              append_to_prop_list(current_prop^.next,
                                  prop_name,prop_value);
              current_prop := current_prop^.next;
            end;
          end;
        end { while for netname_get };
      end { while for primpin_get };

      if (prim_size = -1) then prim_size := 1;  { default size }

      if PrintChips then
      begin
	print_alpha_continue(Chips,' END_PIN;       ');
        print_CRLF_continue(Chips);
        print_alpha_continue(Chips,' BODY           ');
        print_CRLF_continue(Chips);

        current_prop := prim_prop_assigned;
        while current_prop <> NIL do 
        begin
          print_char_continue(Chips,' ');
          print_char_continue(Chips,' ');
          print_property(Chips,current_prop^.name,current_prop^.value);
          print_char_continue(Chips,';');
          print_CRLF_continue(Chips);
          current_prop := current_prop^.next;
        end {printing body properties};

        print_alpha_continue(Chips,'  SIZE=         ');
        print_char_continue(Chips,OUTPUT_QUOTE_CHAR);
        print_integer_continue(Chips,prim_size);
        print_char_continue(Chips,OUTPUT_QUOTE_CHAR);
        print_char_continue(Chips,';');
        print_CRLF_continue(Chips);

        print_alpha_continue(Chips,' END_BODY;      ');
        print_CRLF_continue(Chips);
        print_alpha_continue(Chips,'END_PRIMITIVE;  ');
        print_CRLF_continue(Chips);
      end;

      if PrintCmpExp then 
      begin
        if printing_pin_sec then writeln(CmpExp,' END_PIN;');
        print_alpha_continue(CmpExp,' BODY           ');
        print_CRLF_continue(CmpExp);

        if (ord(temp_path^[0]) <> 0) then 
        begin
          print_alpha_continue(CmpExp,'  PATH_NAME=    ');
          print_string_quoted_continue(CmpExp,temp_path);
          print_char_continue(CmpExp,';');
          print_CRLF_continue(CmpExp);
        end;

        print_alpha_continue(CmpExp,'  SIZE=         ');
        print_char_continue(CmpExp,OUTPUT_QUOTE_CHAR);
        print_integer_continue(CmpExp,prim_size);
        print_char_continue(CmpExp,OUTPUT_QUOTE_CHAR);
        print_char_continue(CmpExp,';');
        print_CRLF_continue(CmpExp);

        current_prop := prim_prop_assigned;
        while current_prop <> NIL do 
        begin
          print_char_continue(CmpExp,' ');
          print_char_continue(CmpExp,' ');
          print_property(CmpExp,current_prop^.name,current_prop^.value);
          print_char_continue(CmpExp,';');
          print_CRLF_continue(CmpExp);
          current_prop := current_prop^.next;
        end {printing body properties};

        print_alpha_continue(CmpExp,' END_BODY;      ');
        print_CRLF_continue(CmpExp);

        print_bindings(pin_assigned);
        print_alpha_continue(CmpExp,'END_PRIMITIVE;  ');
        print_CRLF_continue(CmpExp);
      end; { printcmpexp }

      release_complete_prop_list(prim_prop_assigned);
      release_complete_pin_list(pin_assigned);
    end { if for is primitive }
    else if PrintCmpSyn then
    begin

      while property_get(linker_name,linker_value,prop_enum) do
        if (compare_strings(page_string,linker_name) = EQ) then 
          copy_string(linker_value,dwg_page)
        else if (compare_strings(version_string,linker_name) = EQ) then 
          copy_string(linker_value,dwg_version)
        else if (compare_strings(type_string,linker_name) = EQ) then 
          copy_string(linker_value,dwg_type);

      if synonym_get(sname,bname, syn_left, syn_right, base_left, base_right,
                     syn_scope, dsigptr) then
      begin
        print_synonym_heading;
        repeat
          print_char_continue(CmpSyn,' ');
          print_string_quoted_continue(CmpSyn,sname);
          print_subrange(CmpSyn,syn_left,syn_right);
          print_char_continue(CmpSyn,GENERAL_PROPERTY_PREFIX_CHAR);
          case (syn_scope) of
            0 :      print_char_continue(CmpSyn,'L');
            1 :      print_char_continue(CmpSyn,'G');
            2 :      print_char_continue(CmpSyn,'I');
          end {case};
          print_char_continue(CmpSyn,'=');
          print_string_quoted_continue(CmpSyn,bname);
          print_subrange(CmpSyn,base_left,base_right);
          print_char_continue(CmpSyn,';');
          print_CRLF_continue(CmpSyn);
        until not synonym_get(sname,bname, syn_left, syn_right, 
                              base_left, base_right, syn_scope, dsigptr);
      end;

    end { else for is synonym data };

    release_string(prim_name);
    release_string(temp_path);

  end { while for primitive_get };


  if not special_compile then 
  begin
    sig_name := nullstring;
    printing_sig_sec := FALSE;
    while signal_get(linker_name,sig_left,sig_right,dsigptr) do
    begin
      copy_string(linker_name,sig_name);
      first_prop := TRUE;
      while property_get(prop_name,prop_value,prop_enum) do
      begin
        if PrintCmpExp then 
        begin
          if not printing_sig_sec then 
          begin
            writeln(CmpExp,'SIGNALS');
            printing_sig_sec := TRUE;
          end;
          if first_prop then 
          begin
	    first_prop := FALSE;
            print_char_continue(CmpExp,' ');
            print_string_quoted_continue(CmpExp,sig_name);
            print_subrange(CmpExp,sig_left,sig_right);
            print_char_continue(CmpExp,concatenation_char);
          end
	  else
	    if (linker_name <> NIL) and PrintCmpExp then 
              print_char_continue(CmpExp,',');
          print_property(CmpExp,prop_name,prop_value);
        end {PrintCmpExp};
      end; { while for property get }

      if PrintCmpExp then 
      begin
        print_char_continue(CmpExp,';');
        print_CRLF_continue(CmpExp);
      end;
    end;

    release_string(sig_name);

    if printing_sig_sec and PrintCmpExp then writeln(CmpExp,'END_SIGNALS;');
  end; { if for special compilation }
end { doprinting };

begin  { dumpfiles }

  { routine to print compiler expansion and synonym files 
    in old format (7.5 and below) }


  if CmpExp_file IN files_to_generate then PrintCmpExp  := TRUE;
  if CmpSyn_file IN files_to_generate then PrintCmpSyn  := TRUE;
  if Chips_file  IN files_to_generate then PrintChips  := TRUE;

  writeln(monitor);
  if PrintCmpExp then 
  begin
    writeln(monitor, ' Writing primitives in ................. ',
      CmpExp_file_name);
    if not rewrite_file(CmpExp, CMPEXP_FILE_NAME) then
      PrintCmpExp := FALSE;
  end;

  if PrintCmpSyn then 
  begin
    writeln(monitor, ' Writing synonym list in ............... ',
      CmpSyn_file_name);
    if not rewrite_file(CmpSyn, CMPSYN_FILE_NAME) then
      PrintCmpSyn := FALSE;
  end;

  if PrintChips then 
  begin
    writeln(monitor, ' Writing library chips file in ......... ',
      Chips_file_name);
    if not rewrite_file(Chips, CHIPS_FILE_NAME) then
      PrintChips := FALSE;
  end;

  if not(PrintChips or PrintCmpSyn or PrintCmpExp) then
    writeln(monitor, ' No output files will be generated.');

  writeln(monitor);
  writeln(monitor);

  bubbled_string:=nullstring;
  outtype_string:=nullstring;
  SIM_string := nullstring;
  TIME_string := nullstring;
  compile_type := nullstring;

  copy_to_string('BUBBLED         ',bubbled_string);
  copy_to_string('OUTPUT_TYPE     ',outtype_string);
  copy_to_string('SIM             ',SIM_string);
  copy_to_string('TIME            ',TIME_string);
  copy_to_string(specified_compile_type^.name,compile_type);

  special_compile := ((compare_strings(compile_type,SIM_string)=EQ) or
                      (compare_strings(compile_type,TIME_string)=EQ));

  { initialize parameters for drawing_get and get the drawing }

  if single_level_compile then exp_style := SINGLE_LEVEL
  else exp_style := FLAT;

  if PrintCmpSyn then 
    if page_synonym then syn_style := PAGE_BY_PAGE
    else syn_style := NODE_BY_NODE
  else syn_style := NO_SYNONYMS;

  if default_filter_value then def_filter := FILTER_THE_PROPERTY
  else def_filter := PASS_THE_PROPERTY;

  if special_compile then 
    begin
      { initialize bubbled and output_type properties to PASS }
      init_property(bubbled_string, BUBBLED_ENUM, PASS_THE_PROPERTY);
      init_property(outtype_string, OUTPUT_TYPE_ENUM, PASS_THE_PROPERTY);
    end
  else
    init_property(bubbled_string, BUBBLED_ENUM, FILTER_THE_PROPERTY);

  dwg_exists := drawing_get(root_macro_name, context_name, compile_type,
                            def_filter, syn_style, exp_style);

  writeln(monitor);
  writeln(monitor);

  if (dwg_exists <0 ) then
    begin
      writeln(monitor);
      writeln(monitor, ' No output files produced due to serious errors.');
    end
  else if PrintCmpExp or PrintCmpSyn or PrintChips then
    begin

      writeln(monitor);
      writeln(monitor,' Starting to generate output files.');

      if PrintCmpExp then 
      begin
        output_expansion_file_type(CmpExp);
        post_compile_time(CmpExp,DATA_FILE);
        output_directives(CmpExp);
      end;

      if PrintCmpSyn then 
      begin
        writeln(CmpSyn,'FILE_TYPE=SYNONYMS;');
      end;

      if PrintChips then 
      begin
        writeln(Chips,'FILE_TYPE=LIBRARY_PARTS ;');
        post_compile_time(Chips,DATA_FILE);
      end;

      doprinting;

      if PrintCmpExp then 
      begin
        writeln(CmpEXp,'END.');
        close_file(CmpExp, CMPEXP_FILE_NAME);
      end;

      if PrintCmpSyn then 
      begin
        writeln(CmpSyn,'END.');
        close_file(CmpSyn, CMPSYN_FILE_NAME);
      end;

      if PrintChips then 
      begin
        writeln(Chips,'END.');
        close_file(Chips, CHIPS_FILE_NAME);
      end;

      write(monitor,'   End of generating output files ');
      exec_time(last_elapsed_time,last_CPU_time,TRUE);

    end;

end { dumpfiles };
