
procedure init_output_continue;
  { set up the output state variables for continuation output }
begin
  column := 0;
end { init_output_continue } ;


procedure print_CRLF_continue(var f: textfile);
  { print a CRLF to the given file (F) and set column to 0 }
begin
  writeln(f);  column := 0;
end { print_CRLF_continue } ;


procedure print_char_continue(var f: textfile; ch: char);
  { print the given string (STR) to the given file (F).  If the current
    line is overflowed (MAX_OUTPUT_FILE_LENGTH), print a continuation
    character and continue on the next line. }
begin
  if column >= MAX_OUTPUT_FILE_LENGTH-2 then
    begin  writeln(f, CONTINUATION_CHAR);  column := 0;  end;

  write(f, ch);  column := column + 1;
end { print_char_continue } ;


procedure print_string_continue(var f: textfile; str: xtring);
  { print the given string (STR) to the given file (F).  If the current
    line is overflowed (MAX_OUTPUT_FILE_LENGTH), print a continuation
    character and continue on the next line.  Use this only to print
    things known to contain no quotes (such as identifiers). }
  var
    start,len: string_range;
    stop: integer;  { may exceed MAX_STRING_LENGTH by 1 }
    hack: string_hack;
begin
  len := ord(str^[0]);  
  stop := 1;
  while stop <= len do
    begin
      if column >= MAX_OUTPUT_FILE_LENGTH-2 then
	begin  writeln(f, CONTINUATION_CHAR);  column := 0;  end;
      start := stop;
      while (stop <= len) and (column < MAX_OUTPUT_FILE_LENGTH - 2) do
	begin
	  column := column + 1;
	  stop := stop + 1;
	end;
      hack.i := ord(str) + start;
      write(f, hack.s^:(stop - start));
    end;
end { print_string_continue } ;


procedure print_string_repeat_quotes_continue(var f: textfile; str: xtring);
  { print the given string (STR) to the given file (F).  Double any
    embedded quoted in the string.  If the current line is overflowed
    (MAX_OUTPUT_FILE_LENGTH), print a continuation character and
    continue on the next line. }
  var
    start,len: string_range;
    stop: integer;  { may exceed MAX_STRING_LENGTH by 1 }
    hack: string_hack;
    found_quote: boolean;
begin
  len := ord(str^[0]);  
  stop := 1;
  while stop <= len do
    begin
      if column >= MAX_OUTPUT_FILE_LENGTH-2 then
	begin  writeln(f, CONTINUATION_CHAR);  column := 0;  end;
      start := stop;  found_quote := FALSE;
      while (stop <= len) and (column < MAX_OUTPUT_FILE_LENGTH - 2) and
        not found_quote do
	begin
	  column := column + 1;
	  found_quote := str^[stop] = OUTPUT_QUOTE_CHAR;
	  stop := stop + 1;
	end;
      hack.i := ord(str) + start;
      write(f, hack.s^:(stop - start));
      if found_quote then print_char_continue(f, OUTPUT_QUOTE_CHAR);
    end;
end { print_string_repeat_quotes_continue } ;


procedure print_string_quoted_continue(var f: textfile; str: xtring);
  { print the given string (STR) quoted to the given file (F).  Double
    any embedded quoted in the string.  If the current
    line is overflowed (MAX_OUTPUT_FILE_LENGTH), print a continuation
    character and continue on the next line. }
begin
  print_char_continue(f, OUTPUT_QUOTE_CHAR);
  print_string_repeat_quotes_continue(f, str);
  print_char_continue(f, OUTPUT_QUOTE_CHAR);
end { print_string_quoted_continue } ;


procedure print_alpha_continue(var f: textfile; name: alpha);
  { print the given alpha (NAME) to the given file (F).  If the current
    line is overflowed (MAX_OUTPUT_FILE_LENGTH), print a continuation
    character and continue on the next line. }
  var
    i: id_range;        { index into the alpha }
begin
  for i := 1 to alpha_length(name) do
    begin
      if column >= MAX_OUTPUT_FILE_LENGTH-2 then
        begin  writeln(f, CONTINUATION_CHAR);  column := 0;  end;

      write(f, name[i]);  column := column + 1;
    end;
end { print_alpha_continue } ;


procedure print_integer_continue(var f: textfile; num: longint);
  { print the given integer (NUM) to the given file (F).  If the current
    line is overflowed (MAX_OUTPUT_FILE_LENGTH), print a continuation
    character and continue on the next line. }


  procedure print_integer_digit(number: longint);
    { print one digit of the current number after printing out MSDs }
  begin
    if number > 9 then print_integer_digit(number DIV 10);

    if column >= MAX_OUTPUT_FILE_LENGTH-2 then
      begin  writeln(f, CONTINUATION_CHAR);  column := 0;  end;

    write(f, number MOD 10:1);  column := column + 1;
  end { print_integer_digit } ;


begin { print_integer_continue }
  if num < 0 then
    begin  print_char_continue(f, '-');  num := ABS(num);  end;

  print_integer_digit(num);
end { print_integer_continue } ;



procedure output_configuration(var f: textfile; indent: natural_number);
  { output all configuration to the specified file.  Indentation can be
    specified. }
  var
    config_index: configure_types;       { index into configuration table }
    syntax_index: signal_syntax_range;   { index into syntax table }


  procedure dump_char(ch: char);
    { output the character;  print NULL if null }
  begin
    if ch = chr(255) then write(f, '''''') else write(f, '''', ch, '''');
  end { dump_char } ;


begin { output_configuration }
  { output signal syntax order }

  if indent > 0 then write(f, ' ':indent);

  write(f, 'SYNTAX = ');

  for syntax_index := 1 to SYNTAX_TABLE_SIZE do
    if signal_syntax_table[syntax_index] <> NULL_SPECIFIER then
      begin
        write(f, '<');
        writealpha(f, syntax_specifier_names[
                                    signal_syntax_table[syntax_index]]^.name);
        write(f, '> ')
      end;
  writeln(f, ';');

  { output the configurable portions of the signal syntax }

  for config_index := succ(FIRST_CONFIGURE_SPECIFIER) to
                                             pred(LAST_CONFIGURE_SPECIFIER) do
    begin
      if indent > 0 then write(f, ' ':indent);

      writealpha(f, configure_specifiers[config_index]^.name);

      write(f, ' = ');

      case config_index of
        CONFIGURE_SUBRANGE:
            if subrangesy = COLON then write(f, ''':''')
                                  else write(f, '''..''');

        CONFIGURE_BIT_ORDERING:
            if left_to_right then write(f, 'LEFT_TO_RIGHT')
                             else write(f, 'RIGHT_TO_LEFT');

        CONFIGURE_LOW_ASSERTED:
            dump_char(signal_is_asserted_low_char);

        CONFIGURE_HIGH_ASSERTED:
            dump_char(signal_is_asserted_high_char);

        CONFIGURE_NEGATION:
            dump_char(signal_negation_char);

        CONFIGURE_NAME_PREFIX:
{           dump_char(name_property_prefix_char); }
            write(f, '''!''');

        CONFIGURE_GENERAL_PREFIX:
            dump_char(general_property_prefix_char);

        CONFIGURE_CONCATENATION:
            write(f, ''':''');
      end { case } ;

      writeln(f, ';');
    end;
end { output_configuration } ;

procedure output_directives(var f: textfile);
  { output the directives block }
begin
  init_output_continue;

  writeln(f, 'DIRECTIVES');

  print_alpha_continue(f, ' RELEASE=       ');
  print_string_quoted_continue(f, vversion);
  print_char_continue(f, ';');
  print_CRLF_continue(f);

  print_alpha_continue(f, ' ROOT_DRAWING=  ');
  print_string_quoted_continue(f, root_macro_name);
  print_char_continue(f, ';');
  print_CRLF_continue(f);

  output_configuration(f, 1);

end { output_directives } ;





procedure output_expansion_file_type(var f: textfile);
  { output the FILE_TYPE header to the given file.  The actual file type
    is determined by the type of compilation being  performed. }
begin
  print_alpha_continue(f, ' FILE_TYPE=     ');
  print_alpha_continue(f, specified_compile_type^.name);
  print_char_continue(f, '_');
  print_alpha_continue(f, EXPANSION_FILE_TYPE);
  print_char_continue(f, ';');
  print_CRLF_continue(f);
end { output_expansion_file_type } ;

