  {------- string variables and string table ---------------}

  free_strings: array [1..33] of freeptr;  { list of free strings (by size) }
  s_length: array [1..33] of 0..256;       { list of possible string lengths }
  free_pointers: freeptr;                  { list of free "freeptr"s }
  nullstring: xtring;                      { a null string constant }

  string_table: hash_string_table_type;    { table of all strings }


  {-----------------------------  VARS  --------------------------------}




  { -- separate comp string constants -- }

  default_CONTEXT_name: xtring;       { name of context having no parms }

  { -- global info -- }

  root_macro_name: xtring;            { name of root macro for exp tree }

  { -- output state variables -- }

  column: output_line_range;          { current output file column }

  { -- VAX dependent run time calculations -- }

  compile_date: time_string;          { current date }
  start_elapsed_time,                 { compilation start elapsed time }
  last_elapsed_time,                  { previous elpased time value }
  start_CPU_time,                     { compilation start CPU time }
  last_CPU_time: longint;             { previous CPU time value }

 

  { scratch structures for sargv and sargc }

  cli_arg_last : cli_arg_index;        { last defined argument number }
  cli_arg_array: cli_arg_array_type;   { array of arguments }



  { -- error routine constants -- }

  suppress_errors: error_set;         { error messages to suppress }
  scan_past_errors: error_set;        { error really in last symbol }
  warning_errors: error_set;          { warning error numbers }
  oversight_errors: error_set;        { oversight error numbers }
  fatal_errors: error_set;            { all fatal errors }
  echo_to_monitor_errors: error_set;  { errors to be echoed to monitor }
  parse_errors: error_set;            { errors during parsing }
  error_strings: error_type;          { table of error messages }


  { -- error display -- }


  num_oversights,                     { number of oversights encountered }
  num_warnings,                       { number of warnings encountered }
  num_errors: 0..MAXINT;              { number of errors encountered }
  last_error: error_range;            { last error encountered }
  ok_to_print_error: boolean;         { TRUE if last error was printed }
  errors_encountered: error_set;      { all errors encountered }
  




  { -- "constant" symbol tables -- }

  name_table: name_table_type;             { table of identifier names }
  syntax_specifier_names:
              syntax_specifier_name_type;  { names for syntax specification }
  signal_syntax_table:
                signal_syntax_table_type;  { signal syntax specification }


  { -- static information for INSYMBOL -- }

  line_pos: string_range;             { char pos of last char read }
  last_char: char;                    { last char read (for look ahead) }
  last_sym_pos: string_range;         { end of last symbol }
  last_string,                        { last input buffer }
  instring: xtring;                   { text line being parsed from }
  stack: parse_stack;                 { stack of saved parse information }
  how_to_parse: parse_type;           { how to parse the current string }
  read_state: parse_state;            { controls lookahead & initialization }
  valid_chars: radix_characters;      { sets of valid chars by radix }
  current_file: parse_file_type;      { what is current input file }
  radix_width: digit_width_list;      { width (bits) of digit by radix }
  copy_error,                         { TRUE if error occurred in copying }
  copy_input: boolean;                { TRUE if input to be copied }
  current_pos,                        { start of index into copy_buffer }
  copy_pos: string_range;             { index into copy_buffer for copy }
  copy_buffer: char_array;            { buffer used to expand TMs in string }
  parse_SCALDconstants: boolean;      { TRUE indicates look for Radix specs,
                                        etc. FALSE indicates parse decimal
					numbers in vanilla fashion. }


  stack_top: stack_index_range;           { index to top element of stack }
  parse_stack_pointer: stack_index_range; { stack element being parsed OR
                                            (stack_top + 1) indicates parsing
                                            a string not yet on stack }

  { NOTE on use of stack_top and parse_stack_ptr -- stack_top points to the
    top-most element in the stack.  Parse_stack_pointer indicates the
    string currently being parsed, which may not yet be on the stack itself.
    In fact, parse_stack_pointer <= stack_top only when parsing text macro 
    definitions found by insymbol.  A text macro definition string is
    left on the stack until all of its nested macros have been completely
    resolved.  This prevents right-side text macro infinite recursion. 
    See virtual_pop_string, parse_string, and fix_parse_stack for how
    this is done.  virtual_pop_string and fix_parse_stack are used only
    by insymbol. }


  { -- lexical analyzer -- }

  sy: symbols;                        { symbol that was parsed }
  id: identifier;                     { if sy=ident then identifier descrip }
  const_val: longint;                 { if sy=constant then constant value }
  const_width: longint;               { width of the last parsed constant }
  lex_string: xtring;                 { if sy=strings then string value }
  upper_case_strings: boolean;        { upper case all strings }
  input_buffer: xtring;               { string read from the input }
  allowed_key_words: setofsymbols;    { current valid key words }
  subrangesy,                         { symbol for subrange }
  fieldsy: symbols;                   { symbol for field }


  { -- symbol constants -- }

  forbidden_symbols,                  { reserved symbols }
  expression_symbols,                 { symbols used in expressions }
  expansion_keysys,                   { key symbols valid in expansion file }
  directives_keysys,                  { key symbols valid in directives file }
  directory_keysys,                   { key symbols valid in directories }
  signal_keysys,                      { key symbols valid in signals }
  config_keysys,                      { those special user-configured sys }
  propbeginsys: setofsymbols;         { symbols that start property defn }
  

  { -- special name constants -- }

  PASS_string,                        { "PASS" constant string }
  FILTER_string : xtring;             { "FILTER" constant string }


  { -- other constants -- }

  lower_case: set_of_char;            { the lower case letters }
  letters: set_of_char;               { the upper case letters }
  digits: set_of_char;                { set of digits }
  legal_chars: set_of_char;           { all legal (printing) characters }
  identifier_chars: set_of_char;      { valid characters for an identifier }
  directory_file_types:
                  set_of_file_types;  { file types for directories }
  default_attributes: name_type_set;  { default property attributes }
  inheritance_attributes:
                      name_type_set;  { all inheritance attributes }
  signal_inheritance_attributes:
                      name_type_set;  { inheritance attributes for signals }
  permission_attributes:
                      name_type_set;  { all permission attributes }
  parameter_attributes:
                      name_type_set;  { id types that are parameters }
  bodies_with_bindings:
                   set of body_type;  { bodies with bindings sections }


  { -- identifier name constants -- }

  UNDEFINED_identifier,     ALL_identifier,
  X_FIRST_identifier,       X_STEP_identifier,      X_identifier,

  LOCAL_specifier,          GLOBAL_specifier,       ON_specifier,
  OFF_specifier,            L_to_R_specifier,       R_to_L_specifier,

  LOGIC_compile_type,       LOGIC_connectivity,     PRIM_connectivity,
  PART_connectivity,        TIME_connectivity,      SIM_connectivity,

  ABBREV_prop_name,         PATH_prop_name,         SIZE_prop_name,
  EXPR_prop_name,           VERSION_prop_name,      TIMES_prop_name,
  SIG_NAME_prop_name,       SCOPE_prop_name,        NO_WIDTH_prop_name,
  NO_BUBBLE_prop_name,      BUBBLED_prop_name,      NO_ASSERT_prop_name,
  REPLICATION_prop_name,    TERMINAL_prop_name,     TITLE_prop_name,
  SIGNAL_prop_name,         PIN_prop_name,          AUTO_GEN_prop_name,
  BODY_prop_name,           OUTPUT_TYPE_prop_name,  XY_prop_name,
  NEEDS_NO_SIZE_prop_name,  COMMENT_BODY_prop_name, PART_NAME_prop_name,
  HAS_FIXED_SIZE_prop_name, BODY_TYPE_prop_name,    NET_ID_prop_name,
  DIRECTORY_prop_name,      ROTATION_prop_name,     VER_prop_name,
  CONTEXT_prop_name,        WARNING_prop_name,      OVERSIGHT_prop_name,
  ERROR_prop_name,          DRAWING_prop_name,      PAGE_prop_name,
  TYPE_prop_name,           PATH_NAME_prop_name,    TIME_prop_name,

  I_identifier,             S_identifier,           D_identifier,
  R_identifier,             RESERVED_key_name,      UNRESERVED_key_name,

  null_name: name_ptr;               { hash table entries for these names }


  { -- signal name symbols -- }

  signal_negation_symbol,             { indicates a negated signal }
  signal_is_asserted_low_symbol,      { indicates signal is asserted low }
  signal_is_asserted_high_symbol,     { indicates signal is asserted high }
  name_property_prefix_symbol,        { prefix char for name properties }
  general_property_prefix_symbol,     { prefix char for general properties }
  class_name_separator_symbol,        { suffix char for class names }
  concatenation_symbol: symbols;      { used to concatenate signals }
  signal_negation_char,               { character corresponding to above }
  signal_is_asserted_low_char,        { " }
  signal_is_asserted_high_char,       { " }
  name_property_prefix_char,          { " }
  general_property_prefix_char,       { " }
  concatenation_char: char;           { " }
  signal_name_terminators,            { chars that terminate a sig name }
  constant_chars: set_of_char;        { those chars in a signal const }
  
  CONNECTIVITY_file_tail: xtring; { "const" containing CONNECTIVITY_FILE_NAME }


  page_expansion_file_name: xtring;      { current page expansion file name }
  page_list_file_name: xtring;           { current page list file name }

  { -- file vars --}

  Monitor:   textfile;            { status info to terminal }
  CmpExp:    textfile;            { expansion output }
  Chips:     textfile;            { chips file for library parts }
  CmpErr:    textfile;            { error output }
  CmpSyn:    textfile;            { synonum output }
  CmpLst:    textfile;            { list output }
  CmpLog:    textfile;            { log output }
  infile:    textfile;            { compiler directives file }
  CmpStan:   textfile;            { standard input file }


  file_type_list: list_of_file_types;      { "constant" recognized file types }



  standard_property_file: xtring;     { standard property attribute file }
  property_file: file_list_ptr;       { user's property attribute files }


  
  { -- "constant" configuration table -- }
  configure_specifiers:
                configure_specifier_type;  { configure directive params }


  { -- "const" directives tables -- }

  compiler_directive: directive_list;      { compiler directives }
  file_name_directives,                    { directives expecting file names }
  debug_directives,                        { secret debug directives }
  one_time_directives: directive_set;      { those that can only appear once }





  output_file: output_file_list;           { output file names }

  

  { -- global flags: directives -- }

  tokenize_params: boolean;           { TRUE if non-integer param values
                                        are to be tokenized }
  produce_amusing_messages: boolean;  { TRUE if messages should be amusing }
  max_errors: natural_number;         { maximum number of errors before quit }
  display_error_doc: boolean;         { TRUE if error description to be disp }
  display_warnings,                   { warnings displayed if TRUE }
  display_oversights,                 { oversight messages displayed if TRUE }
  found_debug_password,               { TRUE if debug password was uttered }
  found_root_context_password,        { TRUE if context password was uttered }
  ROOT_specified_in_command_line,     { TRUE if root drawing in command line }
  TYPE_specified_in_command_line,     { TRUE if compile type in command line }
  left_to_right: boolean;             { TRUE if bit ordering left to right }  
  specified_compile_type: name_ptr;   { type being compiled for }
  expansion_connectivity: name_ptr;   { name of expansion CONNECTIVITY exten }
  configuration_file: xtring;         { name of file with configuration info }
  exception_code:
               exception_error_type;  { descriptor of run time exception }
  PrintCmpExp,                        { TRUE if CmpExp file to be generated }
  PrintChips,                         { TRUE if Chips file to be generated }
  PrintCmpSyn : boolean;              { TRUE if CmpSyn file to be generated }
  files_to_generate:
            set of output_file_names; { output files to be generated }
  CONTEXT_specified_in_command_line:  { TRUE if context specified in command }
    boolean;                          { line }


  context_name : xtring;              { context value specified }

  default_filter_value,               { default filter for linker }
  page_synonym,                       { synonym style for CMPSYN file }
  single_level_compile : boolean;     { expansion style for CMPEXP file }

  special_compile : boolean;          { true for sim and time compilation }

  property_enum: longint;             { value for property enumeration --
                                        just to allow debugging }
  { -- free list vars -- }

  free_properties: property_ptr;      { head of free properties list }
  free_temp_prop: temp_prop_ptr;      { head of free temp_prop list }
  free_pin: pin_ptr;                  { head of free pin list }
  free_signal: sig_ptr;               { head of free signal list }

