(**)     { ------- read in property properties ------- }


procedure PREDS_read_property_attributes;
  { read the file containing property inheritance information }
  var
    current_property_file: file_list_ptr;  { current attributes file in list }


  procedure process_attributes(file_name: xtring);
    { process the given property attribute file }
    var
      prop_name: name_ptr;          { name of the property read in }
      finished,                     { TRUE when specifier list read }
      done: boolean;                { TRUE when inheritance list read in }
  begin
    if not open_a_file(file_name, standard_file) then
      begin
        error(195 { cannot open attributes file });
        error_dump_file_name(file_name);
      end
    else
      if get_file_type <> property_attributes then
        begin
          error(55 { wrong file });
          error_dump_file_name(file_name);

          if not close_parse_file(standard_file) then
            begin
              error(168 { cannot close file });
              error_dump_file_name(file_name);
            end;
        end
      else
        begin
          { create the parse environment for error reporting }

          push_error_info;
          current_file_name := file_name;

          repeat
            if sy <> IDENT then
              begin  error(1 { expected ident });  skip([SEMI,ENDSY]);  end
            else
              begin
                prop_name := id.name;
                insymbol;

                if sy = colon then insymbol else error(13 { expected : });

                done := FALSE;
                repeat
                  if sy <> IDENT then
                    begin
                      error(1 { expected indent });  skip([SEMI,ENDSY]);
                    end
                  else
                    if id.name^.name = 'PIN_EQUIVALENT  ' then
                      begin
                        insymbol;
                        error(184 { no longer supported });
                        error_dump_indent(indent);
                        error_dump_alpha('Use inherit(PIN)');
                        error_dump_CRLF;

                        prop_name^.kind := prop_name^.kind + [INHERIT_PIN];
                      end
                    else if id.name^.name = 'PARAMETER       ' then
                      begin
                        insymbol;
                        prop_name^.kind := prop_name^.kind + [IS_PARAMETER];
                        if sy = LPAREN then
                          begin
                            insymbol;
                            if sy <> IDENT then error(1 { expected ident });
                            if id.name^.name = 'INTEGER         ' then
                              prop_name^.kind := prop_name^.kind +
                                                            [IS_INT_PARAMETER]
                            else error(48 { unexpected });
                            insymbol;
                            if sy = RPAREN then insymbol
                                           else error(7 { expected ) });
                          end;
                      end
                    else if id.name^.name = 'INHERIT         ' then
                      begin
                        prop_name^.kind := prop_name^.kind -
                                                       inheritance_attributes;
                        insymbol;
                        if sy = LPAREN then insymbol
                                       else error(15 { expected ( });
                        finished := FALSE;
                        repeat
                          if sy = IDENT then
                            begin
                              if id.name = SIGNAL_prop_name then
                                prop_name^.kind := prop_name^.kind +
                                                              [INHERIT_SIGNAL]
                              else if id.name = PIN_prop_name then
                                prop_name^.kind := prop_name^.kind +
                                                                 [INHERIT_PIN]
                              else if id.name = BODY_prop_name then
                                prop_name^.kind := prop_name^.kind +
                                                                [INHERIT_BODY]
                              else
                                error(47 { invalid inheritance specifier });
                              insymbol;
                            end;
                          if sy = COMMA then insymbol else finished := TRUE;
                        until finished;
                        if sy = RPAREN then insymbol
                                       else error(7 { expected ) });
                      end
                    else if id.name^.name = 'PERMIT          ' then
                      begin
                        prop_name^.kind := prop_name^.kind -
                                                        permission_attributes;
                        insymbol;
                        if sy = LPAREN then insymbol
                                       else error(15 { expected ( });
                        finished := FALSE;
                        repeat
                          if sy = IDENT then
                            begin
                              if id.name = SIGNAL_prop_name then
                                prop_name^.kind := prop_name^.kind +
                                                               [PERMIT_SIGNAL]
                              else if id.name = PIN_prop_name then
                                prop_name^.kind := prop_name^.kind +
                                                                  [PERMIT_PIN]
                              else if id.name = BODY_prop_name then
                                prop_name^.kind := prop_name^.kind +
                                                                 [PERMIT_BODY]
                              else
                                error(150 { invalid PERMIT specifier });
                              insymbol;
                            end;
                          if sy = COMMA then insymbol else finished := TRUE;
                        until finished;
                        if sy = RPAREN then insymbol
                                       else error(7 { expected ) });
                      end
                    else if id.name^.name = 'FILTER          ' then
                      begin
                        prop_name^.kind := prop_name^.kind + [DONT_OUTPUT];
                        insymbol;
                      end
                    else if id.name^.name = 'PASS            ' then
                      begin
                        prop_name^.kind := prop_name^.kind - [DONT_OUTPUT];
                        insymbol;
                      end
                    else
                      begin
                        error(48 { unexpected });  skip([SEMI,ENDSY]);
                      end;
                  if sy = COMMA then insymbol else done := TRUE;
                until done;
              end;

            if sy = SEMI then insymbol else error(12 { expected ; });
          until sy <> IDENT;

          if sy = ENDSY then insymbol else error(40 { expected END });
          if sy <> PERIOD then error(37 { expected . });

          if not close_parse_file(standard_file) then
            begin
              error(168 { cannot close file });
              error_dump_file_name(file_name);
            end;

          pop_error_info;
        end;
  end { process_attributes } ;


  procedure process_attribute_directives;
    { process the filter directives.  TRUE means to pass, FALSE to filter. }
    var
      prop: property_ptr;   { current property in the list }
  begin
    prop := properties_assigned_filters;
    while prop <> NIL do
      begin
        if prop^.text = PASS_string then
          prop^.name^.kind := prop^.name^.kind - [DONT_OUTPUT]
        else if prop^.text = FILTER_string then
          prop^.name^.kind := prop^.name^.kind + [DONT_OUTPUT];

        prop := prop^.next;
      end;
  end { process_attribute_directives } ;


  procedure init_attributes(prop_name: name_ptr);
    { initialize the inheritance and permission attributes for the given
      property name }
  begin
    prop_name^.kind := prop_name^.kind - inheritance_attributes
                                       - permission_attributes
                                       - parameter_attributes;
  end { init_attributes } ;


  procedure set_up_default_attributes(var name: name_ptr;
                                      attributes: name_type_set);
    { clear all inheritance attributes for the given name }
  begin
    if attributes * permission_attributes <> [] then
      name^.kind := name^.kind - permission_attributes;

    if attributes * inheritance_attributes <> [] then
      name^.kind := name^.kind - inheritance_attributes;

    if attributes * parameter_attributes <> [] then
      name^.kind := name^.kind - parameter_attributes;

    name^.kind := name^.kind + attributes;
  end { set_up_default_attributes } ;


  procedure welcome;
    { display a message to indicate start of the inheritance read }
  begin
    if PrintCmpLst then
      begin
        writeln(CmpLst);
        writeln(CmpLst, ' *********************************');
        writeln(CmpLst, ' *  Reading property attributes  *');
        writeln(CmpLst, ' *********************************');
        writeln(CmpLst);
      end;
    writeln(monitor);  writeln(monitor, ' Reading property attributes.');
    writeln(CmpLog);  writeln(CmpLog, ' Reading property attributes.');
  end { welcome } ;


begin { PREDS_read_property_attributes }
  welcome;

  init_attributes(PATH_prop_name);
  init_attributes(SIZE_prop_name);
  init_attributes(TIMES_prop_name);
  init_attributes(PATH_prop_name);
  init_attributes(REPLICATION_prop_name);
  init_attributes(TITLE_prop_name);
  init_attributes(EXPR_prop_name);
  init_attributes(VERSION_prop_name);
  init_attributes(ABBREV_prop_name);
  init_attributes(SCOPE_prop_name);
  init_attributes(PART_NAME_prop_name);
  init_attributes(TERMINAL_prop_name);
  init_attributes(NET_ID_prop_name);
  init_attributes(NEEDS_NO_SIZE_prop_name);
  init_attributes(HAS_FIXED_SIZE_prop_name);
  init_attributes(COMMENT_BODY_prop_name);
  init_attributes(NO_WIDTH_prop_name);
  init_attributes(NO_ASSERT_prop_name);
  init_attributes(NO_BUBBLE_prop_name);
  init_attributes(CARDINAL_TAP_prop_name);
  init_attributes(BODY_TYPE_prop_name);
  init_attributes(X_identifier);
  init_attributes(X_FIRST_identifier);
  init_attributes(X_STEP_identifier);


  { read the Valid supplied property attributes }


  if DATA_SERVICES_FLAG = 0 then
    begin
      allowed_key_words := directory_keysys;

      if standard_property_file <> nullstring then
        process_attributes(standard_property_file);


      { read the user supplied property attributes }

      current_property_file := property_file;
      while current_property_file <> NIL do
        begin
          process_attributes(current_property_file^.file_name);
          current_property_file := current_property_file^.next;
        end;

      allowed_key_words := [];
    end
  else
    begin
    end;    


  { set up some internal property attributes }

  set_up_default_attributes(SIZE_prop_name,           [PERMIT_BODY,
                                                       IS_PARAMETER,
                                                       IS_INT_PARAMETER]);
  set_up_default_attributes(TIMES_prop_name,          [PERMIT_BODY,
                                                       IS_PARAMETER,
                                                       IS_INT_PARAMETER]);
  set_up_default_attributes(PATH_prop_name,           [PERMIT_BODY]);
  set_up_default_attributes(REPLICATION_prop_name,    [PERMIT_SIGNAL]);
  set_up_default_attributes(TITLE_prop_name,          [PERMIT_BODY]);
  set_up_default_attributes(EXPR_prop_name,           [PERMIT_BODY]);
  set_up_default_attributes(VERSION_prop_name,        [PERMIT_BODY]);
  set_up_default_attributes(ABBREV_prop_name,         [PERMIT_BODY]);
  set_up_default_attributes(SCOPE_prop_name,          [PERMIT_SIGNAL]);
  set_up_default_attributes(PART_NAME_prop_name,      [PERMIT_BODY]);
  set_up_default_attributes(TERMINAL_prop_name,       [PERMIT_BODY]);
  set_up_default_attributes(NET_ID_prop_name,         [PERMIT_SIGNAL]);
  set_up_default_attributes(NEEDS_NO_SIZE_prop_name,  [PERMIT_BODY]);
  set_up_default_attributes(HAS_FIXED_SIZE_prop_name, [PERMIT_BODY]);
  set_up_default_attributes(COMMENT_BODY_prop_name,   [PERMIT_BODY]);
  set_up_default_attributes(NO_WIDTH_prop_name,       [PERMIT_SIGNAL,
                                                       DONT_OUTPUT]);
  set_up_default_attributes(NO_ASSERT_prop_name,      [PERMIT_PIN,
                                                       DONT_OUTPUT]);
  set_up_default_attributes(CARDINAL_TAP_prop_name,   [PERMIT_PIN,
                                                       DONT_OUTPUT]);
  set_up_default_attributes(NO_BUBBLE_prop_name,      [PERMIT_PIN,
                                                       DONT_OUTPUT]);
  set_up_default_attributes(BODY_TYPE_prop_name,      [PERMIT_BODY]);
  set_up_default_attributes(X_identifier,             [IS_PARAMETER,
                                                       DONT_OUTPUT]);
  set_up_default_attributes(X_FIRST_identifier,       [PERMIT_BODY,
                                                       DONT_OUTPUT]);
  set_up_default_attributes(X_STEP_identifier,        [PERMIT_BODY,
                                                       DONT_OUTPUT]);

  process_attribute_directives;

  write(monitor, '   Property attributes read ');
  write(CmpLog, '   Property attributes read ');
  exec_time(last_elapsed_time, last_CPU_time, TRUE);
end { PREDS_read_property_attributes } ;


