
(**)     { ------- generate an expanded string ------- }


function expand_text_macros(TM_name: name_ptr; str: xtring): xtring;
  { expand all the text macros in the input string (str) and return the
    exanded string.  If TM_name is an integer parameter, then identifiers
    are logged as hard expandable ids, else they are logged as soft. }
  var
    s: xtring;                  { string to be created }
    pos: string_range;          { position within the string for copy }
    save_debug: boolean;
begin
  if debug_33 then
    begin
      save_debug := debug;  debug := TRUE;
    end;

  copy_input := TRUE;  current_pos := 0;  copy_error := FALSE;
  if TM_name = NIL then assert(215 { not ok! });

  parse_string(str, PARSE_SEPARATELY);
  while (sy <> ENDOFDATASY) and not copy_error do
    begin  
      current_pos := copy_pos;  
      insymbol;  
    end;

  if copy_error then
    begin
      error(116 { expanded string exceeds the max length });
      error_dump_text_macro(TM_name);
    end;

  pop_parsed_string(str);
  create_a_string(s, copy_pos);
  for pos := 1 to copy_pos do s^[pos] := copy_buffer[pos];
  expand_text_macros := enter_and_release_string(s);
  copy_input := FALSE;  copy_error := FALSE;

  if debug_33 then debug := save_debug;
end { expand_text_macros } ;


function find_text_macro(node: mtree_node_ptr; text_macro_name: name_ptr):
                                                                       xtring;
  { find the given text macro starting at the given node.  Return the
    definition of the text macro.  If it cannot be found, return NULL. }
  var
    curr_node: mtree_node_ptr;      { current mtree node }
    id: identifier_ptr;             { identifier from table }
    found: boolean;                 { TRUE if name found in the table }
begin
  if text_macro_name^.definition <> nullstring then
    find_text_macro := text_macro_name^.definition
  else
    begin
      find_text_macro := nullstring;

      curr_node := node;  found := FALSE;
      while (curr_node <> NIL) and not found do
        if found_id(curr_node, text_macro_name, id) then
          found := TRUE
        else
          curr_node := curr_node^.father_node;

      if found then
        find_text_macro := id^.definition;
    end;
end { find_text_macro } ;


