
(**)     { ------- expand text macros in property values ------- }


function TM_prefix_in_string(str: xtring): boolean;
  { return TRUE iff the text macro prefix char exists in the string }
  var
    found: boolean;     { TRUE iff we find it }
    i: string_range;    { index into str }
begin
  found := FALSE;  i := 0;
  while not found and (i < ord(str^[0])) do
    if str^[i] = TM_PARAMETER_PREFIX_CHAR then found := TRUE
    else i := i + 1;
  TM_prefix_in_string := found;
end { TM_prefix_in_string } ;


function expand_property_value_TMs(node: mtree_node_ptr;
                                   property_name: name_ptr;
                                   property_val: xtring): xtring;
  { expand any text macros found and return the result. node gives the
    context. NOTE: property_val is never assigned to anything here, so
    this proc does nothing to prevent the calling procedure from releasing
    it later.  The result is, however, entered in the string table. }
  type
    buffer_index = 0..ID_LENGTH;

  var
    result: xtring;        { expanded value }
    ch: char;              { current character from the input string }
    delimiter_char: char;  { character delimiting text macro }
    index: string_range;   { index into the current string }
    j: buffer_index;       { index into the text macro name }
    done: boolean;         { TRUE when text macro name found }
    buffer: alpha;         { text buffer for text macro }
    text_macro: name_ptr;  { text macro name to be expanded }
    definition: xtring;    { text macro definition }
    ovf_error: boolean;    { TRUE if overflow error has been found }
    found_error: boolean;  { TRUE if error with formation of current id has
                             been found }


  procedure get_char(var ch: char);
    { get the next character from the input string }
  begin
    if index < ord(property_val^[0]) then
      begin  index := index + 1;  ch := property_val^[index];  end
    else
      ch := chr(EOL);
  end { get_char } ;
    
    
  procedure report_overflow_error;
    { if not already done, report that the result has overflowed. }
  begin
    if not ovf_error then
      begin
        error(22 { string overflow });
        error_dump_body_node(node);
        error_dump_property(property_name, property_val);
        error_dump_expanded_value(result);
        ovf_error := TRUE;
      end;
  end { report_overflow_error } ;


  procedure dump_buffer(end_of_buffer: buffer_index);
    { copy the buffer to the result }
    var
      i: buffer_index;      { index into the buffer }
  begin
    if not add_char_to_string(result, TM_PARAMETER_PREFIX_CHAR) then
      report_overflow_error;
    for i := 1 to end_of_buffer do
      if not add_char_to_string(result, buffer[i]) then
        report_overflow_error;
  end { dump_buffer } ;
    
    
begin { expand_property_value_TMs }
  if debug_18 then
    begin
      write(outfile, 'Entering expanded_property_value_TMs: node=');
      if node = NIL then writeln(outfile, '<NIL>')
      else
        begin
          print_string(outfile, node^.macro_name);  writeln(outfile);
        end;
      writeln(outfile, 'Property name=', property_name^.name);
      write(outfile, 'Property value=');
      print_string(outfile, property_val);
      writeln(outfile);
    end;

  create_a_string(result, MAX_STRING_LENGTH);  result^[0] := chr(0);

  index := 0;  get_char(ch);  ovf_error := FALSE;
  while not ovf_error and (ch <> chr(EOL)) do
    begin
      if ch <> TM_PARAMETER_PREFIX_CHAR then
        begin
          if not add_char_to_string(result, ch) then report_overflow_error;
          get_char(ch);
        end
      else
        begin
          if debug_18 then writeln(outfile, '--found TM');

          get_char(ch);    { eat the '%' prefix }

          if (ch = '''') or (ch = '"') then
            begin  delimiter_char := ch;  get_char(ch);  end
          else
            delimiter_char := ' ';

          found_error := FALSE;
          buffer := NULL_ALPHA;  j := 0;  done := FALSE;
          while (ch <> chr(EOL)) and not done do
            if delimiter_char = ' ' then
              if isidentchar[ch] then
                begin
                  if j < ID_LENGTH then
                    begin  j := j + 1;  buffer[j] := ch;  end;
                  get_char(ch);
                end
              else
                done := TRUE
            else
              if ch = delimiter_char then
                begin  get_char(ch);  done := TRUE;  end
              else
                begin
                  if isidentchar[ch] then
                    begin
                      if j < ID_LENGTH then
                        begin  j := j + 1;  buffer[j] := ch;  end;
                    end
                  else if not found_error then
                    begin
                      error(126 { text macro name is not an identifier });
                      error_dump_body_node(node);
                      error_dump_property(property_name, property_val);
                      found_error := TRUE;
                    end;
                  get_char(ch);
                end;

          { text macro name has been removed from the input string.
            Find the text macro in the current symbol table }

          if debug_18 then writeln(outfile, '--TM found=', buffer);

          if not isupper[buffer[1]] then
            { not a text macro name - maybe just some character }
            dump_buffer(j)
          else
            begin
              text_macro := enter_name(buffer);
	      enter_expandable_id(text_macro);
              definition := find_text_macro(node, text_macro);

              if debug_18 then
                begin
                  writeln(outfile, '--TM def=');
                  print_string_with_quotes(outfile, definition);
                  writeln(outfile);
                end;

              if definition = nullstring then
                begin
                  error(106 { TM does not exist });
                  error_dump_body_node(node);
                  error_dump_property(text_macro, nullstring);
                  error_dump_text_macro(text_macro);
                end
              else
                { to allow nested text macros, place recursive call here.
                  Need to pay attention to the node! }

                if not add_string_to_string(result, definition) then
                  report_overflow_error;
            end;
        end;
    end { while } ;

  expand_property_value_TMs := enter_string(result);

  result^[0] := chr(MAX_STRING_LENGTH);
  release_string(result);
end { expand_property_value_TMs } ;


function expand_property_list_TMs(node: mtree_node_ptr;
                                  props: property_ptr): property_ptr;
  var
    prop: property_ptr;        { current property }
    result: property_ptr;      { list for return }
    exp_value: xtring;         { current expanded property value }
  { return a list of properties with values expanded. order is assumed to
    be unimportant }
begin
  prop := props;  result := NIL;
  while prop <> NIL do
    begin
      exp_value := expand_property_value_TMs(node, prop^.name, prop^.text);
      add_to_prop_list(result, prop^.name, exp_value);
      prop := prop^.next;
    end;
  expand_property_list_TMs := result;
end { expand_property_list_TMs } ;


