(**)    { ------- initialization routines ------- }


#if VAX
procedure init_comp_vms;  external;
#endif
 


procedure init;
  { initialize global (and some local) 'constants' and vars }


  procedure init_keywords;
    { init macro keywords }
    var
      id: alpha;              { key word to be added }
      sy: symbols;            { corresponding symbol for the key word }
    

    procedure add_keyword;
      { add the key word to the name table and set its value }
      var
        name: name_ptr;       { name to be added to the name table }
    begin
      name := enter_name(id);
      if KEY_WORD in name^.kind then assert(159 { name already there })
      else
        begin  name^.kind := name^.kind + [KEY_WORD];  name^.sy := sy;  end;
    end { add_keyword } ;
      

  begin { init_keywords }
    id := 'OR              ';  sy := ORSY;           add_keyword;
    id := 'XOR             ';  sy := XORSY;          add_keyword;
    id := 'AND             ';  sy := ANDSY;          add_keyword;
    id := 'MOD             ';  sy := MODSY;          add_keyword;
    id := 'NOT             ';  sy := NOTSY;          add_keyword;
    id := 'ABS             ';  sy := ABSSY;          add_keyword;
    id := 'ORD             ';  sy := ORDSY;          add_keyword;
    id := 'MAX             ';  sy := MAXSY;          add_keyword;
    id := 'MIN             ';  sy := MINSY;          add_keyword;
    id := 'END             ';  sy := ENDSY;          add_keyword;
    id := 'MACRO           ';  sy := MACROSY;        add_keyword;
    id := 'END_MACRO       ';  sy := ENDMACROSY;     add_keyword;
    id := 'INVOKE          ';  sy := INVOKESY;       add_keyword;
    id := 'END_INVOKE      ';  sy := ENDINVOKESY;    add_keyword;
    id := 'PROPERTY        ';  sy := PROPERTYSY;     add_keyword;
    id := 'END_PROPERTY    ';  sy := ENDPROPERTYSY;  add_keyword;
    id := 'PIN             ';  sy := PINSY;          add_keyword;
    id := 'END_PIN         ';  sy := ENDPINSY;       add_keyword;
    id := 'BODY            ';  sy := BODYSY;         add_keyword;
    id := 'END_BODY        ';  sy := ENDBODYSY;      add_keyword;
    id := 'BINDINGS        ';  sy := BINDINGSY;      add_keyword;
    id := 'END_BINDINGS    ';  sy := ENDBINDSY;      add_keyword;
    id := 'PARAMETER       ';  sy := PARAMETERSY;    add_keyword;
    id := 'END_PARAMETER   ';  sy := ENDPARAMETERSY; add_keyword;
    id := 'FILE_TYPE       ';  sy := FILETYPESY;     add_keyword;
  end { init_keywords } ;
      

  procedure init_assertions;
    { init the assertion messages }
  begin
    assert_strings[0]   := 'Unimplemented assertion message             ';
    assert_strings[1]   := 'Reassignment of path element forbidden      ';
    assert_strings[2]   := 'Null path element found in add_path_elem    ';
    assert_strings[3]   := 'Path length exceeded in add_path_element    ';
    assert_strings[4]   := 'NULL string passed to evaluate_string       ';
    assert_strings[5]   := 'Tried to fix instance of non_UNDEFINED      ';
    assert_strings[6]   := 'Non vector signal has non-NIL subscript     ';
    assert_strings[7]   := 'String pointers not at end in insert_quo    ';
    assert_strings[8]   := 'Parse stack underflow                       ';
    assert_strings[9]   := 'Expected a constant describing the net      ';
    assert_strings[10]  := 'Expected ,                                  ';
    assert_strings[11]  := 'Body properties are not permitted here      ';
    assert_strings[12]  := 'Expected END_BODY symbol                    ';
    assert_strings[13]  := 'Pin properties are not permitted here       ';
    assert_strings[14]  := 'Expected pin name string                    ';
    assert_strings[15]  := 'Expected END_PIN symbol                     ';
    assert_strings[16]  := 'Expected END_PARAMETER                      ';
    assert_strings[17]  := 'Expected identifier = EXPR, not this        ';
    assert_strings[18]  := 'Expected a string                           ';
    assert_strings[19]  := 'Expected a constant                         ';
    assert_strings[20]  := 'Unexpected symbol in property body          ';
    assert_strings[21]  := 'Expected END_PROPERTY symbol                ';
    assert_strings[22]  := 'Expected BINDINGS                           ';
    assert_strings[23]  := 'Expected formal parameter name string       ';
    assert_strings[24]  := 'Expected actual parameter name string       ';
    assert_strings[25]  := 'Expected END_BINDINGS                       ';
    assert_strings[26]  := 'Expected macro name                         ';
    assert_strings[27]  := 'Expected END_INVOKE                         ';
    assert_strings[28]  := 'Expected MACRO                              ';
    assert_strings[29]  := 'Unexpected symbol in macro definition       ';
    assert_strings[30]  := 'Expected END_MACRO                          ';
    assert_strings[31]  := 'Illegal width in convert_into_binary        ';
    assert_strings[32]  := 'Expected signal name string                 ';
    assert_strings[33]  := 'X is already in the symbol table            ';
    assert_strings[34]  := 'Expected END                                ';
    assert_strings[35]  := 'Expected ;                                  ';
    assert_strings[36]  := 'Parameter not found in table: expansion     ';
    assert_strings[37]  := 'PATH property not found for invocation      ';
    assert_strings[38]  := 'Undefined formal CSP not found in list      ';
    assert_strings[39]  := 'Created abbreviation not valid              ';
    assert_strings[40]  := 'New synonym lst width incompatible w/old    ';
    assert_strings[41]  := 'Formal/actual list not NIL to evaluate      ';
    assert_strings[42]  := 'Illegal width to resolve undefined inst     ';
    assert_strings[43]  := 'Parameter is not a text macro!              ';
    assert_strings[44]  := 'Expected .                                  ';
    assert_strings[45]  := 'Left and right margins invalid              ';
    assert_strings[46]  := 'Path string has no room!  What happened?    ';
    assert_strings[47]  := 'Parameter is not a text macro!              ';
    assert_strings[48]  := 'Parameter not found in table: P1 status     ';
    assert_strings[49]  := 'Expected property value string              ';
    assert_strings[50]  := 'No appending bit in middle of sub list      '; 
    assert_strings[51]  := 'NIL args to copy subscript element          '; 
    assert_strings[52]  := 'Non-NIL args to copy subscript              '; 
    assert_strings[53]  := 'NIL subscript passed to bit in range        '; 
    assert_strings[54]  := 'NIL sig desc passed to width of sig desc    '; 
    assert_strings[55]  := 'NIL sig inst passed to size of sig inst     '; 
    assert_strings[56]  := 'NIL sig inst passed to width of sig inst    '; 
    assert_strings[57]  := 'NIL subscript passed to find subscript      '; 
    assert_strings[58]  := 'Too small ordinal into nth_bit_subscript    '; 
    assert_strings[59]  := 'Too big ordinal into nth_bit_subscript      '; 
    assert_strings[60]  := 'NIL CS passed to find_bit_in_CS             '; 
    assert_strings[61]  := 'Too big ordinal passed to find_bit_in_CS    '; 
    assert_strings[62]  := 'Bad sub to resolve_instance_of_parameter    '; 
    assert_strings[63]  := 'Non-empty sub to resolve_instance_of_par    '; 
    assert_strings[64]  := '<BAD> basescript to find_basescript         ';
    assert_strings[65]  := 'NIL SD or sig_def passed add_SD_onto_PCS    ';
    assert_strings[66]  := 'Too small ordinal into leading_n_bits...    '; 
    assert_strings[67]  := 'Too big ordinal into leading_n_bits_o...    '; 
    assert_strings[68]  := 'Invalid arguments into create_synonym       '; 
    assert_strings[69]  := 'NIL sig def passed to width_of_sig_def      '; 
    assert_strings[70]  := 'Non-NIL destination ptr in copy_property    '; 
    assert_strings[71]  := 'NIL formal passed to resolve_instance_of    ';
    assert_strings[72]  := 'NIL CSL to find youngest mtree node         '; 
    assert_strings[73]  := 'NIL sig inst to synonym_signal_instances    ';
    assert_strings[74]  := 'NIL arg passed to new_SD_for_create_syno    '; 
    assert_strings[75]  := 'Arg with undef width to create_synonyms     '; 
    assert_strings[76]  := 'Bad first argument passed to map_bit        '; 
    assert_strings[77]  := 'Bad second argument passed to map_bit       '; 
    assert_strings[78]  := 'Processed def into find_base_of_signal1     ';
    assert_strings[79]  := 'Bad bit subscript in find_base_of_signal    ';
    assert_strings[80]  := 'Bad rep_factor passed to replicate_CS       ';
    assert_strings[81]  := 'NIL sig inst into find_base_of_sig_insta    ';
    assert_strings[82]  := 'Real bad sub into find_base_of_sig_insta    ';
    assert_strings[83]  := 'Bad sub into find_base_of_signal_instanc    ';
    assert_strings[84]  := 'Incompatible widths in is_same_constant     ';
    assert_strings[85]  := 'Subscript already > width in insert_subs    ';
    assert_strings[86]  := 'Undefined width SD in augment_sig_descri    ';
    assert_strings[87]  := 'Undefined width SD in augment_sig_descri    ';
    assert_strings[88]  := 'Fix_no_width_signal failed to converge      ';
    assert_strings[89]  := 'Inconsistent width assign in insert_sub1    ';
    assert_strings[90]  := 'Incorrect sub on def & desc in quick_res    ';
    assert_strings[91]  := 'Sig def is undef and desc is VEC or UND     ';
    assert_strings[92]  := 'Out of range sub in synonym_1st_BD_to...    ';
    assert_strings[93]  := 'Convergence failure in fix_no_width_sig1    ';
    assert_strings[94]  := 'Ref of a bit of formal with undef. width    ';
    assert_strings[95]  := 'SI with undef width in insert_subscript1    ';
    assert_strings[96]  := 'No bit lists to insert_subscript1           ';
    assert_strings[97]  := 'Horrible error in synonym bag list          ';
    assert_strings[98]  := 'Width of CS <> width of synonyn element     ';
    assert_strings[99]  := 'Out of range sub in get_next_base_bit       ';
    assert_strings[100] := '1 bit lookup find_base_of_base_desc fail    ';
    assert_strings[101] := 'Out of range offset in subrange_occurs_i    ';
    assert_strings[102] := 'NIL base descriptro to find_base_of_base    ';
    assert_strings[103] := 'Bogus bit number in find_base_of_base_of    ';
    assert_strings[104] := 'Inst with undef width in find_base_of_ba    ';
    assert_strings[105] := 'Bogus bit number in find_base_of_base_of    ';
    assert_strings[106] := 'Quick_synonym failed on 1 bit wide args     ';
    assert_strings[107] := 'Net number not found in the net table       ';
    assert_strings[108] := 'Net already entered in the net table        ';
    assert_strings[109] := 'n is too big in nth_bit_of_signal_inst      ';
    assert_strings[110] := 'signal has undef width in nth_bit_sig_in    ';
    assert_strings[111] := 'n outside rang in nth_bit_signal_inst       ';
    assert_strings[112] := 'WHAT? delete_subscript_element(NIL) ???     ';
    assert_strings[113] := 'Expected identifier.                        ';
    assert_strings[114] := 'Expected #                                  ';
    assert_strings[115] := 'Expected $                                  ';
    assert_strings[116] := 'Unexpected end of data.                     ';
    assert_strings[117] := 'Expected &                                  ';
    assert_strings[118] := 'Expected +                                  ';
    assert_strings[119] := 'Expected D                                  ';
    assert_strings[120] := 'Expected :<time> or rest of page spec       ';
    assert_strings[121] := 'Expected id/macro lists or next page        ';
    assert_strings[122] := 'Expected #<constant> (a numbered id)        ';
    assert_strings[123] := 'Expected $<constant> (a numbered string)    ';
    assert_strings[124] := 'Dictionary entry number out of range        ';
    assert_strings[125] := 'Expected macro list or next page            ';
    assert_strings[126] := 'Expected parm list or next context          ';
    assert_strings[127] := 'Expected (                                  ';
    assert_strings[128] := 'Expected %                                  ';
    assert_strings[129] := 'Expected :R or next item.                   ';
    assert_strings[130] := 'Expected <constant> or $<constant>          ';
    assert_strings[131] := '                                            ';
    assert_strings[132] := 'Expected -                                  ';
    assert_strings[133] := 'NIL formal_actual to gather_pin_properti    ';
    assert_strings[134] := 'NIL macro to a UNIX directory routine       ';
    assert_strings[135] := 'NIL node^.called_by on non-root node        ';
    assert_strings[136] := 'Non-canonical bit order in synonyms tabl    ';
    assert_strings[137] := 'Base cannot be found for signal instance    ';
    assert_strings[138] := 'Too many passes in find base                ';
    assert_strings[139] := 'Undefined signal in find base               ';
    assert_strings[140] := 'Bit must occur on base_BD                   ';
    assert_strings[141] := 'NIL list of actuals in synonyms_actuals     ';
    assert_strings[142] := 'Error in build_SI_from_SD                   ';
    assert_strings[143] := 'Offset into scalar signal                   ';
    assert_strings[144] := 'NIL list of actuals in de_NC_return_actu    ';
    assert_strings[145] := 'PCS is too short in get_bit_of_PCS          ';
    assert_strings[146] := 'NIL PCS in get_bit_of_PCS                   ';
    assert_strings[147] := 'Bad property attr in old_copy_props_to_b    ';
    assert_strings[148] := 'nth_bit_sub ret FALSE in merge_subscrip     ';
    assert_strings[149] := 'NIL instance passed to nth_bit_subscr       ';
    assert_strings[150] := 'Expected version constant                   ';
    assert_strings[151] := 'Expected page number                        ';
    assert_strings[152] := 'Expected file name for macro definition     ';
    assert_strings[153] := 'UNNAMED signal cannot have width            ';
    assert_strings[154] := 'Duplicate parameter found in create_symb    ';
    assert_strings[155] := 'Structure has already been defined          ';
    assert_strings[156] := 'Duplicate text macro definition found       ';
    assert_strings[157] := 'Popped string has wrong parse state         ';
    assert_strings[158] := 'Expected )                                  ';
    assert_strings[159] := 'Key word already found in the name table    ';
    assert_strings[160] := 'TM recursion depth counter underflow        ';
    assert_strings[161] := 'Parse environment stack underflow           ';
    assert_strings[162] := 'Reserved text macro has invalid attribut    ';
    assert_strings[163] := 'NIL subscript for vector                    ';
    assert_strings[164] := 'Expected :                                  ';
    assert_strings[165] := 'Pin property found on non-existent pin      ';
    assert_strings[166] := 'Actual signal is NIL in output_expansion    ';
    assert_strings[167] := 'Non-NIL subscript in fix_instance_width     ';
    assert_strings[168] := 'Could not find old instance for VECTOR      ';
    assert_strings[169] := 'Tried to open two files at once             ';
    assert_strings[170] := 'Tried to open UNKNOWN file type             ';
    assert_strings[171] := 'Tried to close file type not open           ';
    assert_strings[172] := 'Tried to close UNKNOWN file type file       ';
    assert_strings[173] := 'Tried to read file not opened               ';
    assert_strings[174] := 'Constant found at non-root node             ';
    assert_strings[175] := 'Binding has NIL formal and pin name         ';
    assert_strings[176] := 'Expected general property prefix symbol     ';
    assert_strings[177] := 'Expected signal instance specifier          ';
    assert_strings[178] := 'Expected =                                  ';
    assert_strings[179] := 'Expected an identifier                      ';
    assert_strings[180] := 'Unknown scope specification                 ';
    assert_strings[181] := 'Expected >                                  ';
    assert_strings[182] := 'Expected formal param subscript const       ';
    assert_strings[183] := 'Drawing/directory specified more than once  ';
    assert_strings[184] := 'Expected a constant for scope spec          ';
    assert_strings[185] := 'Expected UNDEFINED subscript specifier      ';
    assert_strings[186] := 'Bit lists are not permitted in pin names    ';
    assert_strings[187] := 'Signal to be fixed has known polarity       ';
    assert_strings[188] := 'Scope is UNKNOWN in enter_def_into_stack    ';
    assert_strings[189] := 'Local signal on stack out of order          ';
    assert_strings[190] := 'Misc. parse error from a page compiler file ';
    assert_strings[191] := 'Interface signal not released from node     ';
    assert_strings[192] := 'Cannot fix assertion in signal stack        ';
    assert_strings[193] := 'Choose better base fails to decide          ';
    assert_strings[194] := 'Non-NIL stack in def passed to PUSH         ';
    assert_strings[195] := 'Could not find non-virtual signal           ';
    assert_strings[196] := 'Synonym of 2 non-virtual signals            ';
    assert_strings[197] := 'Actual signal is virtual!                   ';
    assert_strings[198] := 'Assertion error detected in check_and_fi    ';
    assert_strings[199] := 'Determining signal has UNKNOWN polarity     ';
    assert_strings[200] := 'Signal found without NN property            ';
    assert_strings[201] := 'Numbered token table bucket out of order    ';
    assert_strings[202] := 'Duplicate numbered tokens (same value)      ';
    assert_strings[203] := 'Looking for UNKOWN_NUMBERED_TOKEN ???       ';
    assert_strings[204] := '"New" token number already exists!!!        ';
    assert_strings[205] := 'Nil numbered token value encountered!       ';
    assert_strings[206] := 'Nil token field in token list.              ';
    assert_strings[207] := 'Reference to an undefined numbered tok !    ';
    assert_strings[208] := 'Numbered token dictionary overflow.         ';
    assert_strings[209] := 'Unrecognized numbered token type.           ';
    assert_strings[210] := 'Failed call to enter_expandable_id          ';
    assert_strings[211] := 'Enter_expandable_id(NIL) ????               ';
    assert_strings[212] := 'Unrecognized evaluation kind.               ';
    assert_strings[213] := 'Nil token field !!! (it is bad)             ';
    assert_strings[214] := 'Id number duplicated in exp_ids or props    ';
    assert_strings[215] := 'NIL TM_name to expand/substitue_text_mac    ';
    assert_strings[216] := 'Non-canonical base_BD to synonym_1st_BD_    ';
    assert_strings[217] := 'Expected !                                  ';
    assert_strings[218] := 'directory found under different auto-nam    ';
    assert_strings[219] := 'structure not counted in heap estimate      ';
    assert_strings[220] := 'Nil string passed as argument               ';
    assert_strings[221] := 'Nil name passed as argument                 ';
    assert_strings[222] := 'Unrecognized open mode                      ';
    assert_strings[223] := 'Unable to dup a file descriptor             ';
    assert_strings[224] := 'Illegal numbered token dictionary insert    ';
    assert_strings[225] := 'UNKNOWN_TOKEN_NUMBER found in table         ';
    assert_strings[226] := 'Expected sepcomp command                    ';
    assert_strings[227] := 'NIL version or page to read_macro_page      ';
    assert_strings[228] := 'Attempted to rewrite file ""                ';
    assert_strings[229] := 'Directory contains version with no pages    ';
    assert_strings[230] := 'NIL directory field in macro_entry          ';
    assert_strings[231] := 'Non-VECTOR instance to slice_of_instance    ';
    assert_strings[232] := 'NIL subs on VECTOR pin_name in output_ac    ';
    assert_strings[233] := 'illegal id in an id table                   ';
    assert_strings[234] := 'expected a parameter list                   ';
    assert_strings[235] := 'String length exceeded internally           ';
    assert_strings[236] := 'Redundant context definition entries        ';
    assert_strings[237] := 'non-null definition for undefined name!!    ';
    assert_strings[238] := 'illegal make_pass                           ';
    assert_strings[239] := 'number_non_leaf_nodes < 0                   ';
    assert_strings[240] := 'internal integer overflow                   ';
    assert_strings[241] := 'Severe problem with virtual stack ops       ';
    assert_strings[242] := 'nth_bit_of_instance FALSE in fix_basescr    ';
    assert_strings[243] := 'LOGIC prim read with new prim semantics     ';
    assert_strings[244] := 'Illegitimate AVL type                       ';
    assert_strings[245] := 'Mismatched AVL types                        ';
    assert_strings[246] := 'Equal strings have unequal pointers         ';
    assert_strings[247] := 'find_base_of_PCS returns NIL                ';
    assert_strings[248] := 'nth_bit_of_PCS FALSE                        ';
    assert_strings[249] := 'insertion into non-active dictionary        ';
    assert_strings[250] := 'Unable to create unique file name           ';
    assert_strings[251] := 'Signal with DECLARED scope encountered      ';
    assert_strings[252] := 'Algorithm for finding bus binding is broken ';
    assert_strings[253] := 'Unexpected Error while handling bit tap     ';
    assert_strings[254] := 'Underflow of critical section semaphore     ';
    assert_strings[255] := 'Bus binding not found for NAC check !!      ';
    

    parse_asserts := [9..30,32,34,35,44,49,107,108,113..132,150,153,158,
                      162,176..185,190,207,217,226,234];
  end { init_assertions } ;


  procedure init_errors;
    { init the error messages }
  begin
    error_strings[0]   := 'THIS ERROR IS ALWAYS SUPPRESSED             ';
    error_strings[1]   := 'Expected identifier                         ';
    error_strings[2]   := 'Expected =                                  ';
    error_strings[3]   := 'Not supported by ValidPAGECOMP              ';
    error_strings[4]   := 'Expected string or identifier               ';
    error_strings[5]   := 'Expected ,                                  ';
    error_strings[6]   := 'Unrecognized symbol                         ';
    error_strings[7]   := 'Expected )                                  ';
    error_strings[8]   := 'Expected =, <, >, <>, <= or >=              ';
    error_strings[9]   := 'Wrong file type for text macros             ';
    error_strings[10]  := 'Expected <                                  ';
    error_strings[11]  := 'Expected >                                  ';
    error_strings[12]  := 'Expected ;                                  ';
    error_strings[13]  := 'Expected :                                  ';
    error_strings[14]  := 'Unexpected symbol in integer expression     ';
    error_strings[15]  := 'Expected (                                  ';
    error_strings[16]  := 'Bit value invalid                           ';
    error_strings[17]  := 'Unknown SHAREABLE specification             ';
    error_strings[18]  := '                                            ';
    error_strings[19]  := '                                            ';
    error_strings[20]  := 'Unmatched closing comment character         ';
    error_strings[21]  := '                                            ';
    error_strings[22]  := 'String length exceeded                      ';
    error_strings[23]  := 'Illegal character found                     ';
    error_strings[24]  := 'Expression value overflow                   ';
    error_strings[25]  := 'Division by zero                            ';
    error_strings[26]  := 'PRIM in rule requires SCALD directory type  ';
    error_strings[27]  := 'Expected SPECIAL or PRIMITIVE               ';
    error_strings[28]  := 'PRIM (PART) not a legal SCALD directory type';
    error_strings[29]  := 'Extraneous junk after bit list              ';
    error_strings[30]  := 'Unexpected symbol in bit subscript          ';
    error_strings[31]  := 'Unknown REPORT specification                ';
    error_strings[32]  := 'Non-printing character found                ';
    error_strings[33]  := 'Expected a string                           ';
    error_strings[34]  := 'Comment not closed before end of input      ';
    error_strings[35]  := 'Specified parameter # > allowed # params    ';
    error_strings[36]  := 'Signal MUST have high assertion char        ';
    error_strings[37]  := 'Expected .                                  ';
    error_strings[38]  := 'File name has already been specified        ';
    error_strings[39]  := 'Undefined identifier in expression          ';
    error_strings[40]  := 'Expected END                                ';
    error_strings[41]  := 'Identifier length exceeded                  ';
    error_strings[42]  := 'Unknown debug control specifier             ';
    error_strings[43]  := 'Text macro parameter exceeds max length     ';
    error_strings[44]  := 'Constant width value out of range           ';
    error_strings[45]  := 'Directive has already been specified        ';
    error_strings[46]  := 'Duplicate global text macro definition      ';
    error_strings[47]  := 'Invalid specification for inheritance       ';
    error_strings[48]  := 'Unknown property attribute                  ';
    error_strings[49]  := 'Directive unsupported by SCALD compiler     ';
    error_strings[50]  := 'Extraneous junk at end of number            ';{non-parse}
    error_strings[51]  := 'Unknown compiler directive                  ';
    error_strings[52]  := 'Invalid specification for directive         ';
    error_strings[53]  := 'Input line exceeds maximum length           ';
    error_strings[54]  := 'Can''t begin signal name with ''(''            ';
    error_strings[55]  := 'Wrong file type for property attributes     ';
    error_strings[56]  := 'Text macro parameter cannot be found        ';
    error_strings[57]  := 'End of input before end of expression       ';
    error_strings[58]  := 'Extraneous characters at end of expr        ';
    error_strings[59]  := 'Identifier has not been defined             ';
    error_strings[60]  := 'Same shadow directory use more than once    ';
    error_strings[61]  := 'Radix must be in range 2..16                ';
    error_strings[62]  := 'Extraneous junk at end of menu version      ';
    error_strings[63]  := 'Extraneous junk at end of boolean expr      ';
    error_strings[64]  := 'Max text macro nesting depth exceeded       ';
    error_strings[65]  := 'Compile extension name is too long          ';
    error_strings[66]  := 'Compilation to .PRIM files not permitted    ';
    error_strings[67]  := 'Error in signal syntax specification        ';
    error_strings[68]  := 'Library file has already been specified     ';
    error_strings[69]  := 'Ill-formed cardinal tap body                ';
    error_strings[70]  := 'Version number is outside allowed range     ';
    error_strings[71]  := 'Page number is outside allowed range        ';
    error_strings[72]  := 'Duplicate page number                       ';
    error_strings[73]  := 'Tapped bit(s) not found in connected bus    ';
    error_strings[74]  := 'Multiple busses on cardinal tap body        ';
    error_strings[75]  := 'No named bus attached to cardinal tap body  ';
    error_strings[76]  := 'Bool expr already defined for this vers     ';
    error_strings[77]  := 'Specified version is not in directory       ';
    error_strings[78]  := 'Only MENU bodies are allowed here           ';
    error_strings[79]  := 'Expected a version 1 with MENU body(s)      ';
    error_strings[80]  := 'Illegal property on MENU body               ';
    error_strings[81]  := 'Illegal MENU property number                ';
    error_strings[82]  := 'Same MENU expr property found twice         ';
    error_strings[83]  := 'Expected signal name or constant            ';
    error_strings[84]  := 'Replication factor is out of range          ';
    error_strings[85]  := 'Expected FILE_TYPE specification            ';
    error_strings[86]  := 'File is not of the correct type             ';
    error_strings[87]  := 'Directory file name previously specified    ';
    error_strings[88]  := 'Illegal file name in drawing directory      ';
    error_strings[89]  := 'String not closed before the end of line    ';
    error_strings[90]  := '                                            ';
    error_strings[91]  := 'Expected shadow directory name              ';
    error_strings[92]  := 'Invalid (warnings and oversights only)      ';
    error_strings[93]  := 'Expected directory file name                ';
    error_strings[94]  := 'Invalid value for print width               ';
    error_strings[95]  := 'Drawings have not been written with 5.5     ';
    error_strings[96]  := 'Bit subscript on constant not permitted     ';
    error_strings[97]  := 'Unknown output file name                    ';
    error_strings[98]  := 'Extraneous junk at end of file              ';
    error_strings[99]  := 'This symbol cannot be used here             ';
    error_strings[100] := 'Can''t open specified expansion rules file   ';
    error_strings[101] := 'Drawing path name is missing closing )      ';
    error_strings[102] := 'Symbol must be one character                ';
    error_strings[103] := 'Library not found in master directory       ';
    error_strings[104] := 'Wrong FILE_TYPE for master library          ';
    error_strings[105] := 'Reserved text macro name                    ';
    error_strings[106] := 'Cannot find definition for text macro       ';
    error_strings[107] := 'Duplicate library entry in master lib       ';
    error_strings[108] := 'No SIZE in context for SIZEd drawing        ';
    error_strings[109] := 'Body properties are not allowed here        ';
    error_strings[110] := 'Undefined text macro (null value)           ';
    error_strings[111] := 'No directory was specified                  ';
    error_strings[112] := 'Separate AND single drawing compilation     ';
    error_strings[113] := 'Replication is not permitted on pin name    ';
    error_strings[114] := 'Text macro has already been defined         ';
    error_strings[115] := 'Same MENU version property found twice      ';
    error_strings[116] := 'Expanded string exceeds max string len      ';
    error_strings[117] := 'Textmacro and parameters exceeds max len    ';
    error_strings[118] := 'Expression value is empty                   ';
    error_strings[119] := 'NC is not permitted as a pin name           ';
    error_strings[120] := 'Path name exceeds maximum length            ';
    error_strings[121] := 'Path element name exceeds maximum length    ';
    error_strings[122] := 'Drawing has incompatible extensions         ';
    error_strings[123] := 'Selection expr and MENU expr mismatch       ';
    error_strings[124] := 'Versioned drawings not written w 7.0 GED    ';
    error_strings[125] := 'Pin properties are not permitted here       ';
    error_strings[126] := 'Text macro is not an identifier             ';
    error_strings[127] := 'ABBREV property not found for drawing       ';
    error_strings[128] := 'ABBREV value must be letters, digits & _    ';
    error_strings[129] := 'Menu entry for version is not permitted     ';
    error_strings[130] := 'Scalar reference to vector signal           ';
    error_strings[131] := 'Vector reference to scalar signal           ';
    error_strings[132] := 'Concatenated signal as pin name             ';
    error_strings[133] := 'This property has already been defined      ';
    error_strings[134] := 'Terminal drawing is not a primitive part    ';
    error_strings[135] := 'Cannot open compiler directives file        ';
    error_strings[136] := 'Signals cannot be attached to this body     ';
    error_strings[137] := 'Text macro nesting depth exceeded           ';
    error_strings[138] := 'Cannot open error documentation file        ';
    error_strings[139] := 'More than 1 selection expression is true    ';
    error_strings[140] := 'This signal cannot be DECLAREd              ';
    error_strings[141] := 'SIZE property on non SIZE-wide body         ';
    error_strings[142] := 'MENU bodies are not supported               ';
    error_strings[143] := 'Illegal rotation on this body               ';
    error_strings[144] := 'This body should not be given SIZE prop     ';
    error_strings[145] := 'Pin name does not exist                     ';
    error_strings[146] := 'Pin name does not have this bit             ';
    error_strings[147] := 'Root drawing specified as primitive.        ';
    error_strings[148] := 'No root drawing was specified               ';
    error_strings[149] := 'Synonyms must use single assertion          ';
    error_strings[150] := 'PERMIT attribute value invalid              ';
    error_strings[151] := 'This property not permitted on a SIGNAL     ';
    error_strings[152] := 'This property not permitted on a BODY       ';
    error_strings[153] := 'This property not permitted on a PIN        ';
    error_strings[154] := 'Signal''s assertion cannot be determined     ';
    error_strings[155] := 'Attempt to synonym 0 and 1                  ';
    error_strings[156] := 'Signal''s width cannot be determined         ';
    error_strings[157] := 'Error found in configuration file: fatal    ';
    error_strings[158] := 'Signal''s scope conflicts with complement    ';
    error_strings[159] := 'Synonym of unequal width signals            ';
    error_strings[160] := 'Cannot SIZE replicate plumbing drawings     ';
    error_strings[161] := '2 signals w/ timing assertions synonymed    ';
    error_strings[162] := 'Interface and local signals conflict        ';
    error_strings[163] := 'Local and global signals conflict           ';
    error_strings[164] := 'Global and interface signals conflict       ';
    error_strings[165] := 'This signal cannot have scope property      ';
    error_strings[166] := 'Cannot access CMPDRAW file for input        ';
    error_strings[167] := 'Cannot open synonyms file for input         ';
    error_strings[168] := 'Cannot close file                           ';
    error_strings[169] := 'Cannot open file for output                 ';
    error_strings[170] := 'Cannot open master library file             ';
    error_strings[171] := 'Bit subscript increment of 0 not allowed    ';
    error_strings[172] := 'Bit subscript should be right to left       ';
    error_strings[173] := 'Bit subscript should be left to right       ';
    error_strings[174] := 'Vector/scalar conflict between complements  ';
    error_strings[175] := 'Can''t use a remote shadow directory         ';
    error_strings[176] := 'PATH name is not unique                     ';
    error_strings[177] := 'Selection expr for drawing is FALSE         ';
    error_strings[178] := 'Max error value must be >= 1                ';
    error_strings[179] := 'Extraneous junk at end of signal            ';
    error_strings[180] := 'Parameter was declared twice                ';
    error_strings[181] := 'Cannot access drawing directory             ';
    error_strings[182] := 'Drawing title does not match directory      ';
    error_strings[183] := 'X_FIRST must be >= 0 (set to 0)             ';
    error_strings[184] := 'PIN_EQUIVALENT no longer supported          ';
    error_strings[185] := 'SIZE must be >= 0 (set to 1)                ';
    error_strings[186] := 'X_STEP must be > 0 (set to 1)               ';
    error_strings[187] := 'Assertion chk failure: save CMPLOG file     ';
    error_strings[188] := 'Parameters not permitted on this body       ';
    error_strings[189] := 'Timing assertion not allowed on pin name    ';
    error_strings[190] := 'No selection expression evaluates true      ';
    error_strings[191] := 'Drawing not found in the directories        ';
    error_strings[192] := 'PATH name element is not unique             ';
    error_strings[193] := 'No usable extension found for drawing       ';
    error_strings[194] := 'Text macro refers to itself (recursive)     ';
    error_strings[195] := 'Cannot open specified attributes file       ';
    error_strings[196] := 'Default value used for SIZE (1)             ';
    error_strings[197] := 'PATH property not found for body            ';
    error_strings[198] := 'Bit subscript on undefined width pin        ';
    error_strings[199] := 'Pin name conflicts with previous pin        ';
    error_strings[200] := 'Pin name and signal widths do not match     ';
    error_strings[201] := 'Signal fails bubble check on this pin       ';
    error_strings[202] := 'Pin name with NWC cannot have subscript     ';
    error_strings[203] := 'LOGIC primitive used as terminal drawing    ';
    error_strings[204] := 'Pin name cannot use signal negation         ';
    error_strings[205] := 'Cannot open DRAWING file                    ';
    error_strings[206] := 'Cannot open specified directory file        ';
    error_strings[207] := 'Cannot open syntax configuration file       ';
    error_strings[208] := 'Too many errors in this compile!            ';
    error_strings[209] := 'Cannot open specified text macro file       ';
    error_strings[210] := 'Primitive cannot have NWC pin               ';
    error_strings[211] := 'Pin name is vector but used as a scalar     ';
    error_strings[212] := 'A pin name cannot be a constant             ';
    error_strings[213] := 'Versioned drawing must have EXPR prop       ';
    error_strings[214] := 'String not closed before end of signal      ';
    error_strings[215] := 'Pin name is scalar but used as vector       ';
    error_strings[216] := 'PART not allowed; COMPILE LOGIC assumed     ';
    error_strings[217] := 'Fatal error(s) encountered - run stopped    ';
    error_strings[218] := 'Pin subscript must be a simple subrange     ';
    error_strings[219] := 'DECLARE bodies are no longer supported      ';
    error_strings[220] := 'PART_NAME property should not be used       ';
    error_strings[221] := 'Bodies with NWC cannot expand to parts      ';
    error_strings[222] := 'DELETE_DRAWING specifies unfound drawing    ';
    error_strings[223] := '                                            ';
    error_strings[224] := 'Extraneous junk at end of command line      ';
    error_strings[225] := '                                            ';
    error_strings[226] := 'Cannot initialise data services             ';
    error_strings[227] := 'Cannot open expansion file                  ';
    error_strings[228] := 'Incorrect use of seplink command            ';
    error_strings[229] := 'Illegal COMMAND value                       ';
    error_strings[230] := 'Can''t create shadow directory               ';
    error_strings[231] := 'Can''t open compiler-specified file          ';
    error_strings[232] := 'Unable to access schema file                ';
    error_strings[233] := '                                            ';
    error_strings[234] := 'Cannot access DESIGN file for output        ';
    error_strings[235] := 'Signal synonymed to its own complement      ';
    error_strings[236] := '                                            ';
    error_strings[237] := 'Cannot get file "last modified" time        ';
    error_strings[238] := 'Illegal hierarchical drawing recursion      ';
#if SVS
    error_strings[239] := 'Pin or pin bit has no \\I signal             ';
#else
    error_strings[239] := 'Pin or pin bit has no \I signal             ';
#endif
    error_strings[240] := '.PRIM and .PART both found for drawing      ';
    error_strings[241] := 'Pin connected to its own complement         ';
    error_strings[242] := 'Different pins on bodies for same module    ';
    error_strings[243] := 'Compiler errors in a drawing                ';
    error_strings[244] := 'Needed module was not loaded                ';
    error_strings[245] := 'ABBREV property conflict in drawing         ';
    error_strings[246] := 'Unable to remove file                       ';
    error_strings[247] := 'Pages of version across SCALD dirs          ';
    error_strings[248] := 'Incorrect page expansion file syntax        ';
    error_strings[249] := '                                            ';
    error_strings[250] := 'Missing ValidPAGECOMP/LINKER results        ';
    error_strings[251] := 'Unrecognized command line argument          ';
    error_strings[252] := 'Illegal drawing directory in SCALD directory';

    error_strings[253] := 'More than 1 DEFAULT selection expression    ';
    error_strings[254] := 'Same special model in more than 1 directory ';
    error_strings[255] := 'Unable to successfully read expansion rules ';
    {New error messages added for data services}
    error_strings[256] := 'Unable to find directives in database.      ';
    error_strings[257] := 'Unable to find global TMs in database.      ';
    error_strings[258] := 'Unable to find prop attr  in database.      ';

    { initialize environment variables for error display }

    environment_stack := NIL;
    init_error_info;

    num_errors := 0;
    num_warnings := 0;
    num_oversights := 0;
    last_error := 0;
    indent := 4;  { actually only defined for the "current" error }

    ok_to_print_error := TRUE;
    errors_encountered := [];
    free_environments := NIL;
    exception_code := NULL_ERROR_CODE;

    { ------- error sets ------- }

    scan_past_errors := [1,2,4..8,10..13,15,33,37,40,83,85,93,179];
    fatal_errors := [65,67,100,111,112,120,135,148,157,166,169,
                     205,206,207,226, 228,229,234,238,252,255];
    warning_errors := [3,8,49,68,107,108,141,154,158,182,184,194,196,203,
		       239,246];
    oversight_errors := [37,40,41,80,92,95,97,123,127,134,140,143,
                         144,174,176,192,197,213,216,220,224,225,251,245];
    parse_errors := [1..48,51..53,55..59,61..68,83..87,89,90,92..94,
                     96,97,99,101..104,107,171..173,178..179,184,216,225,229,
		     248,252];
    echo_to_monitor_errors := [208,217];
    keep_the_page_dirty_errors := [181,191,193,247];
    scope_conflict_errors := [162,163,164];
    ignore_parse_errors := FALSE;
  end { init_errors } ;


  procedure init_sets;
    { initialize various constant sets }
    const
      FIRST_CHAR = 0;
      LAST_CHAR = 255;
    var
      c: char;
  begin
    mulops := [ASTERISK, SLASH, MODSY];
    addops := [PLUS, MINUS];
    relops := [EQUAL, NESY, LESSTHAN, LESY, GREATERTHAN, GESY];
      
    valid_chars[2]  := ['0','1'];
    valid_chars[3]  := valid_chars[2]  + ['2'];
    valid_chars[4]  := valid_chars[3]  + ['3'];
    valid_chars[5]  := valid_chars[4]  + ['4'];
    valid_chars[6]  := valid_chars[5]  + ['5'];
    valid_chars[7]  := valid_chars[6]  + ['6'];
    valid_chars[8]  := valid_chars[7]  + ['7'];
    valid_chars[9]  := valid_chars[8]  + ['8'];
    valid_chars[10] := valid_chars[9]  + ['9'];
    valid_chars[11] := valid_chars[10] + ['A'];
    valid_chars[12] := valid_chars[11] + ['B'];
    valid_chars[13] := valid_chars[12] + ['C'];
    valid_chars[14] := valid_chars[13] + ['D'];
    valid_chars[15] := valid_chars[14] + ['E'];
    valid_chars[16] := valid_chars[15] + ['F'];

    forbidden_symbols := [SEMI,LESSTHAN,GREATERTHAN,CONSTANT,PERCENT,SHARP];
    expression_symbols := [PLUS, MINUS, SLASH, LPAREN, RPAREN, ASTERISK];

    bitsubendsys := [COMMA, GREATERTHAN, ENDOFDATASY];
    propbeginsys := [PINSY, BODYSY, PARAMETERSY];

    allowed_key_words := [];
    schema_keysys := [ENDSY, FILETYPESY];
    expansion_keysys := [ENDSY, FILETYPESY];
    directives_keysys := [ENDSY];
    directory_keysys := [ENDSY, FILETYPESY];
    macrodef_keysys := [MACROSY..FILETYPESY];
    signal_keysys := [ORSY..MAXSY,LOW_ASSERTED_SY..NEGATION_SY];
    config_keysys := [LOW_ASSERTED_SY..NEGATION_SY];

    inheritance_attributes := [INHERIT_BODY, INHERIT_PIN, INHERIT_SIGNAL];
    signal_inheritance_attributes := [INHERIT_PIN, INHERIT_SIGNAL];
    permission_attributes := [PERMIT_SIGNAL, PERMIT_PIN, PERMIT_BODY];
    default_attributes := [INHERIT_BODY, INHERIT_SIGNAL] +
                          permission_attributes;
    parameter_attributes := [IS_INT_PARAMETER, IS_PARAMETER];

    bodies_with_bindings := [USER_BODY, PIN_NAMES_BODY, DECLARE_BODY];

    for c := chr(FIRST_CHAR) to chr(LAST_CHAR) do
      begin
	islegal[c] := TRUE;
	isdigit[c] := FALSE;
	isidentchar[c] := FALSE;
	isupper[c] := FALSE;
        is_signal_name_terminator[c] := FALSE;
	upshift[c] := c;

	case c of
	  'a','b','c','d','e','f','g','h','i','j','k','l','m','n',
	  'o','p','q','r','s','t','u','v','w','x','y','z' :
	    upshift[c] := chr(ord(c) + ord('A') - ord('a'));

	  'A','B','C','D','E','F','G','H','I','J','K','L','M','N',
	  'O','P','Q','R','S','T','U','V','W','X','Y','Z' :
	    begin
	      isidentchar[c] := TRUE;
	      isupper[c] := TRUE;
	    end;

	  '0','1','2','3','4','5','6','7','8','9' :
	    begin
	      isdigit[c] := TRUE;
	      isidentchar[c] := TRUE;
	    end;

	  ' ','!','"','#','$','%','&','''','(',')','*','+',
	  ',','-','.','/',':',';','<','>','=','?','@','[',
#if !SVS
	  '\', 
#else
	  '\\',
#endif 
	  ']','^','{','|','}','~','_','`' : { ok } ;

	  OTHERWISE islegal[c] := FALSE;
	end;
      end;
    isidentchar['_'] := TRUE;
  end { init_sets } ;


  procedure init_linker_comm_structures;
    { init the variables associated with linker communication }
  begin
    sepcomp_list_root := NIL;
    current_sepcomp := NIL;
    last_sepcomp := NIL;
    temp_file_name := make_and_enter_string(DEFAULT_TEMP_FILE);
    compile_command_table[FIRST_COMPILE_COMMAND] := NIL;
    compile_command_table[COMPILE_ROOT]   := enter_name('ROOT            ');
    compile_command_table[COMPILE_SUB]    := enter_name('SEPCOMP         ');
    compile_command_table[CHECK_FOR_PRIM] := enter_name('PRIM            ');
    compile_command_table[STOP_AT_SUBCKT] := enter_name('SUBCKT          ');
    compile_command_table[LAST_COMPILE_COMMAND] := NIL;   
  end { init_linker_comm_structures } ;

  
  procedure init_page_expansion_structures;
    { init the expansion dictionaries }
  begin
    init_numbered_dictionary(expansion_id_dictionary, IDENTIFIER_NUMBER);
    init_numbered_dictionary(expansion_string_dictionary, STRING_NUMBER);
    invoke_path_table := NIL;
  end { init_page_expansion_structures } ;


  procedure init_schema_structures;
    { init the variables declared in for schema handling }
  begin
    with schema_of_drawing_being_compiled do
      begin
	init_numbered_dictionary(id_dictionary, IDENTIFIER_NUMBER);
	init_numbered_dictionary(string_dictionary, STRING_NUMBER);
	paged_schemas := NIL;
	used_global_TMs := NIL;
	contexts := NIL;
	file_name := nullstring;
	directory := NIL;
	file_accessible := FALSE;
	changed := FALSE;
	bubble_check := FALSE;
	used_properties := NIL;
	local_TMs := NIL;
	local_TMs_defined := FALSE;
      end;

    with paged_schema_of_this_page do
      begin
	next := NIL;
	drawing_type := NIL;
	version := 0;
	page := 0;
	expandable_ids := NIL;
	local_text_macros := NIL;
	dependencies := NIL;
      end;

    old_schema_page := NIL;  old_schema_page_parent := NIL;
  end { init_schema_structures } ;


  procedure init_string_structures;
    { init the table describing the discrete string lengths that can be
      created on the heap }
    var
      i: 1..33;                  { index into list of free strings }
      j: hash_string_range;      { index into the string table }
  begin
    for j := 0 to HASH_STRING_TABLE_SIZE do string_table[j] := NIL;

    free_pointers := NIL;
    for i := 1 to 33 do free_strings[i] := NIL;
    s_length[1] := 4;
    s_length[2] := 8;
    s_length[3] := 12;
    s_length[4] := 16;
    s_length[5] := 20;
    s_length[6] := 24;
    s_length[7] := 28;
    s_length[8] := 32;
    s_length[9] := 36;
    s_length[10] := 40;
    s_length[11] := 44;
    s_length[12] := 48;
    s_length[13] := 52;
    s_length[14] := 56;
    s_length[15] := 60;
    s_length[16] := 64;
    s_length[17] := 68;
    s_length[18] := 72;
    s_length[19] := 76;
    s_length[20] := 80;
    s_length[21] := 84;
    s_length[22] := 88;
    s_length[23] := 92;
    s_length[24] := 96;
    s_length[25] := 100;
    s_length[26] := 120;
    s_length[27] := 140;
    s_length[28] := 160;
    s_length[29] := 180;
    s_length[30] := 200;
    s_length[31] := 220;
    s_length[32] := 240;
    s_length[33] := 256;

    create_a_string(nullstring, 0);
  end { init_string_structures } ;


  procedure init_special_bodies;
    { init list of specially recognized macro body names }
    var
      i: scope_type;     { index into table }
  begin
    special_body_list[MENU_BODY     ] :=
                                    make_and_enter_string('MENU            ');
    special_body_list[DEFINE_BODY   ] :=
                                    make_and_enter_string('DEFINE          ');
    special_body_list[DRAWING_BODY  ] :=
                                    make_and_enter_string('DRAWING         ');
    special_body_list[PIN_NAMES_BODY] :=
                                    make_and_enter_string('PIN NAMES       ');
    special_body_list[DECLARE_BODY  ] :=
                                    make_and_enter_string('DECLARE         ');

    MEMORY_prim_name := make_and_enter_string('MEMORY          ');

    scope_table[UNKNOWN_SCOPE] := make_and_enter_string('UNKNOWN         ');
    scope_table[XINTERFACE   ] := make_and_enter_string('INTERFACE       ');
    scope_table[LOCAL        ] := make_and_enter_string('LOCAL           ');
    scope_table[GLOBAL       ] := make_and_enter_string('GLOBAL          ');
    scope_table[DECLARED     ] := make_and_enter_string('DECLARED        ');
    scope_table[SIG_CONST    ] := make_and_enter_string('SIG_CONST       ');

    for i := FIRST_SCOPE to LAST_SCOPE do
      scope_values[ord(i)] := i;
  end { init_special_bodies } ;


  procedure init_directives;
    { initialize the compiler directive tables and flags }
    const
      DUMMY_UMASK = 511; { should never be used, so it is intentionally
                           chosen to cause unaccessible files if used }
    var
      arg: xtring;       { sargv(1) }
      len: string_range; { (alpha) length of COMPERR command specifier }
      i: id_range;       { index into alpha and arg if of correct length }
      matches: boolean;  { TRUE if arg matches interesting alpha so far }
      c: char;           { current (upshifted) char of arg }

      std_lib_str: xtring; { variable used for processing std_lib_dsobjname }
      std_tm_str: xtring; { variable used for processing std_tm_dsobjname }
      error_doc_str: xtring; { used in processing the error_doc_dsobjname}
      config_str: xtring; { used in processing the sig_config_dsobjname }
      prop_str: xtring; { used in processing the std_prop_dsobjname }

    procedure add_to_table(directive: directive_type; name: alpha);
      { add the given directive to the table }
    begin
      compiler_directive[directive] := enter_name(name);
    end { add_to_table } ;


  begin { init_directives }
    add_to_table(ALLOW_PART_NAME_DIRECTIVE,         'ALLOW_PART_NAME ');
    add_to_table(AMUSING_MESSAGES_DIRECTIVE,        'AMUSING_MESSAGES');
    add_to_table(BUBBLECHECK_DIRECTIVE,             'BUBBLE_CHECK    ');
    add_to_table(CLASSGEN_DIRECTIVE,                'CLASS_GEN       ');
    add_to_table(COMMAND_DIRECTIVE,                 'COMMAND         ');
    add_to_table(COMPILE_DIRECTIVE,                 'COMPILE         ');
    add_to_table(CONFIG_FILE_DIRECTIVE,             'CONFIGURE_FILE  ');
    add_to_table(CONST_BUBBLE_CHK_DIRECTIVE,        'CONST_BUBBLE_CHK');
    add_to_table(CONTEXT_DIRECTIVE,                 'CONTEXT         ');
    add_to_table(DEBUG_DIRECTIVE,                   'DEBUG           ');
    add_to_table(DEBUG_AT_PATH_directive,           'DEBUG_AT_PATH   ');
    add_to_table(DEBUG_CONTROL_DIRECTIVE,           'DEBUG_CONTROL   ');
    add_to_table(DECLARE_BODIES_DIRECTIVE,          'DECLARE_BODIES  ');
    add_to_table(DEFAULT_FILTER_DIRECTIVE,          'DEFAULT_FILTER  ');
    add_to_table(DEFAULT_L_OR_G_DIRECTIVE,          'DEFAULT_SCOPE   ');
    add_to_table(DIRECTORY_DIRECTIVE,               'DIRECTORY       ');
    add_to_table(ENABLE_CARDINAL_TAP_DIRECTIVE,     'CARDINAL_TAP    ');
    add_to_table(ERROR_HELP_DIRECTIVE,              'ERROR_HELP      ');
    add_to_table(EVACUATE_DIRECTIVE,                'EVACUATE        ');
    add_to_table(EXPANSION_RULES_DIRECTIVE,         'EXP_RULES_FILE  ');
    add_to_table(FILTER_PROPERTY_DIRECTIVE,         'FILTER_PROPERTY ');
    add_to_table(HIERARCHICAL_NWC_DIRECTIVE,        'HIERARCHICAL_NWC');
    add_to_table(LIBRARY_DIRECTIVE,                 'LIBRARY         ');
    add_to_table(LOCALLY_GLOBAL_DIRECTIVE,          'LOCALLY_GLOBAL  ');
    add_to_table(MASTER_LIBRARY_DIRECTIVE,          'MASTER_LIBRARY  ');
    add_to_table(MAX_ERROR_DIRECTIVE,               'MAX_ERRORS      ');
    add_to_table(NET_PROCESSING_DIRECTIVE,          'NET_PROCESSING  ');
    add_to_table(OUTPUT_DIRECTIVE,                  'OUTPUT          ');
    add_to_table(OVERSIGHT_DIRECTIVE,               'OVERSIGHTS      ');
    add_to_table(PAGE_SYNONYM_DIRECTIVE,            'PAGE_SYNONYM    ');
    add_to_table(PASS_PROPERTY_DIRECTIVE,           'PASS_PROPERTY   ');
    add_to_table(PASSWORD_DIRECTIVE,                'PASSWORD        ');
    add_to_table(PERMIT_NO_ASSERTION_DIRECTIVE,     'PERMIT_NO_ASSERT');
    add_to_table(PICK_DIRECTIVE,                    'PICK            ');
    add_to_table(PRIMITIVE_DIRECTIVE,               'PRIMITIVE       ');
    add_to_table(PROPERTY_DIRECTIVE,                'PROPERTY_FILE   ');
    add_to_table(PRINT_WIDTH_DIRECTIVE,             'PRINT_WIDTH     ');
    add_to_table(READ_ALL_UDIRS_DIRECTIVE,          'READ_ALL_UDIRS  ');
    add_to_table(REPORT_DIRECTIVE,                  'REPORT          ');
    add_to_table(REPORT_UNKASSERT_DIRECTIVE,        'REPORT_UNKASSERT');
    add_to_table(ROOT_DIRECTIVE,                    'ROOT_DRAWING    ');
    add_to_table(SEPARATE_COMPILE_DIRECTIVE,        'SEPARATE_COMPILE');
    add_to_table(SHADOW_ROOT_DIRECTIVE,             'SHADOW_ROOT     ');
    add_to_table(SHAREABLE_DIRECTIVE,               'SHAREABLE       ');
    add_to_table(SINGLE_LEVEL_DIRECTIVE,            'SINGLE_DRAWING  ');
    add_to_table(SUPPRESS_DIRECTIVE,                'SUPPRESS        ');
    add_to_table(TOKENIZE_PARAMS_DIRECTIVE,         'TOKENIZE_PARAMS ');
    add_to_table(TEXT_MACRO_DIRECTIVE,              'TEXT_MACRO_FILE ');
    add_to_table(WARN_DIRECTIVE,                    'WARNINGS        ');
       
    output_file[CMPLST_FILE    ] := enter_name('LIST            ');
    output_file[CMPEXP_FILE    ] := enter_name('EXPAND          ');
    output_file[CMPERR_FILE    ] := enter_name('ERROR           ');
    output_file[CMPSYN_FILE    ] := enter_name('SYNONYM         ');
    output_file[CHIPS_FILE     ] := enter_name('CHIPS           ');
    output_file[CMPHIER_FILE   ] := enter_name('HIERARCHICAL    ');

    SCALD_only_output_files := [CMPHIER_FILE];

    command_value[FIRST_COMMAND  ] := null_name;
    command_value[SEPCOMP_COMMAND] := enter_name('SEPCOMP         ');
    command_value[SEPLINK_COMMAND] := enter_name('SEPLINK         ');
    command_value[COMPERR_COMMAND] := enter_name('COMPERR         ');
    command_value[LAST_COMMAND   ] := null_name;

    command := SEPCOMP_COMMAND;
    if sargc > 1 then 
      begin
        len := alpha_length(command_value[COMPERR_COMMAND]^.name);
        sargv(1, arg);
	if ord(arg^[0]) = len then
	  begin
	    matches := TRUE;
	    for i := 1 to len do
	      begin
	        c := upshift[arg^[i]];
		if c <> command_value[COMPERR_COMMAND]^.name[i] then
		  matches := FALSE;
	      end;
	    if matches then command := COMPERR_COMMAND;
	  end;
      end;

    shareable.values[FIRST_SHAREABLE_VALUE] := null_name;
    shareable.values[DEFAULT_SHARING      ] := enter_name('OFF             ');
    shareable.values[GROUP_SHARING        ] := enter_name('GROUP           ');
    shareable.values[GLOBAL_SHARING       ] := enter_name('ALL             ');
    shareable.values[LAST_SHAREABLE_VALUE ] := null_name;

    shareable.umasks[FIRST_SHAREABLE_VALUE] := DUMMY_UMASK;
    shareable.umasks[DEFAULT_SHARING      ] := DUMMY_UMASK; { not used }
    shareable.umasks[GROUP_SHARING        ] := 2;
    shareable.umasks[GLOBAL_SHARING       ] := 0;
    shareable.umasks[LAST_SHAREABLE_VALUE ] := DUMMY_UMASK;

    found_debug_password := FALSE;
    ROOT_specified_in_command_line := FALSE;
    TYPE_specified_in_command_line := FALSE;
    COMMAND_specified_in_command_line := FALSE;
    CONTEXT_specified_in_command_line := FALSE;

    analog_designer_compile := FALSE;

    debug_directives := [DEBUG_DIRECTIVE,
                         DEBUG_AT_PATH_DIRECTIVE,
                         DEBUG_CONTROL_DIRECTIVE];

    one_time_directives := [succ(FIRST_DIRECTIVE)..pred(LAST_DIRECTIVE)] -
                           debug_directives -
                           [DIRECTORY_DIRECTIVE,
                            FILTER_PROPERTY_DIRECTIVE,
                            LIBRARY_DIRECTIVE,
			    EXPANSION_RULES_DIRECTIVE,
                            MASTER_LIBRARY_DIRECTIVE,
                            OUTPUT_DIRECTIVE,
                            PASS_PROPERTY_DIRECTIVE,
                            PRIMITIVE_DIRECTIVE,
                            PROPERTY_DIRECTIVE,
			    PICK_DIRECTIVE,
                            REPORT_DIRECTIVE,
			    SHADOW_ROOT_DIRECTIVE,
			    SHAREABLE_DIRECTIVE,
                            SUPPRESS_DIRECTIVE,
                            TEXT_MACRO_DIRECTIVE];

    file_name_directives := [CONFIG_FILE_DIRECTIVE,
                             DIRECTORY_DIRECTIVE,
                             EXPANSION_RULES_DIRECTIVE,
                             MASTER_LIBRARY_DIRECTIVE,
                             PROPERTY_DIRECTIVE,
			     SHADOW_ROOT_DIRECTIVE,
                             TEXT_MACRO_DIRECTIVE];

    root_macro_name := nullstring;
    module_being_compiled := NIL;
    page_being_compiled := 0;
    version_being_compiled := 0;
    context_being_compiled := NIL;
    current_compiled_context := NIL;
    specified_context := NIL;
    shadow_root := nullstring;

    default_configuration_file := nullstring;
    error_documentation_file := nullstring;
    standard_library_file_name := nullstring;
    standard_text_macro_file := nullstring;
    standard_property_file := nullstring;

    enable_cardinal_tap := TRUE;
    allow_missing_high_assertion := FALSE;
    allow_PART_NAME_property := TRUE;
    tokenize_params := FALSE;
    report_unknown_assertions := FALSE;

    suppress_errors := [0];
    display_warnings := DEFAULT_WARNINGS;
    display_oversights := DEFAULT_OVERSIGHTS;
    bubble_check := DEFAULT_BUBBLE_CHECK;
    const_bubble_check := DEFAULT_CONST_BUBBLE_CHECK;
    max_errors := DEFAULT_MAX_ERRORS;
    scope_is_local := DEFAULT_SCOPE_IS_LOCAL;
    left_to_right := DEFAULT_LEFT_TO_RIGHT;
    display_error_doc := TRUE;
    net_processing := TRUE;
    force_primitives := NIL;
    produce_amusing_messages := FALSE;
    single_level_compile := FALSE;  { used by comperr -- ignored by
                                      page compiler }

    specified_compile_type := LOGIC_compile_type;

    print_width := MAX_PRINT_WIDTH;

    create_a_string(config_str, MAX_STRING_LENGTH);
    if sig_config_dsobjname(config_str) <> 0 then
      begin
        copy_string(config_str, default_configuration_file);
	configuration_file := default_configuration_file;
      end;
    config_str^[0] := chr(MAX_STRING_LENGTH);
    release_string(config_str);

    create_a_string(error_doc_str, MAX_STRING_LENGTH);
    if error_documentation_dsobjname(error_doc_str) <> 0 then
      begin
        copy_string(error_doc_str, error_documentation_file);
      end;
    error_doc_str^[0] := chr(MAX_STRING_LENGTH);
    release_string(error_doc_str);

    create_a_string(std_lib_str, MAX_STRING_LENGTH);
    if standard_lib_dsobjname(std_lib_str) <> 0 then 
      begin
        copy_string(std_lib_str, standard_library_file_name);
      end;
    std_lib_str^[0] := chr(MAX_STRING_LENGTH);
    release_string(std_lib_str);

    create_a_string(std_tm_str, MAX_STRING_LENGTH);
    if textmacro_dsobjname(std_tm_str) <> 0 then 
      begin
        copy_string(std_tm_str, standard_text_macro_file);
      end;
    std_tm_str^[0] := chr(MAX_STRING_LENGTH);
    release_string(std_tm_str);

    create_a_string(prop_str, MAX_STRING_LENGTH);
    if std_prop_dsobjname(prop_str) <> 0 then 
      begin
        copy_string(prop_str, standard_property_file);
      end;
    prop_str^[0] := chr(MAX_STRING_LENGTH);
    release_string(prop_str);

    { used by the add package to initialise the master library }

    selection_exceptions := NIL;
    selecting_module := FALSE;

    property_file := NIL;
    text_macro_file := NIL;
    expansion_rules_file := NIL;
    master_library_file := NIL;

    PrintCmpLst  := FALSE;
    PrintCmpErr  := FALSE;

    files_to_generate := [succ(FIRST_FILE_NAME)..pred(LAST_FILE_NAME)] -
                         [Chips_file, CmpHier_file, CmpErr_file];

    properties_assigned_filters := NIL;
    read_all_UNIX_directories := FALSE;

    specified_severity := WARNING_SEVERITY; { for COMPERR }
  end { init_directives } ;


  procedure init_report_tables;
    { initialize the report directive tables }
  begin
    reports_to_generate := [(*PATH_NAMES*)];

    report_type_table[PATH_NAMES] := enter_name('PATH_NAMES      ');
    report_type_table[HIERARCHY ] := enter_name('HIERARCHY       ');
    report_type_table[SUMMARY   ] := enter_name('SUMMARY         ');
    SCALD_only_reports := [PATH_NAMES, SUMMARY];
  end { init_report_tables } ;


  procedure init_plumbing_directory;
    { initialize the macro directories  }
    var
      i: plumbing_table_range;
  begin
    for i := 0 to LAST_PLUMBING_BUCKET do plumbing_table[i] := NIL;
  end { init_plumbing_directory } ;


  procedure init_lexical_analyzer;
    { initialize the lexical analyzer }
    var
      i: radix_range;     { index into the table of radix digit sizes (bits) }
  begin
    id.next := NIL;
    sy := nullsy;
    const_val := 0;
    const_width := 0;
    read_state := FINIT;
    stack_top := 0;  parse_stack_pointer := 1;
    line_pos := 0;
    last_sym_pos := 0;
    upper_case_strings := TRUE;
    how_to_parse := PARSE_SEPARATELY;
    copy_input := FALSE;
    current_pos := 0;
    copy_pos := 0;
    current_file := UNKNOWN_FILE;
    parse_SCALDconstants := TRUE;

    create_a_string(lex_string,   MAX_STRING_LENGTH);
    create_a_string(input_buffer, MAX_STRING_LENGTH);
    create_a_string(instring,     MAX_STRING_LENGTH);
    create_a_string(last_string,  MAX_STRING_LENGTH);
    instring^[0] := chr(0);  last_string^[0] := chr(0);

    allow_TM_expansion := default_TM_expansion;
    TM_depth := 1;
    text_macro_recursion := FALSE;

    subrangesy := DOTDOTSY;  fieldsy := COLON;

    for i := MIN_RADIX to MAX_RADIX do
      radix_width[i] := round(ln(i) / 0.6931471805 + 0.4);   { ceil log2(i) }
  end { init_lexical_analyzer } ;


  procedure init_constants;
    { init some global constants }
  begin
    page_expansion_file_name := nullstring;
    page_list_file_name := nullstring;
  end { init_constants } ;


  procedure init_symbols;
    { initialize symbol constants and CONFIGURE directive }
  begin
    configure_specifiers[CONFIGURE_SUBRANGE      ] :=
                                               enter_name('SUBRANGE        ');
    configure_specifiers[CONFIGURE_BIT_ORDERING  ] :=
                                               enter_name('BIT_ORDERING    ');
    configure_specifiers[CONFIGURE_LOW_ASSERTED  ] :=
                                               enter_name('LOW_ASSERTION   ');
    configure_specifiers[CONFIGURE_HIGH_ASSERTED ] :=
                                               enter_name('HIGH_ASSERTION  ');
    configure_specifiers[CONFIGURE_NEGATION      ] :=
                                               enter_name('NEGATION        ');
    configure_specifiers[CONFIGURE_NAME_PREFIX   ] :=
                                               enter_name('NAME_PREFIX     ');
    configure_specifiers[CONFIGURE_GENERAL_PREFIX] :=
                                               enter_name('GENERAL_PREFIX  ');
    configure_specifiers[CONFIGURE_CONCATENATION ] :=
                                               enter_name('CONCATENATION   ');

    signal_negation_symbol         := MINUS;
    signal_negation_char           := '-';

    signal_is_asserted_low_symbol  := ASTERISK;
    signal_is_asserted_low_char    := '*';

    signal_is_asserted_high_symbol := NULLSY;
    signal_is_asserted_high_char   := chr(255);

    name_property_prefix_symbol    := EXCLAMATION;
    name_property_prefix_char      := '!';

    general_property_prefix_symbol := BACKSLASH;
    general_property_prefix_char   := DEFAULT_GENERAL_PROPERTY_PREFIX_CHAR;

    concatenation_symbol           := COLON;
    concatenation_char             := ':';

    class_name_separator_symbol    := DOLLAR;
    text_macro_delimiter_symbol    := PERCENT;

    signal_name_end_sys := [signal_is_asserted_low_symbol,
                            signal_is_asserted_high_symbol,
                            general_property_prefix_symbol,
                            concatenation_symbol,
                            ENDOFDATASY];
  end { init_symbols } ;


  procedure init_file_types;
    { initialize table of file types }
  begin
    file_type_list[MACRO_DEFINITION   ] := enter_name('MACRO_DEFINITION');
    file_type_list[CONNECTIVITY       ] := enter_name('CONNECTIVITY    ');
    file_type_list[SPECIAL_TEXT_MACROS] := enter_name('TEXT_MACROS     ');
    file_type_list[PROPERTY_ATTRIBUTES] := enter_name('ATTRIBUTES      ');
    file_type_list[CONFIGURATION_SPEC ] := enter_name('CONFIGURATION   ');
    file_type_list[MASTER_LIBRARY     ] := enter_name('MASTER_LIBRARY  ');
    file_type_list[SCHEMA_FILE        ] := enter_name('SCHEMA          ');
    file_type_list[EXPANSION_FILE     ] := enter_name('EXPANSION       ');
  end { init_file_types } ;


  procedure init_scalars;
    { initialize standard scalars }
  begin
    macro_def_list_root := NIL;  root_macro_def := NIL;
    unique_PATH_number := 0;
    unique_NC_number := 0;
    unique_NET_ID_number := 0;
    directory_list_root := NIL;
    library_list_root := NIL;
    current_mtree_node := NIL;
    mtree_root := NIL;

    column := 0;     { current output column }
  end { init_scalars } ;


  procedure init_debug_controls;
    { initialize debug flags and directives }


    procedure add_specifier(specifier: debug_controls; name: alpha);
      { add a debug specifier to table }
    begin
      debug_control_specifier[specifier] := enter_name(name);
    end { add_specifier } ;


  begin { init_debug_controls }
    debug := FALSE;
    debugging := FALSE;
    debug_1 := FALSE;
    debug_2 := FALSE;
    debug_3 := FALSE;
    debug_4 := FALSE;
    debug_5 := FALSE;
    debug_6 := FALSE;
    debug_7 := FALSE;
    debug_8 := FALSE;
    debug_9 := FALSE;
    debug_10 := FALSE;
    debug_11 := FALSE;
    debug_12 := FALSE;
    debug_13 := FALSE;
    debug_14 := FALSE;
    debug_15 := FALSE;
    debug_16 := FALSE;
    debug_17 := FALSE;
    debug_18 := FALSE;
    debug_19 := FALSE;
    debug_20 := FALSE;
    debug_21 := FALSE;
    debug_22 := FALSE;
    debug_23 := FALSE;
    debug_24 := FALSE;
    debug_25 := FALSE;
    debug_26 := FALSE;
    debug_27 := FALSE;
    debug_28 := FALSE;
    debug_29 := FALSE;
    debug_30 := FALSE;
    debug_31 := FALSE;
    debug_32 := FALSE;
    debug_33 := FALSE;
    debug_34 := FALSE;
    debug_35 := FALSE;
    debug_36 := FALSE;
    debug_37 := FALSE;
    debug_38 := FALSE;
    debug_39 := FALSE;
    debug_40 := FALSE;

    add_specifier(control_dumptree         , 'DUMPTREE        ');
    add_specifier(control_dumpsignals      , 'DUMPSIGNALS     ');
    add_specifier(control_printmacros      , 'PRINTMACROS     ');
    add_specifier(control_printdirectory   , 'PRINTDIRECTORY  ');
    add_specifier(control_printhistograms  , 'PRINTHISTOGRAMS ');
    add_specifier(control_dumpsigdeflist   , 'DUMPSIGDEFLIST  ');
    add_specifier(control_dump_all_names   , 'DUMP_ALL_NAMES  ');
    add_specifier(control_erule_xface      , 'ERULE           ');

    debug_at_path := FALSE;  undebug_at_path := FALSE;
    path_for_debug := nullstring;  path_for_undebug := nullstring;
    debug_flags := [];  undebug_flags := [];
    dumptree_ok := FALSE;
    dumpsignals_ok := FALSE;
    printmacros_ok := FALSE;
    printdirectory_ok := FALSE;
    dumpsigdeflist_ok := FALSE;
    dump_all_names_ok := FALSE;
    trace_erule_xface := FALSE;

    histograms := [];
    histogram_specifiers[directory_histogram   ] :=
                                               enter_name('DIRECTORY       ');
    histogram_specifiers[signal_histogram      ] :=
                                               enter_name('SIGNAL          ');
    histogram_specifiers[name_table_histogram  ] :=
                                               enter_name('NAME_TABLE      ');
    histogram_specifiers[string_table_histogram] :=
                                               enter_name('STRING_TABLE    ');
  end { init_debug_controls } ;


  procedure init_free_lists;
    { initialize lists of "free" structures }
  begin
    free_signal_instances := NIL;
    free_signal_definitions := NIL;
    free_signal_definition_lists := NIL;
    free_subscripts := NIL;

    free_simple_signals := NIL;
    free_synonym_signals := NIL;
    free_formal_actual_lists := NIL;
    free_actual_lists := NIL;
    free_signal_descriptors := NIL;
    free_signal_descriptors := NIL;
    free_identifiers := NIL;
    free_properties := NIL;
    free_invoke_lists := NIL;
    free_base_descriptors := NIL;
    free_basescripts := NIL;
    free_subscript_properties := NIL;
    free_bit_properties := NIL;
    free_propertied_CSs := NIL;
    free_net_descriptors := NIL;
    free_net_tables := NIL;
    free_numbered_tokens := NIL;
    free_numbered_token_lists := NIL;
    free_text_macros := NIL;
    free_expandable_ids := NIL;
    free_paged_schemas := NIL;
    free_parameters := NIL;
    free_context_definitions := NIL;
    free_module_lists := NIL;
    free_dependency_lists := NIL;
    free_sepcomp_lists := NIL;
    free_mtree_nodes := NIL;
    free_signal_entrys := NIL;
    free_bindings_lists := NIL;
    free_macro_defs := NIL;
    free_clear_text_actual_lists := NIL;
    free_signal_lists := NIL;
    free_avls := NIL;
    free_signal_instance_lists := NIL;
    free_compiled_context_lists := NIL;
    free_property_attributes := NIL;
  end { init_free_list } ;


  procedure init_signals;
    { initialize signal descriptors }
    var
      i: signal_table_range;    { index into the signal table }
  begin
    for i := 0 to SIGNAL_TABLE_SIZE do  signal_table[i] := NIL;

    NC_signal := make_and_enter_string(NO_CONNECT_signal);
    Zero_signal := make_and_enter_string('0               ');
    One_signal := make_and_enter_string('1               ');
  end { init_signals } ;


  procedure init_special_names;
    { initialize some special names }
  begin
    SEPARATE_COMPILE_place_holder :=
                                    make_and_enter_string('*               ');

    FLAG_BODY_string := make_and_enter_string('FLAG_BODY       ');

    COMMENT_string := make_and_enter_string('COMMENT         ');

    PLUMBING_string := make_and_enter_string('PLUMBING        ');

    TRUE_string := make_and_enter_string('TRUE            ');

    FALSE_string := make_and_enter_string('FALSE           ');

    DEFAULT_string := make_and_enter_string('DEFAULT         ');

    PASS_string := make_and_enter_string('PASS            ');

    FILTER_string := make_and_enter_string('FILTER          ');

    SIZE_string := make_and_enter_string(SIZE_prop_name^.name);

    TIMES_string := make_and_enter_string(TIMES_prop_name^.name);

    X_FIRST_string := make_and_enter_string(X_FIRST_identifier^.name);

    X_STEP_string := make_and_enter_string(X_STEP_identifier^.name);

    X_string := make_and_enter_string(X_identifier^.name);    

    CLOSED_string := make_and_enter_string(CLOSED_alpha);

    DEFINE_string := make_and_enter_string(DEFINE_alpha);

    default_SIZE_string := make_and_enter_string(default_SIZE);

    default_X_FIRST_string := make_and_enter_string(default_X_FIRST);

    default_X_STEP_string := make_and_enter_string(default_X_STEP);

    default_X_STEP_for_leaf_string :=
                               make_and_enter_string(default_X_STEP_for_leaf);

    default_X_string := make_and_enter_string(default_X);

    special_pin_name_prefix := make_and_enter_string(LOCAL_signal_prefix);
  end { init_special_names } ;


  procedure init_statistics;
    { initialize structure statistics }
    var
      i: heap_structures;     { index into the table of heap usage }
  begin
    for i := succ(FIRST_HEAP_STRUCTURE) to pred(LAST_HEAP_STRUCTURE) do
      begin  heap_usage[i].number := 0;  heap_usage[i].size := 0;  end;

    total_number_nodes := 0;
    number_terminal_nodes := 0;
    number_leaf_nodes := 0;

    number_global_signals := 0;
    number_local_signals := 0;
    number_interface_signals := 0;
    number_unnamed_signals := 0;
    number_signal_instances := 0;
    number_non_interface_signal_instances := 0;
    total_number_signals := 0;

    number_interfaces_resolved := 0;
    number_quick_resolved := 0;
  end { init_statistics } ;


  procedure init_built_in_identifier_names;
    { initialize predefined identifiers }
    var
      i: name_table_range;       { index into the name table }
  begin
    for i := 0 to NAME_TABLE_SIZE do name_table[i] := NIL;

    UNDEFINED_identifier      := enter_name('UNDEFINED       ');
    ALL_identifier            := enter_name('ALL             ');

    ABBREV_prop_name          := enter_name('ABBREV          ');
    PATH_prop_name            := enter_name('PATH            ');
    SIZE_prop_name            := enter_name('SIZE            ');
    TIMES_prop_name           := enter_name('TIMES           ');
    EXPR_prop_name            := enter_name('EXPR            ');
    TITLE_prop_name           := enter_name('TITLE           ');
    VERSION_prop_name         := enter_name('VERSION         ');
    SIG_NAME_prop_name        := enter_name('SIG_NAME        ');
    AUTO_GEN_prop_name        := enter_name('AUTO_GEN        ');
    SCOPE_prop_name           := enter_name('SCOPE           ');
    NO_WIDTH_prop_name        := enter_name('NOWIDTH         ');
    NO_BUBBLE_prop_name       := enter_name('NOBUBBLE        ');
    BUBBLED_prop_name         := enter_name('BUBBLED         ');
    CARDINAL_TAP_prop_name    := enter_name('BN              ');
    OUTPUT_TYPE_prop_name     := enter_name('OUTPUT_TYPE     ');
    NO_ASSERT_prop_name       := enter_name('NOASSERT        ');
    REPLICATION_prop_name     := enter_name('REP             ');
    TERMINAL_prop_name        := enter_name('TERMINAL        ');
    TERMINAL_prop_name^.kind := TERMINAL_prop_name^.kind + [IS_ET_CONTROL];
    NEEDS_NO_SIZE_prop_name   := enter_name('NEEDS_NO_SIZE   ');
    COMMENT_BODY_prop_name    := enter_name('COMMENT_BODY    ');
    HAS_FIXED_SIZE_prop_name  := enter_name('HAS_FIXED_SIZE  ');
    BODY_TYPE_prop_name       := enter_name('BODY_TYPE       ');
    BODY_TYPE_prop_name^.kind := BODY_TYPE_prop_name^.kind + [IS_ET_CONTROL];
    NET_ID_prop_name          := enter_name('NN              ');
    XY_prop_name              := enter_name('XY              ');
    DIRECTORY_prop_name       := enter_name('DIR             ');
    ROTATION_prop_name        := enter_name('ROT             ');
    VER_prop_name             := enter_name('VER             ');
    CONTEXT_prop_name         := enter_name('CONTEXT         ');
    WARNING_prop_name         := enter_name('WARNING         ');
    OVERSIGHT_prop_name       := enter_name('OVERSIGHT       ');
    ERROR_prop_name           := enter_name('ERROR           ');
    DRAWING_prop_name         := enter_name('DRAWING         ');
    PAGE_prop_name            := enter_name('PAGE            ');
    TYPE_prop_name            := enter_name('TYPE            ');
    PATH_NAME_prop_name       := enter_name('PATH_NAME       ');
    PART_NAME_prop_name       := enter_name('PART_NAME       ');
    BODY_NAME_prop_name       := enter_name('BODY_NAME       ');
    TIME_prop_name            := enter_name('TIME            ');

    SIGNAL_prop_name          := enter_name('SIGNAL          ');
    PIN_prop_name             := enter_name('PIN             ');
    BODY_prop_name            := enter_name('BODY            ');
    SUBCKT_prop_name          := enter_name('SUBCKT          ');
    PRIM_TYPE_prop_name       := enter_name('PRIM_TYPE       ');
    PRIM_FILE_prop_name       := enter_name('PRIM_FILE       ');

    SIM_compile_type          := enter_name('SIM             ');
    LOGIC_compile_type        := enter_name('LOGIC           ');
    PART_extension_name       := enter_name('PART            ');
    PRIM_extension_name       := enter_name('PRIM            ');

    PRIMITIVE_specifier       := enter_name('PRIMITIVE       ');
    SPECIAL_specifier         := enter_name('SPECIAL         ');
 
    null_name                 := enter_name('                ');
    LOCAL_specifier           := enter_name('LOCAL           ');
    GLOBAL_specifier          := enter_name('GLOBAL          ');
    ON_specifier              := enter_name('ON              ');
    OFF_specifier             := enter_name('OFF             ');
    L_to_R_specifier          := enter_name('LEFT_TO_RIGHT   ');
    R_to_L_specifier          := enter_name('RIGHT_TO_LEFT   ');
    X_FIRST_identifier        := enter_name('X_FIRST         ');
    X_STEP_identifier         := enter_name('X_STEP          ');
    X_identifier              := enter_name('X               ');
    X_identifier^.kind := [RESERVED, IS_PARAMETER];

    SS_identifier             := enter_name('S               ');
    D_identifier              := enter_name('D               ');
    I_identifier              := enter_name('I               ');
    R_identifier              := enter_name('R               ');

    E_identifier              := enter_name('E               ');
    P_identifier              := enter_name('P               ');
    C_identifier              := enter_name('C               ');
    L_identifier              := enter_name('L               ');

    { RESERVED and UNRESERVED are non-reserved keywords, and are
      therefore not given the KEY_WORD name_type.  They are parsed as
      identifiers, and the id.name is checked against the following values. }

    RESERVED_key_name         := enter_name('RESERVED        ');
    UNRESERVED_key_name       := enter_name('UNRESERVED      ');
  end { init_built_in_identifier_names } ;


  procedure init_signal_syntax;
    { initialize the signal syntax descriptor }
  begin
    syntax_specifier_names[negation_specifier ]:=enter_name('NEGATION        ');
    syntax_specifier_names[name_specifier     ]:=enter_name('NAME            ');
    syntax_specifier_names[assertion_specifier]:=enter_name('ASSERTION       ');
    syntax_specifier_names[subscript_specifier]:=enter_name('SUBSCRIPT       ');
    syntax_specifier_names[null_specifier     ]:=enter_name('                ');
    syntax_specifier_names[property_specifier ]:=enter_name('GENERAL_PROPS   ');

    signal_syntax_table[1] := NEGATION_SPECIFIER;
    signal_syntax_table[2] := NAME_SPECIFIER;
    signal_syntax_table[3] := SUBSCRIPT_SPECIFIER;
    signal_syntax_table[4] := ASSERTION_SPECIFIER;
    signal_syntax_table[5] := PROPERTY_SPECIFIER;
  end { init_signal_syntax } ;
  
  
  procedure init_synonym_signal_table;
    { initialize the signal table }
    var
      i: synonym_signal_table_range;  { index into the synonym signal table }
  begin
    bogus_cmptmp_list := NIL;
    for i := 0 to SYNONYM_SIGNAL_TABLE_SIZE do
      synonym_signal_table[i] := NIL;
  end { init_synonym_signal_table } ;


  procedure init_efs_structures;
    { init structures for working with EFS files }
  begin
    EFS_PREFIX_string := make_and_enter_string(EFS_PREFIX);
  end { init_efs_structures } ;


begin { init }
  { NOTE: these initialization routines are order sensitive.  The routines
          called first are those that use no other "constant" variables
          for initializations.  The other routines do, and some of them
          must be called in this specific order.  Check very carefully
          before changing any of this. }

  { these initializations do NOT rely on other initializations }

  init_free_lists;    { this must be first because of NEW recording }

  init_sets;
  init_string_structures;
  init_constants;
  init_assertions;
  init_plumbing_directory;
  init_scalars;
  init_statistics;
  init_synonym_signal_table;

  { these initializations rely on other initializations }

  init_built_in_identifier_names;
  init_keywords;
  init_errors;
  init_special_bodies;
  init_signal_syntax;
  init_cli_arg_structures;
  init_directives;
  init_lexical_analyzer;
  init_symbols;
  init_file_types;
  init_debug_controls;
  init_signals;
  init_special_names;
  init_report_tables;
  init_schema_structures;
  init_page_expansion_structures;
  init_efs_structures;
  
  make_pass := NO_PASS;

  create_a_string(TM_expansion_buffer, MAX_STRING_LENGTH);

  remove_logical_file(CMPLST_FILE_NAME);

  if not rewrite_file(monitor, nullstring, MONITOR_FILE_NAME) then
    begin
#if VAX
      uxclose(1);  uxclose(0); 
#endif
      halt_with_status(FATAL_COMPLETION);
    end;
  monitor_open := TRUE;
  writeln(monitor);
  if command = COMPERR_COMMAND then write(monitor, COMPERR_WELCOME)
  else write(monitor, WELCOME_MESSAGE);
  dump_string(monitor, vversion);
  writeln(monitor);
  writeln(monitor, COPYRIGHT_NOTICE);

  if not rewrite_file(CmpLog, nullstring, CMPLOG_FILE_NAME) then
    begin
#if VAX
     uxclose(1);  uxclose(0); 
#endif
      halt_with_status(FATAL_COMPLETION);
    end;
  writeln(CmpLog, '+---------------------------+':42);
  writeln(CmpLog, '|  SCALD compiler log file  |':42);
  writeln(CmpLog, '+---------------------------+':42);
  writeln(CmpLog);
  write(CmpLog, WELCOME_MESSAGE);
  dump_string(CmpLog, vversion);
  writeln(CmpLog);
  writeln(CmpLog, COPYRIGHT_NOTICE);
  writeln(CmpLog);

  init_linker_comm_structures;
  {add_init(parse_error_notifier)};
  { NOTE: er_init(...) is called in read_compiler_directives_file before processing
    any associated directives (other than DEBUG_CONTROL ERULE;).  This allows
    the presence of that directive to turn on erule debugging before the
    initialization occurs. }
end { init } ;

