(**){--------------- NEW & RELEASE for MODULES  and DEPEDENCIES --------}


procedure new_module_list(var head: module_list_ptr);
  { Gets a new object (from freelist, if possible),
    initializes it and inserts it at the head of the list. }
  var
    newone: module_list_ptr; { new one }
begin
  if free_module_lists <> NIL then
    begin  
      newone := free_module_lists;  
      free_module_lists := newone^.next;  
    end
  else
    begin
      new(newone);  
      increment_heap_count(HEAP_MODULE_LIST, 3*POINTER_SIZE+INT_SIZE);
    end;
  with newone^ do
    begin
      next := head;
      drawing := NIL;          { numbered token ptr }
      context := NIL;
      number := 0;
    end;
  head := newone;
end { new_module_list } ;


procedure release_module_list(var head: module_list_ptr);
  { Releases a module_list for re-use. Sets head to
    the former head^.next (so can be used for list deletion). }
  var
    old: module_list_ptr; { saves old head for release }
begin
  if head <> NIL then
    begin
      release_all_parameters(head^.context);
      old := head;
      head := head^.next;
      old^.next := free_module_lists;
      free_module_lists := old;
    end;
end { release_module_list } ;


procedure release_all_module_lists(var head: module_list_ptr);
  { releases a module_list list by insertion into freelist. Returns NIL. }
  var
    last: module_list_ptr; { last element of list }
begin
  if head <> NIL then
    begin
      last := head;  release_all_parameters(last^.context);
      while last^.next <> NIL do
        begin
	  release_all_parameters(last^.context);
	  last := last^.next;
	end;
      last^.next := free_module_lists;
      free_module_lists := head;
      head := NIL;
    end;
end { release_all_module_lists } ;


procedure release_all_module_table_fields(var tbl: module_table);
  { re-initialize the table }
  var
    i: module_table_range;
begin
  with tbl do
    begin
      highest := 0;
      for i := 0 to LAST_MODULE_TABLE_ENTRY do
        release_all_module_lists(table[i]);
    end;
end { release_all_module_table_fields } ;


procedure init_module_table(var tbl: module_table);
  { init the table }
  var
    i: module_table_range;
begin
  with tbl do
    begin
      highest := 0;
      for i := 0 to LAST_MODULE_TABLE_ENTRY do table[i] := NIL;
    end;
end { init_module_table } ;


(**){----------- MODULE HANDLING --------------------------------}


function compare_param_property_lists(context1, 
				      context2: property_ptr): compare_type;
  { compares param_property lists }
  var
    parm1: property_ptr;   { current property in context1 }
    parm2: property_ptr;   { current property in context2 }
    done: boolean;         { TRUE when comparison has been made }
begin
  parm1 := context1;  parm2 := context2;
  repeat
    done := TRUE;
    if (parm1 = NIL) then
      if (parm2 = NIL) then compare_param_property_lists := EQ
      else compare_param_property_lists := LT
    else if (parm2 = NIL) then compare_param_property_lists := GT
    else
      case compare_parameter_names(parm1^.name, parm2^.name) of
        LT: compare_param_property_lists := LT;
        GT: compare_param_property_lists := GT;
        EQ:
          case compare_strings(parm1^.text, parm2^.text) of
            LT: compare_param_property_lists := LT;
            GT: compare_param_property_lists := GT;
            EQ:
              begin
                parm1 := parm1^.next;  parm2 := parm2^.next;  done := FALSE;
              end;
	  end { case } ;
      end { case } ;
  until done;
end { compare_param_property_lists } ;


function compare_modules(mod1, mod2: module_list_ptr): compare_type;
  { compare the module list elements according to 
      1. drawing name
      2. parameters }
begin
  case compare_strings(mod1^.drawing^.string_p, mod2^.drawing^.string_p) of
    LT: compare_modules := LT;
    GT:  compare_modules := GT;
    EQ: compare_modules :=
      compare_parameter_lists(mod1^.context, mod2^.context);
  end;
end { compare_modules } ;


function module_table_index(drawing_name: xtring;
                            context: parameter_ptr): module_table_range;
  { calculate hash table index for mod }
  const
    MAX_STRING_COUNT = 6; { arbitrary limit on number of strings examined }
  var
    i: string_range;              { index into current string }
    sum: longint;                 { sum of char values }
    count: 2..MAX_STRING_COUNT;   { number of strings examined }
    parm: parameter_ptr;          { current param }
begin
  sum := 0;
  for i := 1 to ord(drawing_name^[0]) do sum := sum + ord(drawing_name^[i]);
  count := 2;  parm := context;
  while (parm <> NIL) and (count < MAX_STRING_COUNT) do
    begin
      count := count + 1;
      with parm^.text^ do 
        for i := 1 to ord(string_p^[0]) do sum := sum + ord(string_p^[i]);
      parm := parm^.next;
    end;
  module_table_index := sum mod LAST_MODULE_TABLE_ENTRY;
end { module_table_index } ;


