procedure update_schema_of_current_page;
  { update old_schema_page using paged_schema_of_this_page, and mark the
    schema as changed.
    Before replacing local text macro definitions, check them for change
     and mark affected other pages. }


  function context_free_status_changed: boolean;
    { Return true if (expandable_ids = NIL) has changed }
  begin
    if paged_schema_of_this_page.expandable_ids = NIL then
      context_free_status_changed := old_schema_page^.expandable_ids <> NIL
    else
      context_free_status_changed := old_schema_page^.expandable_ids = NIL;
  end { context_free_status_changed } ;


  function is_context_free: boolean;
    { Return true if (expandable_ids = NIL)  }
  begin
    is_context_free := paged_schema_of_this_page.expandable_ids = NIL;
  end { is_context_free } ;


begin  { update_schema_of_current_page }
  if debug_20 or debug_24 then
    writeln(outfile, 'update_schema_of_current_page');
  enter_critical_section;

  schema_of_drawing_being_compiled.changed := TRUE;

  current_compiled_context^.dirty := FALSE;
  current_compiled_context^.dirty_for_pass_2 := FALSE;

  { If certain errors have occorred, mark the page dirty. }

  if (keep_the_page_dirty_errors * errors_encountered <> []) then
    begin
      if debug_23 or debug_24 then
        writeln(Outfile, '  page dirtied for errors');
      current_compiled_context^.dirty := TRUE;
    end;

  { If we have compiled a single-versioned primitive that has changed its
    status to (from) being context-free, then mark it dirty for
    recompilation during MAKE_PASS_2. }

  if context_free_status_changed and
     (er_issimple(module_being_compiled) <> 0) then
    begin
      if debug_23 or debug_24 then 
        writeln(Outfile, 
	  '  is single version primitive with changed context-free-ness');

      if command = SEPLINK_COMMAND then
	begin
	  mark_dirty_for_pass_2(old_schema_page);
	  if is_context_free then { now make context NIL }
	    specified_context := NIL
	  else { restore original context }
	    specified_context := current_sepcomp^.context;
	  context_being_compiled := 
	      enter_context_definition(
		specified_context, schema_of_drawing_being_compiled);
	  if context_being_compiled = NIL then
	    begin
	      assert(0 { better not happen });
	      writeln(Cmplog, ' enter_context_definition returns NIL');
	      halt_with_status(FATAL_COMPLETION);
	    end;
	end
      else
	begin
	  assert(0);
	  writeln(CmpLog, 
	    ' PRIM context restoration not implemented for this command');
	end;
    end;

  with paged_schema_of_this_page do
    begin
      { NOTE: local_text_macros are compared with old values during pass1 --
        so that is not repeated here }
      release_all_expandable_ids(old_schema_page^.expandable_ids);
      release_all_text_macros(old_schema_page^.local_text_macros);
      release_all_dependency_lists(old_schema_page^.dependencies);
      old_schema_page^.expandable_ids := expandable_ids;
      old_schema_page^.local_text_macros := local_text_macros; 
      old_schema_page^.dependencies := dependencies; 
      expandable_ids := NIL;  local_text_macros := NIL;  dependencies := NIL;
    end;

  exit_critical_section;
  if debug_20 or debug_24 then 
    writeln(Outfile, 'exit update_schema_of_current_page');
end { update_schema_of_current_page } ;


procedure perform_separate_compilation;
  { perform SEPCOMP or SEPLINK }
  var
    skip_module: boolean;         { dummy }
    linker_comm_opened: boolean;  { TRUE iff CmpDraw_pipe and 
                                    Design_pipe are open }
    special_model: xtring;        { non-graphical model name }


  procedure perform_page_compilation;
    { compile the curent page }
  begin
    if debug_20 then writeln(outfile, 'enter perform_page_compilation');
  
    init_time(page_elapsed_time, page_CPU_time);
    last_elapsed_time := page_elapsed_time;
    last_CPU_time := page_CPU_time;

    welcome;

    perform_macro_expansion(CmpExp_pipe);
    pipe_close(CmpExp_pipe);
  
    expansion_file_open := FALSE;
  
    if fatal_errors * errors_encountered = [] then
      begin
	report_pre_5_5_drawings;
      end;
  
    if dumpsignals_ok then
      dump_tree_information(outfile, DEBUG_DUMP_SIGNAL_DEFINITIONS);
  
    update_schema_of_current_page;

    display_error_summaries;

    writeln(monitor);  writeln(CmpLog);
    write(monitor, '   Page compiled ');
    write(CmpLog, '   Page compiled ');
    exec_time(page_elapsed_time, page_CPU_time, TRUE);
  
    if PrintCmpLst then 
      begin
	Writeln(CmpLst);
	PrintCmpLst := FALSE;
	close_file(CmpLst, CMPLST_FILE_NAME, page_list_file_name);
      end;
    if debug_20 then writeln(outfile, 'exit perform_page_compilation');
  end { perform_page_compilation } ;
  
  
begin { perform_separate_compilation }
  linker_comm_opened := FALSE;
  if command = SEPLINK_COMMAND then linker_comm_opened := open_linker_comm;

  if fatal_errors * errors_encountered <> [] then
    error(217 { we can't go on! })
  else
    begin
      {report_compiler_directives(CmpLog)};

      setup_global_textmacros_from_ds_module;
      {init_global_text_macros;}           { initialize reserved text macros }
      setup_property_attributes_from_ds_module;
      {read_property_attributes;}

      if fatal_errors * errors_encountered <> [] then
        error(217 { we can't go on! })
      else if (command = SEPCOMP_COMMAND) then
        if (root_macro_name = nullstring) then
            error(148 { no ROOT_DRAWING was specified })
        else 
          if not init_drawing(COMPILE_SUB, root_macro_name, skip_module) then 
            error(217 { can't go on })
          else { skip module can not occur with only one module }
            begin
              context_being_compiled^.version := version_being_compiled;
              make_pass := MAKE_PASS_1;
              while init_next_page do perform_page_compilation;
              make_pass := MAKE_PASS_2;
              while init_next_page do perform_page_compilation;
              make_pass := NO_PASS;
              write_schema_file(schema_of_drawing_being_compiled);
            end
      else { SEPLINK command }
        while init_next_sepcomp do
          begin
            context_being_compiled^.version := version_being_compiled;

	    { Don't compile forced-to-prim extensions }

            if not er_force_to_prim(module_being_compiled) then
              begin
		make_pass := MAKE_PASS_1;
		if version_being_compiled <> 0 then 
		  while init_next_page do
		    begin
		      perform_page_compilation;
		    { write_design_file_page_spec; }
		    end;
    
		make_pass := MAKE_PASS_2;
		if version_being_compiled <> 0 then 
		  while init_next_page do
		    begin
		      perform_page_compilation;
		      write_design_file_page_spec;
		    end;
	      end;

	    { Do non-graphical models and forced-to-prim extensions }

            special_model := enter_string(er_special(module_being_compiled));
	    if (special_model <> nullstring) or
	       er_force_to_prim(module_being_compiled) then
	      if DESIGN_specified_in_command_line then
		expand_non_graphical_model(CmpTmp_pipe, special_model)
	      else
		expand_non_graphical_model(Design_pipe, special_model);
          end;
    end;

  { uVAX ipc requires that the pipes opened by the parent be
    explicitly closed before terminating, therefore they are closed here,
    as this code is always exectuted (unless monitor could not be opened)
    whereas init_next_sepcomp is not executed if fatal errors were
    discovered during the initial phases. }
    
  if linker_comm_opened then
    begin
      pipe_close(CmpDraw_pipe);  pipe_close(Design_pipe);
    end;

  if printdirectory_ok then er_dump;
  print_histograms(outfile);
  dump_all_names;
  report_heap_usage(CmpLog);

end { perform_separate_compilation } ;


