
/* xefss eXtended EFS Slave --
   remote file operations for the SCALD compiler

   expects messages of the form(via standard input):

     R<file name><term> -- remove the file (must be a regular file)
     L<file name><term> -- open and place advisory lock on the file.
     U<file name><term> -- unlock the file (NOTE that there should only be
                           one locked file at a time).
     T<term>            -- return the current system time (as an ascii
                           representation of the integer) followed by newline.

     where <term> is any (terminating) character.  (This will be newline
     when testing this program from a terminal.  It is convenient to use
     '\0' from a parent program, as it can say 
     write(fd,command,strlen(command)+1); to send the command.  Not
     having a terminating character would make it harder to test by running
     directly from a terminal.)


   acknowledges (via standard output):

     "y\n" for success (except the T command which returns a value
         followed by a newline).
     error message (with trailing newline) for failure.

*/


#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#define TRUE 1
#define FALSE 0
#define MAX_STRING_LENGTH 255
#define BUFFER_LENGTH (MAX_STRING_LENGTH+1)

extern int errno;


void
acknowledge(s)
    /* acknowledge with string s with the addition of a terminating newline */
    char *s;
{
    char *l;
    
    l=s+strlen(s);
    *l='\n';
    write(1,s,(l-s)+1);
    *l='\0';
#ifdef DEBUG
    fprintf(stderr,"xefss acks:%s\n",s);
#endif DEBUG
}



int
get_command(s)
    /* get the command, returning 0 for end of file. Insure that the
       command is null terminated. */
    char *s;
{
    int len;
    if ((len=read(0,s,BUFFER_LENGTH))==0) return(FALSE);
    *(s+(len-1))='\0';  /* handles the arbitrary terminating char */
#ifdef DEBUG
    fprintf(stderr,"xefss:%s\n",s);
#endif DEBUG
    return(TRUE);
}


#ifdef BSD41C /* system uses wrong values for the flags */
#define LOCK_EX FEXLOCK
#define LOCK_NB FNBLOCK
#endif BSD41C


int
myflock(fd)
    /* lock the specified file descriptor, with blocking.  Return TRUE
       iff successful.
       NOTE: since flock blocking is rumored to sometimes cause hanging,
       this routine busy waits (with sleeping) instead of really blocking. */
    int fd;
{
    while (flock(fd,LOCK_EX+LOCK_NB)!=0) {
        if (errno!=EWOULDBLOCK) return(FALSE);
	sleep(10);
	}
    return(TRUE);
}


main()
{
    int len;
    char buffer[BUFFER_LENGTH];
    char file_name[BUFFER_LENGTH];
    int locked_file={-1};
    struct stat statbuf;

#ifdef DEBUG
    fprintf(stderr,"xefss:hi!\n");
#endif DEBUG

    while (get_command(buffer)) {

        switch  (*buffer) {
            case 'R':
	        if (stat(buffer+1,&statbuf)!=0) 
		    acknowledge("Cannot access file");
		else
		    if ((statbuf.st_mode&S_IFMT)!=S_IFREG)
		        acknowledge("File is not a regular file");
		    else
                        if (unlink(buffer+1)!=0) 
                            acknowledge("Permission denied");
			else acknowledge("y");
                break;
            case 'L':
                if (locked_file>=0)
		    acknowledge("Attempt to lock more than 1 file");
                else {
                    if ((locked_file=open(buffer+1,O_RDWR+O_CREAT,0666))<0)
                        acknowledge("Remote open failed");
                    else {
                        if (flock(locked_file,LOCK_EX)==0) {
                            strcpy(file_name,buffer+1);
                            acknowledge("y");
                            }
                        else acknowledge("Remote flock failed");
                        }
                    }
                break;
            case 'U':
                if (locked_file<0) acknowledge("No file is locked");
                else {
                    if (strcmp(file_name,buffer+1)!=0)
                        acknowledge("This file is not locked");
                    else {
                        close(locked_file);
			locked_file=(-1);
                        acknowledge("y");
                        }
                    }
                break;
            case 'T':
	        sprintf(buffer,"%d",time(0));
		acknowledge(buffer);
		break;
            default: acknowledge("Unknown flag");  break;
            }
	}

#ifdef DEBUG
    fprintf(stderr,"xefss:bye!\n");
#endif DEBUG

    exit(0);
}

                    
