
#define SETBUF_BUG
#define FCLOSE_BUG

#ifdef S32
#define UNIX
#define BSD42
#define REVERSE
#endif S32

#if defined(SUN3) || defined(SUN4) || defined(PMAX)
#define UNIX
#define BSD42
#endif

#ifdef PC_AT
#define SYS5
#define UNIX
#define REVERSE
#endif PC_AT

#define DEBUG 1

/* The following set of input routines does not use heap, so it can be
   used with unmodified SVS pascal.  The file variables are different
   (you can't use pascal i/o and this on the same file variable) and
   can be declared as follows:

   const
     BUFSIZ = 1024;  { 4.2 BSD -- BUFSIZ is 512 for 4.1c, so use the larger }
   type
     Cint = longint;
     Cfile_file_ptr = Cint;
     Cfile = record
       f: Cfile_file_ptr;
       buffer: packed array[1..BUFSIZ] of char;
     end;

   var
     myfile: Cfile;
*/

#ifdef UNIX


#include <stdio.h>

#include <errno.h>

extern int errno;      


#ifdef SYS5
#include <pwd.h>
#include <fcntl.h>
#endif SYS5

#define MAX_STRING_LENGTH 256
#define TRUE 1
#define FALSE 0
#define PBOOLEAN int
#define PTRUE 1
#define PFALSE 0
#define ALPHA_LEN 16
#define SUCCESS 0
#define OVERFLOW 1
#define END_OF_FILE 2
#define TAB 9
#define BLANK_CHAR ' '



extern FILE *dsfile_fopen(/*filename,  mode*/);
/*char *filename, char *mode*/

extern int dsfile_fclose(/*f*/)
/*FILE *f*/;

typedef char *xtring; /* a pascal "xtring" type -- it is a string with
                         byte count in the first char. */
extern int errno;

struct cfile {
    FILE *f;
    char buffer[BUFSIZ];
    };


/*
 * Convert the pascal xtring to a C string (in the global array c).
 */
static xtring_to_cstring(c, name) 
register char *c, *name;
{
    register char *stop = name + *name;
    name++;
    while (name <= stop) *c++ = *name++;
    *c=0;
}

/*
 * Convert identifier to C string
 */
static alpha_to_cstring(c, alpha)
register char *c, *alpha;
{
    register char *stop = alpha + ALPHA_LEN;
    while (alpha < stop && *alpha != ' ') *c++ = *alpha++;
    *c='\0';
}


PBOOLEAN
ds_creset(fi, applnname_addr, design_addr, name_addr, logical, bufsiz)
    /* if name (pascal xtring) has >0 length then open that named file,
       else open the logical file (real name being the value of the
       environment variable given by logical in DS.  Return
       0 if successful, 1 otherwise. */
    int bufsiz;                /* size of buffer at fi->buffer */
    char *name_addr;           /* file name (pascal xtring) */
    char *logical;             /* logical file name (alpha) */
    char **applnname_addr;     /* application name (pascal xtring)*/
    char **design_addr;        /* design name (pascal xtring)*/
    struct cfile *fi;          /* space for saving *FILE and buffer */
{
    char appln_buffer[MAX_STRING_LENGTH];
    char design_buffer[MAX_STRING_LENGTH];
    char cname_buffer[MAX_STRING_LENGTH];
    char lname_buffer[MAX_STRING_LENGTH];
    char *cname=0, *lname=0;               /* C string for final name of file */
    char *aname;               /* C string for application name for file*/
    char *dname=0;             /* C string for design name*/


    if ((bufsiz<BUFSIZ)&&(bufsiz!=0)) {
        sprintf(cname,"creset: buffer size must be 0 or at least %d (not %d)\n",
	              BUFSIZ,bufsiz);
	write(2,cname,strlen(cname));
	return(-1);
	}

#ifdef SETBUF_BUG
    /* be able to catch the setbuf hiccups! */
    {
        register char *i;
        for (i=fi->buffer;(i<fi->buffer+bufsiz);++i) *i=0;
	}
#endif SETBUF_BUG
    if (name_addr && *name_addr) {
        xtring_to_cstring(cname_buffer, *name_addr);
	cname = cname_buffer;
    } else {
	if (applnname_addr && *applnname_addr) {
	    xtring_to_cstring(appln_buffer, *applnname_addr);
	    aname = appln_buffer;
	}
	if (design_addr && *design_addr) {
	    xtring_to_cstring(design_buffer, *design_addr);
	    dname = design_buffer;
	}

	alpha_to_cstring(lname_buffer, logical);
	lname = lname_buffer;

	get_real_name_from_dsenv(appln_buffer, design_buffer, cname_buffer, lname);
#ifdef DEBUG
        printf("the cname from get real name %s\n", cname_buffer);
#endif
	cname = cname_buffer;
    }

#ifdef DEBUG
    write(2,"ds_creset: C opening file ", 26);
    write(2,cname,strlen(cname));
    write(2,"\n",1);
#endif DEBUG

    fi->f=dsfile_fopen(cname, 'r');
    /*if (*cname) fi->f=fopen(cname, "r");*/
#ifdef DEBUG
    if (fi->f==NULL) write(2,"open failed\n",13);
    else write(2,"open succeeded for ds_creset\n",16);
#endif DEBUG
    if ((fi->f)!=NULL) setbuf(fi->f,bufsiz==0?NULL:fi->buffer);
    return ((fi->f)==NULL) ? PFALSE : PTRUE;
}



PBOOLEAN
ds_cbreset(fi, applnname_addr, design_addr, name_addr, logical, bufsiz)
    int bufsiz;                /* size of buffer at fi->buffer */
    char **name_addr;           /* file name (pascal xtring) */
    char *logical;             /* logical file name (alpha) */
    char **applnname_addr;     /* application name (pascal xtring)*/
    char **design_addr;        /* design name (pascal xtring)*/
    struct cfile *fi;          /* space for saving *FILE and buffer */
    /* if name (pascal xtring) has >0 length then open that named file,
       else open the logical file (real name being the value of the
       environment variable given by logical in DS.  Return
       0 if successful, 1 otherwise. */
{
    return ds_cbreset(fi, applnname_addr, design_addr, name_addr, logical, bufsiz);
}

PBOOLEAN
ds_cfclose(fi)
    /* close the file f, returning boolean value for success or failure */
    struct cfile *fi;
{
    int val;

    val = (dsfile_fclose(fi->f) == -1) ? PFALSE : PTRUE;
#ifdef FCLOSE_BUG
    fi->f->_base = NULL;  /* because fclose is broken (it should do this) */
#endif FCLOSE_BUG
    if (fi->f->_base) write(2, "fclose didn't NULL the buffer !!!\n", 34);
    return val;
}

PBOOLEAN
ds_cfbclose(fi)
    /* close the file f, returning boolean value for success or failure */
    FILE *fi;
{
    int val;

    val = (dsfile_fclose(fi) == -1) ? PFALSE : PTRUE;
    return val;
}

PBOOLEAN
ds_crewrite(fi, applnname_addr, design_addr, realname_addr, logname, bufsiz)
    /* if realname (pascal xtring) has >0 length then open that named file.
       0 if successful, 1 otherwise. */
    int bufsiz;                /* size of buffer at fi->buffer */
    char *realname_addr;      /* file name (pascal xtring) */
    char *logname;            /* logical name (pascal xtring) */
    char **applnname_addr;    /* application name (pascal xtring) */
    char **design_addr;       /* design name (pascal xtring)*/
    struct cfile *fi;          /* space for saving *FILE and buffer */
{
    char appln_buffer[MAX_STRING_LENGTH];
    char design_buffer[MAX_STRING_LENGTH];
    char cname_buffer[MAX_STRING_LENGTH];
    char lname_buffer[MAX_STRING_LENGTH];
    char *cname=0;               /* C string for final name of file */
    char *lname=0;               /* C string for logical name for file*/
    char *aname=0;               /* C string for application name for file*/
    char *dname=0;               /* C string for desgin name*/

    if ((bufsiz<BUFSIZ)&&(bufsiz!=0)) {
        sprintf(cname,"creset: buffer size must be 0 or at least %d (not %d)\n",
	              BUFSIZ,bufsiz);
	write(2,cname,strlen(cname));
	return(1);
	}

#ifdef SETBUF_BUG
    /* be able to catch the setbuf hiccups! */
    {
        register char *i;
        for (i=fi->buffer;(i<fi->buffer+bufsiz);++i) *i=0;
	}
#endif SETBUF_BUG
    if (realname_addr && *realname_addr) {
        xtring_to_cstring(cname_buffer, realname_addr);
	cname = cname_buffer;
    } else {
	if (applnname_addr && *applnname_addr) {
	    xtring_to_cstring(appln_buffer, *applnname_addr);
	    aname = appln_buffer;
	}

	if (design_addr && *design_addr) {
	    xtring_to_cstring(design_buffer, *design_addr);
	    dname = design_buffer;
	}

	alpha_to_cstring(lname_buffer, logname);
	lname = lname_buffer;
	if (applnname_addr && *applnname_addr) {
	    xtring_to_cstring(appln_buffer, *applnname_addr);
	    aname = appln_buffer;
	}

	if (design_addr && *design_addr) {
	    xtring_to_cstring(design_buffer, *design_addr);
	    dname = design_buffer;
	}

	alpha_to_cstring(lname_buffer, logname);
	lname = lname_buffer;
	get_real_name_from_dsenv(appln_buffer, design_buffer, cname_buffer, lname);
	cname = cname_buffer;
    }

#ifdef DEBUG
    write(2,"C opening file from ds_crewrite ", 35);
    write(2,cname,strlen(cname));
    write(2,"\n",1);
#endif DEBUG

    fi->f=dsfile_fopen(cname, 'w');

#ifdef DEBUG
    if (fi->f==NULL) write(2,"open failed for ds_crewrite\n",28);
    else write(2,"open succeeded for ds_crewrite\n",31);
#endif DEBUG
    if ((fi->f)!=NULL) setbuf(fi->f,bufsiz==0?NULL:fi->buffer);
    return ((fi->f)==NULL) ? PFALSE : PTRUE;

}


PBOOLEAN
ds_cbrewrite(fi, applnname_addr, design_addr, realname_addr, logname, bufsiz)
    /* if realname (pascal xtring) has >0 length then open that named file.
       0 if successful, 1 otherwise. */
    int bufsiz;                /* size of buffer at fi->buffer */
    char *realname_addr;      /* file name (pascal xtring) */
    char *logname;            /* logical name (pascal xtring) */
    char **applnname_addr;    /* application name (pascal xtring) */
    char **design_addr;       /* design name (pascal xtring)*/
    struct cfile *fi;          /* space for saving *FILE and buffer */
{
    return ds_crewrite(fi, applnname_addr, design_addr, realname_addr, 
		       logname, bufsiz);
}

#endif






