#include <stdio.h>

#define UNIX

#ifdef VAX
#undef UNIX
#define VMS
#endif VAX

#ifdef PC_AT
#define usg
#endif PC_AT

#ifndef MAXPATHLEN
#define MAXPATHLEN 1024


/* NOTE: don't reverse parameters -- my wrapper does this (as well as
   string conversion */

#ifdef usg
#define index strchr
#define rindex strrchr
#endif usg
extern char *index(), *rindex();
#define strneq(a,b,c) (strncmp(a,b,c)==0)

/* This routine embodies the semantics of SCALD directory file names found
 * within master library files.  The general idea is to Do The Right Thing
 * with regard to remote and unrooted SCALD directory names so that the
 * meaning of a master library is the same whether it is read locally or
 * remotely.  Returns 0 for success, non-0 error.
 */
int
munge_remote_names(f, ln)
char* f; /* file name of master library file */
char* ln; /* long name of SCALD directory file, result returned in this */
{
    char *index(), *rindex();

    char buffer[MAXPATHLEN*2];
    char *p;

#ifdef VALID_EFS
    /* If master lib has a network-rooted name and scald dir has a node-rooted
       name then we have to prepend the node name from the master lib.
       Otherwise, we can ignore whether or not the name is an EFS name. */
    if (ln[0] == '/' && strneq(f, "/net/", 5) && !strneq(ln, "/net/", 5)) {
	strcpy(buffer, f);
	if (p = index(&(buffer[5]), '/')) *p = 0; /* "/net/node" */
	else return -1;  /* ill-formed file name */
	strcat(buffer, ln);
	if (strlen(buffer) >= MAXPATHLEN) return -1; /* too long */
	strcpy(ln, buffer);
    }
#endif
    if (ln[0] == '/') return 0; /* ln is already rooted */

    strcpy(buffer, f);
    if (p = rindex(buffer, '/')) *++p = 0;
    else return 0;  /* master lib is local */

    strcat(buffer, ln);
    if (strlen(buffer) >= MAXPATHLEN) return -1; /* too long */
    strcpy(ln, buffer);
    return 0;
}
#endif UNIX
#ifdef VMS

#include <stdio.h>
#define index strchr
#define rindex strrchr
extern char *index(), *rindex();

#include <ssdef.h>
#include <descrip.h>

/*
 * User-friendly descriptor definitions
 */

typedef struct dsc$descriptor_s STRINGDESC;

static STRINGDESC *
consdesc(desc, buf, len)
	register STRINGDESC *desc;
	char *buf;
{
	desc->dsc$w_length = len;
	desc->dsc$a_pointer = buf;
	desc->dsc$b_class = DSC$K_CLASS_S;
	desc->dsc$b_dtype = DSC$K_DTYPE_T;
	return desc;
}
static STRINGDESC *
strdesc(desc, name)
	register STRINGDESC *desc;
	register char *name;
{
	return consdesc(desc, name, strlen(name));
}


/*
 * We want to avoid being duped by the user, who will be throwing
 * subtle LOGICAL NAME gizmos at us.  So every directory USEd (or LIBd)
 * by GED comes through here.
 * Return -1 if we couldn't translate the name, and 0 if OK.  If an
 * error, the DD string contains, instead of the filename, an encoding
 * of the failure mode.
 * (sbs 860901)
 */
translate$filename(ss, dd)
	char *ss, *dd;
{
	char *tf = 0;
	int td;
	int rc;
	STRINGDESC Sdesc, Ddesc;
	int context = 0;

	if ((td = open(ss, 0)) < 0) {	/* dir don't exist yet */
		tf = ss;
		td = creat(tf, 0, "rat=cr", "rfm=var");
	}
	if (td >= 0)
		close(td);
	(void)strdesc(&Sdesc, ss);
	(void)consdesc(&Ddesc, dd, 249);	/* MAX_STRING_LENGTH-1 */

	/* context added -- WPG 25 Nov 1986.  For local files context does
	 * not matter, but if we are getting a name over DECnet and we
	 * don't use a context pointer (but use &0 instead) then we get
	 * a new FAL process on the remote DECnet node each time we do
	 * a LIB$FIND_FILE().  If we do it this way, calling FIND_FILE()
	 * and then FIND_FILE_END(), we only get one FAL no matter how
	 * many times we look at files over DECnet.
	 */
	rc = LIB$FIND_FILE(
		&Sdesc,				/* filename.rt.dx */
		&Ddesc,				/* resultname.mt.dx */
		&context,			/* context.ma.r */
		0, 0
		);
	LIB$FIND_FILE_END(&context);

	if ((rc&3) != 1) {		/* error, error */
		sprintf(dd, "SYS$TROUBLE(%08x) in find file", rc);
		rc = -1;
	} else {
		/*
		 * Mr. VMS puts the revision number, e.g., ;3, at the end
		 * of the filename.  Thanks, Mr. VMS.
		 * Also, Ddesc.dsc$w_length is not the significant length
		 * of the returned filename, but rather the number I gave
		 * to consdesc, above; the string is padded out with
		 * blanks to that length.  Thanks, Mr. VMS.
		 */
		register char *fuckdec, *p;
		extern char *strchr();

		rc = 0;
		dd[Ddesc.dsc$w_length] = '\0';
		for (p = "; "; *p != '\0'; p++) {
			if ((fuckdec = strchr(dd, *p)) != 0) {
				*fuckdec = '\0';
				break;
			}
		}
	}
	if (tf != 0)			/* clean up after ourselves */
		delete(tf);
	return rc;
}


decompose_name(n, machine_name, has_machine)
char *n;
char *machine_name;
int *has_machine;
{
    char junk[256];
    int i;

    machine_name[0] = 0;
    *has_machine = (2 == sscanf(n, "%[^:]::%s", machine_name, junk));
}


static cons_up_remote_name(result, machine, file)
char *result, *machine, *file;
{
    strcpy(result, machine);
    strcat(result, "::");
    strcat(result, file);
}
    

/* how to do getenv on uVMS when C set-up isn't there.  Code cribbed
   from Overcomer Wu.   See my (Roger Scott) handwritten notes for 
   21 Oct 1986. */

/* lnmdef.h contents follow: */
#define	LNM$M_NO_ALIAS	1
#define	LNM$M_CONFINE	2
#define	LNM$M_CRELOG	4
#define	LNM$M_TABLE	8
#define	LNM$M_CONCEALED	256
#define	LNM$M_TERMINAL	512
#define	LNM$M_EXISTS	1024
#define	LNM$M_SHAREABLE	65536
#define	LNM$M_CREATE_IF	16777216
#define	LNM$M_CASE_BLIND	33554432
#define	LNM$S_LNMDEF	4
#define	LNM$V_NO_ALIAS	0
#define	LNM$V_CONFINE	1
#define	LNM$V_CRELOG	2
#define	LNM$V_TABLE	3
#define	LNM$V_CONCEALED	8
#define	LNM$V_TERMINAL	9
#define	LNM$V_EXISTS	10
#define	LNM$V_SHAREABLE	16
#define	LNM$V_CREATE_IF	24
#define	LNM$V_CASE_BLIND	25
#define	LNM$C_TABNAMLEN	31
#define	LNM$C_NAMLENGTH	255
#define	LNM$C_MAXDEPTH	10
#define	LNM$_INDEX	1
#define	LNM$_STRING	2
#define	LNM$_ATTRIBUTES	3
#define	LNM$_TABLE	4
#define	LNM$_LENGTH	5
#define	LNM$_ACMODE	6
#define	LNM$_MAX_INDEX	7
#define	LNM$_PARENT	8
#define	LNM$_LNMB_ADDR	9
#define	LNM$_CHAIN	-1
/* end lnmdef.h */

typedef struct itmstruc {
	short buflen;
	short itmcod;
	unsigned int bufadr,
		retlenadr;
} itm_list_3;


/* WARNING:  This doesn't get TERM, HOME, USER or stuff from VMS symbols
   the way VAX C getenv() does.  It only gets stuff out of VMS logical
   names.  (But you can't use VAX C getenv() from a program with a Pascal
   main program -- that's why we need this.) */
static char *
getenv(s)
char *s;
{
	itm_list_3 logitm[2];
	unsigned int tabnam[2], lognam[2];
	unsigned int log_attr, stat;
	static char logbuf[256];
	int retlen = 0;
		
	log_attr = LNM$M_CASE_BLIND;
	tabnam[0] = strlen("LNM$DCL_LOGICAL");
	tabnam[1] = "LNM$DCL_LOGICAL";   /* This means look in all of them */
	lognam[0] = strlen(s);
	lognam[1] = s;
	logitm[0].itmcod = LNM$_STRING;
	logitm[0].buflen = sizeof(logbuf);
	logitm[0].bufadr = logbuf;
	logitm[0].retlenadr = &retlen;
	logitm[1].itmcod = 0;
	logitm[1].buflen = 0;
	logitm[1].bufadr = 0;
	logitm[1].retlenadr = 0;
	stat = SYS$TRNLNM(&log_attr, tabnam, lognam, 0, logitm);
	logbuf[retlen] = '\0';
	if (retlen > 0) {
		/* KLUDGE to remove BOOGER attached to the front of some
		   logical name translations.  Logical names like
		   SYS$OUTPUT, SYS$INPUT, SYS$ERROR, SYS$COMMAND are
		   "process-permanent logical names" and have have four
		   bytes of nonprinting characters stuck on the front.
		   The way to tell is that the first character is an ESCAPE.
		   I determined this by experiment; it is verifiable also
		   with f$trmlnm() lexical function and in VMS manuals
		   somewhere.  The return length includes these four bytes
		   in its count.	WPG 10 Dec 1986
		 */
		if (logbuf[0] == '\033')	/* ESCAPE */
			return (&(logbuf[4]));
		else
			return logbuf;
	} else
		return NULL;
}

static setenv(name, value)
char *name, *value;
{
	STRINGDESC tabnam, lognam;
	itm_list_3 itmlst[2];
	int retlen = 0;

	strdesc(&tabnam, "LNM$PROCESS_TABLE");
	strdesc(&lognam, name);
	itmlst[0].itmcod = LNM$_STRING;
	itmlst[0].buflen = strlen(value);
	itmlst[0].bufadr = value;
	itmlst[0].retlenadr = &retlen;
	itmlst[1].itmcod = 0;
	itmlst[1].buflen = 0;
	itmlst[1].bufadr = 0;
	itmlst[1].retlenadr = 0;
	SYS$CRELNM(0, &tabnam, &lognam, 0, itmlst);
}


/* <ln> is a filename found in the file <f>.  Munge <ln> so that it "means
 * the same thing as" it would if you were in the same directory (and on the
 * same machine) as <f>.  The utilities available in VMS will simply give up
 * on some possible combinations of <f> and <ln>.  In these cases we punt,
 * do only simple munging, and return failure.
 */
int
munge_remote_names(f, ln)
char *f; /* file name of master library file */
char *ln; /* long name of SCALD directory */
{
    char _f[256];
    char f_machine_name[80], ln_machine_name[80];
    int f_has_machine, ln_has_machine;
    char result[512];
    int error = 0;
    char *p;
    STRINGDESC new, cur;

    strcpy(_f, f);
    f = _f;
    /* printf("\n"); */
    translate$filename(f, result);
    strcpy(f, result);
    decompose_name(f, f_machine_name, &f_has_machine);
#ifdef DEBUG
    printf("mrn: f=%s %s\n", f, f_has_machine?"and is remote":"");
#endif DEBUG
    decompose_name(ln, ln_machine_name, &ln_has_machine);
#ifdef DEBUG
    printf("mrn: untranslated-ln=%s %s\n", ln, ln_has_machine?"and is remote":"");
#endif DEBUG
    /* non-machine-rooted remote names must be translated on the remote
       machine */
    if (f_has_machine && !ln_has_machine) {
	char fuck_vms[256];
	/* first, try appending <ln> to 'head' of <f>: */
	strcpy(fuck_vms, f);
	p = rindex(fuck_vms, ']');
	if (ln[0] == '[') {
	    *p++ = '.';
	    /* $*&^%#@!! unrooted names that start with directories will
	     * probably have the form "[.foo]bar.wrk".  For some reason it is
	     * not legal to form a name like "drc3:[user][.foo]bar.wrk".  Only
	     * "drc3:[user.foo]bar.wrk" and "drc3:[user.][foo]bar.wrk" are
	     * legal.  Thus, the following cruft.
	     */
	    if (ln[1] == '.')
		strcpy(p, &ln[2]);
	    else strcpy(p, &ln[1]);
	} else { /* <ln> doesn't (literally) begin with a directory */
	    ++p;
	    strcpy(p, ln);
	}
	if (translate$filename(fuck_vms, result)) { /* nope, try again */
#ifdef DEBUG
	    printf("mrn: attempted t$f() on %s, got %s\n", fuck_vms, result);
#endif DEBUG/
	    cons_up_remote_name(result, f_machine_name, ln);
	    error = translate$filename(result, ln);
#ifdef DEBUG
	    printf("mrn: attempted t$f() on %s, got %s\n", result, ln);
#endif DEBUG
	    if (error) strcpy(ln, result);
	    strcpy(ln, &ln[strlen(f_machine_name) + 2]); /* strip "foo::" */
	} else {
#ifdef DEBUG
	    printf("mrn: attempted t$f() on %s, got %s\n", fuck_vms, result);
#endif DEBUG
	    strcpy(ln, result);
	}
    } else { /* locally */
	/* if we can get the directory portion of <f> then we temporarily move
	 * to that directory in order to get the right answer from t$f()
	 */
	p = rindex(f, ']');
	if (!f_has_machine && p) {
	    int k;
	    short kk;
	    char bloat[256];
	    char old_device[256], device[256], non_device[256];

	    *++p = 0;
	    sscanf(f, "%[^:]:%s", device, non_device);
	    strcat(device, ":");
	    strcpy(old_device, getenv("SYS$DISK"));
	    setenv("SYS$DISK", device);
	    strdesc(&new, non_device);
	    consdesc(&cur, bloat, sizeof(bloat));
	    SYS$SETDDIR(0, &kk, &cur);
	    consdesc(&cur, bloat, kk);
	    SYS$SETDDIR(&new, 0, 0);
	    error = translate$filename(ln, result); /* else locally */
	    setenv("SYS$DISK", old_device);
	    SYS$SETDDIR(&cur, 0, 0);
	}
	else error = translate$filename(ln, result);
#ifdef DEBUG
	printf("mrn: attempted t$f() on %s, got %s\n", ln, result);
#endif DEBUG
	if (!error) strcpy(ln, result);
    }
    decompose_name(ln, ln_machine_name, &ln_has_machine);
#ifdef DEBUG
    printf("mrn: translated-ln=%s %s\n", ln, ln_has_machine?"and is remote":"");
#endif DEBUG
    if (f_has_machine && !ln_has_machine)
	cons_up_remote_name(result, f_machine_name, ln);
    else strcpy(result, ln);
    strcpy(ln, result);
#ifdef DEBUG
    printf("mrn: final result is %s\n", ln);
#endif DEBUG
    return error;
}
#endif VMS

