#include <string.h>
#include "er_heap.h"
#include "pascal.h"
#include "expression.h"


// Dump the expression as a SCALD-parseable string (or comment, if null)
ostream& operator<<(ostream& o, const erule_expression& e)
{
    if (e.is_default()) o << "\"DEFAULT\"";
    else if (!e._expression) o << "{ true }";
    else {
	// If expression contains "s we have to print char-by-char.
	// It's probabley not worth checking to see if this can be avoided.
	char* p = e._expression;
#ifdef PASCAL_XFACE
	p++;	// Eliminate byte count; we still have trailing null.
#endif
	o.put('"');
	for ( ; *p; p++) {
	    o.put(*p);  if (*p == '"') o.put(*p);
	}
	o.put('"');
    }
    return o;
}


// Allocation of actual char array is done HERE.
inline static char* copy(const char* e)
{
#ifdef PASCAL_XFACE
    int len;
    char* _exp = (char*)erule_heap.mem((len = strlen(e)) + 2);
    strcpy(_exp + 1, e);
    *_exp = len > 255 ? 255 : len;
#else
    char* _exp = (char*)erule_heap.mem(strlen(e) + 1);
    strcpy(_exp, e);
#endif
    return _exp;
}


inline static void free_it(char* _expression)
{
    if (_expression && _expression != ERULE_DEFAULT_EXPRESSION)
#ifdef PASCAL_XFACE
	erule_heap.memfree(_expression, strlen(_expression+1) + 2);
#else
	erule_heap.memfree(_expression, strlen(_expression) + 1);
#endif
}


const erule_expression& erule_expression::operator=(const char* expression)
{
    free_it(_expression);
    if (!expression) _expression = 0; 
    else if (!strcmp(expression, "DEFAULT"))
	_expression = ERULE_DEFAULT_EXPRESSION;
    else _expression = copy(expression);
    return *this;
}


const erule_expression& erule_expression::operator=(const erule_expression& e)
{
    free_it(_expression);
    if (e._expression == 0 || e._expression == ERULE_DEFAULT_EXPRESSION)
	_expression = e._expression;
#ifdef PASCAL_XFACE
    else _expression = copy(e._expression+1);
#else
    else _expression = copy(e._expression);
#endif
    return *this;
}


erule_expression::~erule_expression() { free_it(_expression); }
