#include "error.h"
#include "rule.h"
#include "entry.h"
#include "lex.h"


#ifdef VAX
gring_functions(next,erule_rule,);
#endif

// Initialized by erule_rule::parse -- these can't be staticly initialized,
// as they depend on the prior initialization of the string table.
static string PRIM;
static string LOGIC;
static void order_dependent_static_init()
{
#   define init(s) s = "s"
    init(PRIM);  init(LOGIC);
#   undef init
}


inline void erule_rule::append(erule_extension* ext)
{ 
    extensions.insert_rear(ext);
}


inline void erule_rule::append(const string& extension, const string& attribute)
{ 
    append(new erule_extension(extension, attribute));
}


erule_rule::~erule_rule()
{ 
    erule_extension* ext;
    while (ext = extensions.remove_first()) delete ext;

    erule_heap.memfree(this, sizeof(*this));  this = 0;
}

void erule_rule::dump(ostream& f, const char* compile_type)
{
    f << compile_type << " " << _expression << ":";

    erule_extension* e = extensions.first();
    if (!e) f << " { no extensions }LOGIC";
    int count = 0;  const MAX = 8;  boolean first = TRUE;
    for ( ; e; e = extensions.next(e)) {
	if (first) first = FALSE;
	else f.put(',');
	if (count++ == MAX) { f << "\n\t";  count = 0; }
	f << *e;
    }
    f << ";\n";
}


void erule_rule::check_logic()
    { append(LOGIC, 0); }	// No harm if it's already there


erule_rule::erule_rule(erule_entry* parent) : _expression(0)
{
    if (!PRIM) order_dependent_static_init();
    append(PRIM, parent->compile_type());
    append(parent->compile_type(), 0);
    check_logic();
}


boolean erule_rule::forced_to_primitive(erule_drawing_extension* de)
{
    if (!de) return FALSE;
    erule_extension* ext;
    for(ext = extensions.first(); ext; ext = extensions.next(ext)) {
        if (*ext == *de) break;
    }
    
    return !ext ? FALSE : ext->kind() == OTHER_PRIM_EXTENSION;
}


// Return 0 if not found or if max value is non-zero and the returned
// value would exceed or equal it.
int erule_rule::ord(erule_drawing_extension* de, int max_value)
{
    int val = 0;
    erule_extension* ext;
    for(ext = extensions.first(); ext; ext = extensions.next(ext)) {
	val++;
	if (max_value && val >= max_value) return 0;
        if (*ext == *de) return val;
    }
    return 0;
}


// Return 0 if not found or if max value is non-zero and the returned
// value would exceed or equal it.
int erule_rule::ord(erule_drawing_special* s, int max_value)
{
    int val = 0;
    erule_extension* ext;
    for(ext = extensions.first(); ext; ext = extensions.next(ext)) {
	val++;
	if (max_value && val >= max_value) return 0;
        if (*ext == *s) return val;
    }
    return 0;
}


// If (!this) just check syntax.  Return TRUE iff syntax ok
boolean erule_rule::parse(erule_lex* lex, erule_entry* parent)
{
    const smallset SEMI_COMMA = smallset(LEX_SEMI) | smallset(LEX_COMMA);

    if (!PRIM) order_dependent_static_init();

    boolean ok = TRUE;
#define ERROR(errnum) (lex->error(errnum), ok=FALSE)
#define SKIP(errnum) \
    { ERROR(errnum);  lex->skip(SEMI_COMMA);  continue; }    

    boolean first = TRUE;
    if (*lex && *lex != LEX_END && *lex != LEX_SEMI) do {
	if (!first) lex->next_token();  
	else first = FALSE;

	if (*lex != LEX_ID) SKIP(ERR_EXP_ID);

        erule_extension* extension;
	boolean eok;
	extension = new erule_extension(lex, parent, &eok);
	if (!eok) ok = FALSE;
	if (this) append(extension);
	else delete extension;

	if (*lex && *lex != LEX_COMMA && *lex != LEX_SEMI)
	    SKIP(ERR_EXP_COMMA);
    } while (*lex == LEX_COMMA);
    if (*lex == LEX_SEMI) lex->next_token();
    else ERROR(ERR_EXP_SEMI); 

    if (this) check_logic();
    return ok;
}

