/* Reporting assertion check violations */

#define assert(s) Xassert(s, __FILE__, __LINE__)
#define FAULT(s) Xsuicide(s, __FILE__, __LINE__)


/* Assertion checking */

#define AS(s) ((s) ? 1 : (FAULT("!(s)"), 0))

#ifdef DEBUGI
#define as(s) AS(s) /* fatal check */
#define soft_as(s) ((s) ? 1 : (assert("!(s)"), 0)) /* non-fatal check */
#else
#define as(s)            /* temporary fatal check disabled */
#define soft_as(s)       /* temporary non-fatal check disabled */
#endif DEBUGI

/* When given code like
     static int foo;
     
     bar()
     {
         if (&foo < 0) printf("No way\n");
     }
   our C compiler generates a cmpl instruction with 2 immediate operands,
   which is an illegal instruction to the processor.  To avoid this,
   the address check copies the pointer into a variable.
*/
   
#ifdef DEBUGI
#define ADRCK(p) \
    { char *X = (char *)(p); if ((int)X == 0) FAULT("NULL pointer p"); }
#else
#define ADRCK(p) /* no-op */
#endif DEBUGI

