


/*
    dwg_entry.cl -- The available extensions, versions,  and
    pages for a drawing.  Intended for internal use only.
*/
#ifndef ER_DWG_ENTRY_H
#define ER_DWG_ENTRY_H 1
#include "er_heap.h"
#include "Clib/stringt.h"


#include "dwg_special.h"
#include "dwg_version.h"
#include "rule.h"
class erule_drawing_extension;

class erule_lex;

class ds_compdwg;

gavl_define(_name,erule_drawing_exception,string);
class erule_drawing_exception {
    gavl_inst(_name,erule_drawing_exception,string);
public:
    erule_extension* extension;
    erule_drawing_exception(const string&, erule_extension*);
    const string& name() { return _name; }
};
gavl_inline(_name,erule_drawing_exception,string);


gavl_define(_name,erule_drawing_entry,string);
class erule_drawing_entry {
    gavl_inst(_name,erule_drawing_entry,string);
    gringroot(_next,erule_drawing_special) specials;
    gringroot(next,erule_drawing_version) versions;

    boolean init_flag;
    boolean expressions_read;
    gavlroot(_name,erule_drawing_exception,string) exceptions;
    erule_drawing_version* enter_version(int);
    erule_drawing_special* enter_special(const string& extension,
                                         const ds_compdwg&);
    void selection_error(int errnum, erule_rule*);
    void read_expressions();
    void parse_menu_body(erule_lex*);
    void parse_menu_properties(erule_lex*);
    void read_pages(const ds_compdwg&);
    void read_special_files(const ds_compdwg&);
public:
    erule_drawing_entry(const string&);
    ~erule_drawing_entry()
        { fault("~erule_drawing_entry() not implemented"); }
    erule_drawing_special* select_special(erule_rule*);
    boolean is_single_versioned();
    boolean is_initialized();
    const string& name();

    erule_drawing_extension*
    select_extension(erule_rule*, boolean non_existence_is_not_error);

    erule_drawing_extension* select_from_single_version(erule_rule*);
        // This one assumes it has a single-versioned drawing and it does not
        // check expressions -- it merely returns the appropriate extension
        // specified by the given rule.

    void initialize_entry();
    void read_menu(erule_drawing_extension* menu);
    void set_expression_from_menu(int version, const erule_expression&);
    void menu_error(int, const char* property = 0);

    void push_exception(erule_rule*, const string& context);
    void pop_exception(erule_rule*, const string& context);
    void enter_exception(const string& context, erule_extension*);

    void dump(ostream&);
};
gavl_inline(_name,erule_drawing_entry,string);


inline const string& erule_drawing_entry::name() { return _name; }
inline boolean erule_drawing_entry::is_initialized()
    { return init_flag; }
#endif



































