
/*
    dwg_extension.cl -- The pages available for one version.
*/
#ifndef ER_DWG_EXT_H
#define ER_DWG_EXT_H
#include "Clib/gring.h"
#include "Clib/stringt.h"

#include "expression.h"
#include "dwg_page.h"


class erule_extension;
class erule_drawing_page;
class erule_drawing_version;
class erule_drawing_entry;

class ds_compdwg;

gring_define(next,erule_drawing_extension);

class erule_drawing_extension {
    friend boolean operator==(const erule_drawing_extension&, const erule_extension&);
    friend boolean operator==(const erule_extension&, const erule_drawing_extension&);
    gring_inst(next,erule_drawing_extension);
    string _name;
    gringroot(next,erule_drawing_page) pages;
    erule_expression _expression;
    erule_drawing_version* version;
    ds_compdwg *dsd_ptr; //Assoc to a ds_compdwg(represents the DS name hierarchy)
    boolean expr_found_in_menu;
    void collision_error(const ds_compdwg&);
public:
    erule_drawing_extension(erule_drawing_version*,
                            const string& extension,
                            const ds_compdwg *ds_ptr);
    ~erule_drawing_extension();
    erule_drawing_extension* check_drawing_collision(const ds_compdwg& ds_comp_mod);
        // Returns "this" if ok, 0 if error
        // (Error  reported herein)
    erule_drawing_extension*
    check_prim_collision(const string& extension, const ds_compdwg& ds_comp_mod);
        // Returns "this" if ok, 0 if error
        // (Error  reported herein -- drawing collsion also checked)
    boolean read_expression(erule_drawing_entry*);
        // Returns FALSE iff this is a version 1 MACRO_DEFINITION
    void set_expression_from_menu(erule_drawing_entry*,
                                  const erule_expression&);

    boolean operator==(const erule_drawing_extension&);
    boolean is_prim();  // TRUE iff a PRIM/PART extension

    boolean is_default();
    boolean evaluate();
    erule_drawing_page* enter_page(int);












    void error_dump_expression();

    erule_drawing_page* first_page();
    erule_drawing_page* next_page(erule_drawing_page*);
    const string& name() { return _name; }
    int version_number();
    ds_compdwg *get_associated_ds_compdwg()
    { return dsd_ptr; }
    const char* connectivity_file(erule_drawing_entry*, erule_drawing_page*);

    void dump(ostream&);
};

#ifndef VAX /* VAXC has trouble with resulting expressions */
gring_inline(next,erule_drawing_extension);
#endif


inline boolean erule_drawing_extension::is_default()
    { return _expression.is_default(); }
inline boolean erule_drawing_extension::evaluate()
    { return _expression.evaluate(); }

inline erule_drawing_page* erule_drawing_extension::first_page()
    { return pages.first(); }

inline erule_drawing_page* erule_drawing_extension::
next_page(erule_drawing_page* page)
    { return pages.next(page); }

#include "dwg_version.h"  /* for inline def of version_number() */
#endif
















