







/*
    dwg_page.cl -- a page  available  for  some  (schematic)
    drawing version.
*/
#ifndef ER_DWG_PAGE_H
#define ER_DWG_PAGE_H
#include "Clib/gring.h"
#include "er_heap.h"

gring_define(next,erule_drawing_page);

class erule_drawing_page{
    gring_inst(next,erule_drawing_page);
    int _page_number;
public:
    erule_drawing_page(int page_number);
    ~erule_drawing_page();
    int page_number();
};

inline erule_drawing_page::erule_drawing_page(int page_number)
{
    AS(!this);
    this = (erule_drawing_page*)erule_heap.mem(sizeof(*this));
    _page_number = page_number;
}

inline erule_drawing_page::~erule_drawing_page()
    { erule_heap.memfree(this, sizeof(*this));  this = 0; }

inline int erule_drawing_page::page_number()
    { return _page_number; }

#ifndef VAX
gring_inline(next,erule_drawing_page);
#else
gring_functions(next,erule_drawing_page,static);
#endif
#endif



















