#ifndef ER_DWG_SPECIAL_H
#define ER_DWG_SPECIAL_H
#include "Clib/gring.h"
#include "Clib/stringt.h"


#include "er_heap.h"

class erule_extension;

class ds_compdwg;

/*
    A special model found in some particular SCALD directory
    for some drawing.
*/
gring_define(_next,erule_drawing_special);
class erule_drawing_special {
    friend boolean operator==(const erule_drawing_special&, const erule_extension&);
    friend boolean operator==(const erule_extension&, const erule_drawing_special&);
    string _name;
    ds_compdwg *dsd_ptr; //Associated dwg in DS(DATA SERVICES)
    gring_inst(_next,erule_drawing_special);
public:
    // Internal to erule subsystem
    erule_drawing_special(const string&, ds_compdwg* dsp);
    ~erule_drawing_special() { fault("~erule_drawing_special()"); }
    const string& name();
    void collision_error(const ds_compdwg& dwg_comp_mod);
    ds_compdwg *get_associated_ds_compdwg()
    { return dsd_ptr; }
    

    void dump(ostream&);
};

#ifndef VAX
gring_inline(_next,erule_drawing_special);
#endif

inline erule_drawing_special::erule_drawing_special(const string& name, 
						    ds_compdwg* dsp)
{
    AS(!this);
    this = (erule_drawing_special*)erule_heap.mem(sizeof(*this));
    _name = name;  dsd_ptr = dsp;
}

inline const string& erule_drawing_special::name()
    { return _name; }


#endif













