#include <ctype.h>
#include "Clib/fault.h"
#include "error.h"

#include "dwg_page.h"
#include "dwg_extension.h"
#include "dwg_special.h"
#include "dwg_version.h"
#include "dwg_entry.h"

#include "/home/andre/hoshah/c++/ds/ds_comp.h"

erule_error erule_err;

erule_drawing_entry* erule_current_drawing = 0;
char* erule_current_extension = 0;
int erule_current_version = 0;
int erule_current_page = 0;

ds_compdwg *erule_current_ds_compdwg_ptr = 0;



inline int isidchar(int c)
    { return isalpha(c) || isdigit(c) || c == '_'; }


void erule_error::current_conn_file(int num)
{
    if (!(enabled = errors_enabled)) return;
    AS(!erule_current_ds_compdwg_ptr);
    AS(erule_current_drawing->name());

    message(num);
    *this ERR_INDENT << "Drawing=" << erule_current_drawing->name() <<
	"." << erule_current_extension;
    *this << "." << erule_current_version << "." << erule_current_page ERR_NL;
    ds_compdwg *ds_ptr;
    DSPath path(ds_ptr->StartPath());
//    DSPath path(erule_current_ds_compdwg_ptr->StartPath());
    *this ERR_INDENT << path.PathName() ERR_NL;
}


void erule_error::
message(int num, erule_drawing_entry* d)
{
    if (!(enabled = errors_enabled)) return;
#ifdef PASCAL_XFACE
    pascal_err(num);
#else
    fprintf(stderr, "Error number %d -- messages not implemented\n", num);
#endif
    if (d) {
	*this ERR_INDENT << "Drawing=" << d->name() ERR_NL;
	context();
    }
}

void erule_error::
message(int n, erule_drawing_entry* d, erule_drawing_extension* e,
	       erule_drawing_page* p)
{
    if (!(enabled = errors_enabled)) return;
    message(n);
    *this ERR_INDENT << "Drawing=" << d->name() << "." << e->name() <<
          "." << e->version_number();
    if (p) *this << p->page_number();
    *this ERR_NL;
}


static void erule_error::parse_line(const char* line, int column)
{
    //if (!enabled) return; /* redundant */
    *this << " " << line ERR_NL;
    int i;
    for (i = 0; i < column; i++) *this << " ";
    *this << "^" ERR_NL;
}


void erule_error::
parse(int n, const char* filename, const char* line, int lineno, int column)
{
    if (!(enabled = errors_enabled)) return;
    if (line) parse_line(line, column);
    message(n);
    if (filename) *this ERR_INDENT << "File name=" << filename ERR_NL;
    if (lineno) *this ERR_INDENT << "Line number=" << lineno ERR_NL;
}


void erule_error::
assert(int n, const char* filename, const char* line, int lineno, int column)
{
    enabled = TRUE;
    if (line) parse_line(line, column);
#ifdef PASCAL_XFACE
    pascal_assert(n);
#else
    fprintf(stderr, "Assertion violation number %d -- messages not implemented\n", n);
#endif
    if (filename) *this ERR_INDENT << "File name=" << filename ERR_NL;
    if (lineno) *this ERR_INDENT << "Line number=" << lineno ERR_NL;
}


#ifndef PASCAL_XFACE
void erule_error::context() 
{ 
    const char QUOTE = '"';
    if (!enabled) return;
    //char* p = ENV_STACK->get_current_context();
    char *p = 0;
    if (!p || !(*p)) {
	*this ERR_INDENT << "        No Parameters" ERR_NL;
	return;
    }

    // SIZE
    if (isdigit(*p)) {
	*this ERR_INDENT << "        SIZE=";
	do { this->put(*p++); } while isdigit(*p);
    }

    // Other parameters
    while (*p) {
	// Identifier
	*this ERR_INDENT << "        ";
	while (isidchar(*p)) this->put(*p++);
	this->put('=');

	// String
        ASSERT(*p == QUOTE);
	boolean done = FALSE;
	while (!done) {
	    for (p++; *p && *p != QUOTE; p++) this->put(*p);
	    ASSERT(*p == QUOTE);
	    if (*++p == QUOTE) { this->put(QUOTE); }
	    else done = TRUE;
	}
    }
}
#endif
