#include <ctype.h>
#include <string.h>
#include <stream.h>
#include "error.h"
#include "table.h"
#include "lex.h"

#include "/home/andre/hoshah/c++/ds/ds_comp.h"
#include "/home/andre/hoshah/c++/ds/ext_ds.h"



// Initialized by erule_table::read -- these can't be staticly initialized,
// as they depend on the prior initialization of the string table.
static string PRIM;
static string PART;
static string LOGIC;
static void order_dependent_static_init()
{
#   define init(s) s = "s"
    init(PRIM);  init(PART);  init(LOGIC);
#   undef init
}


void erule_table::dump(ostream& f)
{
    f << "\n{------------ Expansion rules -------------------------------}\n\n";
    _entry->dump(f);

    f << "{ Specials:";
    erule_special *s;
    for (s = first_special(); s; s = next_special()) f << " " << s->name();
    f << " }\n";

    f << "{ Extensions:";
    erule_interesting_extension *e;
    gavlinorder(_name,erule_interesting_extension,string)
	exts(interesting_extensions);
    for (e = exts.first(); e; e = exts.next()) f << " " << e->name();
    f << " }\n";
}


static void
strcpy_upper(register char* d, register const char* s)
{
    for ( ; *s; s++,d++) *d = islower(*s) ? toupper(*s) : *s;
    *d = 0;
}


static void
strcpy_lower(register char* d, register const char* s)
{
    for ( ; *s; s++,d++) *d = isupper(*s) ? tolower(*s) : *s;
    *d = 0;
}


inline char* cheat_to_charP(const char* p) { return (char*)p; }


/*
static int
file_to_standard(int platform, char* filename, char** file_type, char** other)
{
    char copy[256];

#ifdef DEBUG
    cerr << "file_to_standard(" << (platform == S_UNIX ? "UNIX" : "VMS") <<
	", " << filename << ")->";
#endif

    *other = 0;
    switch (platform) {
        case S_UNIX:
            if (strchr(filename, '.')) break;
	    strcpy_upper(copy, filename);
	    erule_special* s;
	    if (s = erule_the_rule_table->find_special(copy)) {
	        *file_type = cheat_to_charP(s->name());
#ifdef DEBUG
		cerr << *file_type NL;
#endif
		return TRUE;
	    }
	    break;
        case S_VMS:
            if (strchr(filename, '$')) break;
	    strcpy(copy, filename);
	    char* p = strchr(copy, '.');
	    if (!p || strcmp(p, ".DAT")) break;
	    *p = 0;
	    erule_special* s;
	    if (s = erule_the_rule_table->find_special(copy)) {
	        *file_type = cheat_to_charP(s->name());
#ifdef DEBUG

		cerr << *file_type NL;
#               endif
		return TRUE;
	    }
	    break;
	default:
	    fault("Unknown platform to files_to_standard");
	    break;
	}

#   ifdef DEBUG
    cerr << "a GED file\n";
#   endif
    return Sged_filename_translator(platform, filename, file_type, other);
}


static char *
standard_to_file(int platform, char* file_type, char* other)
{
#   ifdef DEBUG
    cerr << "standard_to_file(" << (platform == S_UNIX ? "UNIX" : "VMS") <<
	", " << file_type << ", " << other << ")->";
#   endif

    erule_special* s = erule_the_rule_table->find_special(file_type);
    if (!s) {
#	ifdef DEBUG
	cerr << "a GED file\n";
#	endif
        return Sged_scaldname_translator(platform, file_type, other);
    }

    static char copy[64];
    switch (platform) {
        case S_UNIX:
	    strcpy_lower(copy, s->name());
	    break;
        case S_VMS:
	    strcpy(copy, s->name());
	    strcat(copy, ".DAT");
            break;
	default:
	    fault("Unknown platform to files_to_standard");
	    return 0;
	}

#   ifdef DEBUG
    cerr << copy NL;
#   endif
    return copy;
}
*/

erule_table::erule_table(const string& compile_type)
{ 
    AS(!this);  AS(!erule_the_rule_table);
    this = erule_the_rule_table = (erule_table*)erule_heap.mem(sizeof(*this));
    _compile_type = compile_type;
    special_iterator = 0;
    //s_decl_rdir(file_to_standard);
    _entry = new erule_entry(compile_type);
    make_extension_interesting("PRIM");
    make_extension_interesting("PART");
}


erule_special* erule_table::find_special(const string& nm)
{
    erule_special* s;
    for (s = specials.first(); s; s = specials.next(s))
	if (s->name() == nm) break;
    return s;
}


void erule_table::enter_special(const string& nm)
{
    erule_special* s;
    for (s = specials.first(); s; s = specials.next(s))
	if (s->name() == nm) break;

    if (!s) {
	s = new erule_special(nm);
	specials.insert_front(s);
	//s_decl_ddir(nm, standard_to_file);
    }
}


erule_interesting_extension::erule_interesting_extension(const string& nm)
{
    this = (erule_interesting_extension*)erule_heap.mem(sizeof(*this));
    _name = nm;
}


boolean erule_table::extension_is_interesting(const string& s)
{ return (interesting_extensions.find(s)) ? TRUE : FALSE; }


void erule_table::make_extension_interesting(const string& nm)
{
    if (extension_is_interesting(nm)) return;
    erule_interesting_extension* ext = new erule_interesting_extension(nm);

    interesting_extensions.insert(ext);
}


// Return TRUE iff no parse errors (other than a trivial "expected END").
boolean erule_table::read(const string& filename)
{
#ifdef DEBUG
    cerr << "enter erule_table::read(0x" << hex((long)this) << ", " << filename << ")\n";
    dump(cerr);
#endif
    boolean ok = TRUE;
    
#   define ERROR(n) (lex.error(n), ok=FALSE)
#   define FERROR(errnum) { lex.error(errnum);  return FALSE; }
    
    const char* ds_filename = filename;


    if (!ds_filename) {
	erule_err.sdl();
	erule_err ERR_INDENT << "Null file specification for expansion.dat " ERR_NL;
	return FALSE;	
    }

    FILE *fp=0;
    //FILE *fp = dsfile_fopen(ds_filename, 0, 'r');
    int fd = dsfile_open(ds_filename, 0, 0, 0);

    if (fd < 0) {
	erule_err.message(ERR_CANT_OPEN_CN);
	erule_err ERR_INDENT << "DS Object=" << ds_filename ERR_NL;
	return FALSE;
    }
    
    //erule_lex lex(fp);
    erule_lex lex(fd);

    const char *tq = lex.val();
    if (tq) cout << "The Val in lex is " << tq << "\n";

    const char *q = lex.line(); //thie is the current line in the lex

    if (q) {
	cout << "The current line in lex is " << q << "\n";
    }

    q = lex.val();
    if (q) cout << "The Val in lex is " << q << "\n";

    cout.flush();

    if (!(lex.scald_file_type())) return FALSE;
    
    if (strcmp(lex.val(), "EXPANSION_RULES")) FERROR(ERR_WRONG_FILETYPE);
    lex.next_token();
    if (lex != LEX_SEMI) ERROR(ERR_EXP_SEMI);
    else lex.next_token();
    
    while (lex != LEX_EOF && lex != LEX_END) {
	if (lex != LEX_ID) {
	    ERROR(ERR_EXP_ID);  
	    lex.skip_past(LEX_SEMI);
	}
	else {
	    string comp_type = lex.val();
	    if (comp_type == PRIM) {
		ERROR(ERR_PRIM_COMPTYPE);
		erule_err ERR_INDENT << "LOGIC assumed" ERR_NL;
		comp_type = LOGIC;
	    }
	    else if (comp_type == PART) {
		ERROR(ERR_PART_COMPTYPE);
		// Already states that LOGIC is assumed
		comp_type = LOGIC;
	    }

	    lex.next_token();
	    enter(comp_type)->parse(&lex, filename);
	}
    }

    // Failure to terminate file with END. is non-fatal,
    // but extraneous junk is fatal

    if (lex != LEX_END) {
	if (lex != LEX_EOF) ok = FALSE;
	lex.error(ERR_EXP_END);
    }
    else {
        lex.next_token();
	if (lex != LEX_DOT) {
	    if (lex != LEX_EOF) ok = FALSE;
	    lex.error(ERR_EXP_DOT);
	}
	else {
	    lex.next_token();
	    if (lex != LEX_EOF) ERROR(ERR_EXP_EOF);
	}
    }
    // lex destructor closes file

#ifdef DEBUG
    cerr << "exit erule_table::read()\n";
    dump(cerr);
#endif
    return ok;
};
