(*
This file contains definitions for I/O between SVS Pascal processes
connected by pipes.  

Limitations:  The only way a message can vary in length is if it's
a character string.  You can't have variable-length lists of
parameters.

WARNING:
YOU CANNOT USE PASCAL READS AND WRITES INTERCHANGEABLY WITH THESE
PROCEDURES!  This is because the Pascal buffer information gets
screwed up when we do UNIX reads and writes.  We plan to fix this
eventually, but not soon.

Preston Gardner at Valid, April 1983.
*)

(* If platform is undefined, assume SUN *)
#ifndef S32
#ifndef PC_AT
#ifndef VAX
#ifndef PMAX
#ifndef SUN
#define SUN
#define ShX_undef_SUN
#endif SUN
#endif PMAX
#endif VAX
#endif PC_AT
#endif S32

#ifdef S32
#define SVS
#endif S32
#ifdef PC_AT
#define SVS
#endif PC_AT

#ifdef EXTERNAL
#define ShXEXTERNAL EXTERNAL
#undef EXTERNAL
#endif EXTERNAL

#ifdef SVS
unit escseq;
interface
#define EXTERNAL
#endif SVS

#if defined(SUN) || defined(PMAX)
#define EXTERNAL external;
#ifdef longint
#define ShXlongint longint
#undef longint
#endif longint
#define longint integer
#endif SUN || PMAX


const
    escseqstrsize = 512;

    sizcomiobuf     = 550;   (* depends on C code *)




    (**************************************************************)
    (*  ESCAPE SEQUENCE CODES                                     *)
    (**************************************************************)

    (* These codes must match in the Pascal and the C code! *)
    (* these are pseudo-sequences; low numbers reserved for these.  ESCERROR
    should always be 0 because then uninitialized things will probably map
    to it.  ESCLOWEST is used for loops. *)
    esclowest = 0;
    escerror = 0;
    esctext = 1;
    esceof = 2;

    (* regular sequences, in alphabetical order. *)
    esccmd = 3;
    esccpp = 4;
    esccpr = 5;
    esccub = 6;
    esccud = 7;
    esccuf = 8;
    esccup = 9;
    esccuu = 10;
    escdch = 11;
    escdcs = 12;
    escdl = 13;
    esced = 14;
    escel = 15;
    escend = 16;
    escerrmsg = 17;
    escich = 18;
    escil = 19;
    esciquit = 20;
    escmc = 21;
    escpl = 22;
    escppr = 23;
    escprompt = 24;
    escputinmenu = 25;
    escrm = 26;
    escrsm = 27;
    escrvm = 28;
    escsd = 29;
    escsm = 30;
    escst = 31;
    escsu = 32;
    escsvm = 33;
    escwakeup = 34;
    escgetfrommenu = 35;

    (* ESCHIGHEST is used in loops and is the same as the highest code. *)
    eschighest = 35;

    (**************************************************************)


type
    escseqstr = packed array[1..escseqstrsize] of char;

    (* Buffer passed to/from externals.  Must use longints for
    proper alignment. *)
    escseqbuf = record
        datatype : longint;
        x1 : longint;
        x2 : longint;
        y1 : longint;
        y2 : longint;
        num : longint;
        strlen : longint;
        str : ^escseqstr;
    end;

    string16 = packed array[1..16] of char;

    escrange = esclowest..eschighest;
    esctypeset = set of escrange;

    bdycomiobuf = packed array[1..sizcomiobuf] of char;
    comiobuf = ^bdycomiobuf;




(**********************************************************************)
(* Handy utilities -- not external (????)******************************)
(* ("Not external" seems to mean "not externally implemented", as they
   are certainly externally available -- bh)                          *)
(**********************************************************************)



procedure dumpbuf(var fi : text; var msg : escseqbuf);  EXTERNAL

procedure clearbuf(var msg : escseqbuf);  EXTERNAL

procedure initbuf(var msg : escseqbuf);  EXTERNAL

procedure smartmsgbufdump(
    var reportfile : text;      (* file to print debug IO to *)
    var msg : escseqbuf         (* message buffer *)
    );  EXTERNAL


procedure cpstr16totextbuffer(
    s16: string16;
    nchars : integer;
    var msg: escseqbuf;
    off : integer
    );  EXTERNAL

(**********************************************************************)
(* Initialize IO for escape sequences.  Must be called AFTER reset or
rewrite of file, but BEFORE first send or read is done. *)
function initesio(
    fdesc : longint;    (* UNIX file descriptor *)
    iop : comiobuf             (* IO buffer *)
    ) : boolean; (* true iff it worked *)  EXTERNAL


(**********************************************************************)
(* Send the message in the message buffer. *)
function sendescseq(
    iop : comiobuf;             (* IO buffer *)
    var buf : escseqbuf         (* message buffer -- var so we get pointer *)
    ) : boolean; (* error code *)  EXTERNAL

(* Flush all accumulated IO to force a write to the other process. *)
function flushescseq(
    iop : comiobuf
    ) : boolean; (* error code *)  EXTERNAL

(* Put the next message in the message buffer. *)
function readescseq(
    iop : comiobuf;
    var buf : escseqbuf         (* message buffer *)
    ) : boolean; (* error code *)  EXTERNAL

(* The external code keeps files that monitor reads and writes to the pipe.
This procedure lets the user turn the monitor on and off (default off) *)
procedure changemonitor(
    iop : comiobuf;
    turnon : longint    (* 1 if we want to turn it on, 0 if off *)
    );   EXTERNAL


(* Clean up defines *)
#ifdef ShX_undef_SUN
#undef SUN
#undef ShX_undef_SUN
#endif ShX_undef_SUN

#undef EXTERNAL
#ifdef ShXEXTERNAL
#define EXTERNAL ShXEXTERNAL
#undef ShXEXTERNAL
#endif ShXEXTERNAL

#ifdef longint
#undef longint
#endif longint

#ifdef ShXlongint
#define longint ShXlongint
#undef ShXlongint
#endif ShXlongint

