: 'Script that reads scaldkit file and installs to $1 (or root)'
: 'from $2 (or current directory) using scaldkit in $2 (or currend dir)'
echo "I hope you're logged in as ROOT"
if [ -z "$2" ]
then
    fromdir="."
else
    fromdir="$2"
fi
if [ -z "$1" ]
then
    todir="/usr/valid"
else
    todir="$1"
fi
cat "$fromdir/scaldkit" | while read from to perm own group
do
  if [ -f "$fromdir/$from" ]
  then
    echo Installing "$fromdir/$from" to "$todir/$to" $perm $own $group
    rm -f "$todir/$to"
    cp "$fromdir/$from" "$todir/$to"
    chmod $perm "$todir/$to"
    chown $own "$todir/$to"
    chgrp $group "$todir/$to"
  else
    echo "$fromdir/$from" NOT FOUND.
  fi
done
if [ "$todir" = /usr/valid ]
then
    case `ls $fromdir/*.mk` in
    '')
	echo "Nothing to secure";
	;;
    *)
	for i in $fromdir/*.mk
	do
	    echo "Securing $i"
	    locksmith `getetheradd` $i | addvpass
	    cp $i /usr/vsecure/mkeys
	done
	;;
    esac
fi
if [ -f "$fromdir/filelinks" ]
  then
    cat "$fromdir/filelinks" | while read from to
    do
      if [ -f "$todir/$from" ]
      then
	echo Linking "$todir/$from" to "$todir/$to"
	rm -f "$todir/$to"
	ln "$todir/$from" "$todir/$to"
      else
	echo "$todir/$from" NOT FOUND.
      fi
    done
fi
if [ -f "$fromdir/symblinks" ]
  then
    cat "$todir/symblinks" | while read from to
    do
      if [ -f "$todir/$from" ]
      then
	echo Symbolicly linking "$todir/$from" to "$todir/$to"
	rm -f "$todir/$to"
	ln -s "$todir/$from" "$todir/$to"
      else
	echo "$todir/$from" NOT FOUND.
      fi
    done
fi
