
#include "ds_vopen.h"

#if defined(SUN3) || defined(SUN4)
#ifndef SUN
#define SUN
#endif
#endif

#ifdef SUN
#define UNIX
#define cexternal external c
#define LENGTH_HACK
#endif SUN

#ifdef PMAX
#define UNIX
#define cexternal external
#endif PMAX



#define longint integer




const
    R_OK = 4;
    W_OK = 2;

    WRITE_CREATE = 513;  { O_WRONLY | O_CREAT }
    RW_RW_RW = 438;      { 0666 }
    NO_WRITE = 21;       { "ioresult" error code }
    NO_READ = 20;        { "ioresult" error code }

#if defined(SUN) || defined(PMAX)
    INVALID_PARAM = 22;  { errno value }
    NO_DSREAD = 25;
    NO_DSWRITE = 26;	
    DUP2_FAILS = 599; { Out of range of errno numbers -- means just this }
#endif SUN || PMAX

{ Local types are in mixed case so that they are not likely to collide
  (on the SUN) with global types defined by the program using this
  (this module being compiled case-sensitively on the SUN). }


type
    Getenv_Res = ^big_env_val_str;
    File_Name = packed array[1..max_string_length] of char;
#ifdef UNIX
    Dummy_Ptr = ^integer;
    CFile = Dummy_Ptr;
#endif UNIX



function getenv(var name : char_array): Getenv_Res; cexternal;
function get_real_name_from_dsenv(var applnname : char_array; var name : char_array; 
	    var logname : alfa): longint; cexternal;
#ifdef UNIX
function textfdsc(var f: text): longint; cexternal;
/*file desc when file opened with a c call*/
function ctextfdsc(var f: text): longint; cexternal; 
function crewrite(var f : text; var name : char_array; var logname : alfa; bufsiz : integer) : boolean; cexternal;
function ds_crewrite(var f : text; var appln_name : sstring; var design : sstring; var name : sstring; var logname : alfa; bufsiz : integer) : boolean; cexternal;
function ds_creset(var f : text; var appln_name : sstring;  var design : sstring; var name : sstring; var logname : alfa; bufsiz : integer) : boolean; cexternal;
function ds_cbreset(var f : binaryfile; var appln_name : sstring;  var design : sstring; var name : sstring; var logname : alfa; bufsiz : integer) : boolean; cexternal;
function ds_cbrewrite(var f : binaryfile; var appln_name : sstring; var design : sstring; var name : sstring; var logname : alfa; bufsiz : integer) : boolean; cexternal;
function WRcreate(var fname: char_array): boolean; cexternal;
function dup2(oldfd, newfd: longint):longint; cexternal;
{ But remember to REVERSE the params for SVS !! }
function ds_cfclose(var f: text): boolean; cexternal;
function ds_cfbclose(var f: binaryfile): boolean; cexternal;

#if defined(SUN) || defined(PMAX)
function CPFclose(var f: text): boolean; cexternal;
function PFclose(var f: text): boolean; cexternal;
function PFBclose(var f: binaryfile): boolean; cexternal;
function TextFptr(var f: text): CFile; cexternal;
function BFptr(var f: binaryfile): CFile; cexternal;
function fclose(f: CFile):longint; cexternal;
function UXerrno: longint; cexternal;
function access(var fname: char_array; mode: longint): longint; cexternal;
function errno_to_ioresult(error_num: longint): longint; cexternal;
procedure setbuf(f: CFile; buf: Dummy_Ptr); cexternal;
procedure mktemp(var name: char_array); cexternal;
procedure unlink(var name: char_array); cexternal;
function symlink(var name, symbolic: char_array): longint; cexternal;
function NameTooLong: longint; cexternal;
#endif SUN || PMAX

function to_ioresult; { (sys_code: longint): longint }
begin
#if defined(SUN) || defined(PMAX)
	to_ioresult := errno_to_ioresult(sys_code);
#endif SUN || PMAX
end;



function text_file_descr;  { (var f: text): longint }
begin  
	text_file_descr := textfdsc(f);  
end;
#endif UNIX




function vclose; { (var fi : text): boolean }
begin
#if defined(SUN) || defined(PMAX)
	if TextFptr(fi) = nil then 
		vclose := FALSE
    else begin
#ifdef SUN
		flush(fi);
#endif 
		vclose := PFclose(fi);
	end;
#endif SUN || PMAX

end { vclose } ;


function vbinclose; { (var fi : binaryfile): boolean }
begin

#if defined(SUN) || defined(PMAX)
    if BFptr(fi) = nil then 
		vbinclose := FALSE
    else begin
#ifdef SUN
		flush(fi);
#endif
		vbinclose := PFBclose(fi);
	end;
#endif SUN || PMAX

end { vbinclose } ;


function ds_vclose; { (var fi : text): boolean }
begin
#if defined(SUN) || defined(PMAX)
	if TextFptr(fi) = nil then 
		ds_vclose := FALSE
    else begin
#ifdef SUN
		flush(fi);
#endif 
		ds_vclose := ds_cfclose(fi);
	end;
#endif SUN || PMAX

end { ds_vclose } ;


function ds_vbinclose; { (var fi : binaryfile): boolean }
begin

#if defined(SUN) || defined(PMAX)
    if BFptr(fi) = nil then 
		ds_vbinclose := FALSE
    else begin
#ifdef SUN
		flush(fi);
#endif
		ds_vbinclose := ds_cfbclose(fi);
	end;
#endif SUN || PMAX

end { ds_vbinclose } ;


procedure copy_sstring_to_cstring(var name : char_array; str : sstring);
begin
end;

procedure copy_cstring_to_sstring(var name : char_array; str : sstring);
begin
end;

procedure copy_real_name(
	var realname : File_Name;
	var strname : sstring);
var
	i : integer;  
	length : longint;
begin
	length := ord(strname^[0]);
	for i := 1 to max_string_length do 
		realname[i] := ' ';
	for i := 1 to length do 
		realname[i] := strname^[i];
end { copy_real_name } ;


function get_environment_variable; 
{ ( vbl: alfa; 
	var val: big_env_val_str): boolean
}
var
	i: integer;
	envbl : char_array;
	result: Getenv_Res;
	done : boolean;
begin
	i := 1;
	done := false;
	while (i <= alfasize) and (not done) do
		if vbl[i] <> ' ' then
		begin
			envbl[i-1] := vbl[i];
			i := i + 1;
		end
		else 
			done := true;

	envbl[i-1] := chr(0);

	result := getenv(envbl);
	{ WARNING: result is a static that belongs to getenv.  We must make our
	  own copy of it. }

	if (result = nil) then
	begin
	{ environment variable not defined }
		get_environment_variable := false;
		for i := 1 to bigenvalsize do 
		begin
			val[i] := ' ';
		end;
	end
	else begin
		get_environment_variable := true;

		i := 1;
		while ((result^[i] <> chr(0)) and (i <= bigenvalsize)) do
		begin
			val[i] := result^[i];  i := i + 1;
		end;

		while (i <= bigenvalsize) do
		begin
			val[i] := ' ';  i := i + 1;
		end;
	end;
end { get_environment_variable } ;


#ifdef UNIX
procedure copy_to_cstring(var dest: char_array; var src: File_Name);
{ produce a null-terminated version of src in dest }
var
	last_char: integer;
	i: string_range;
	done: boolean;

begin
	last_char := max_string_length;
	done := FALSE;

	while (last_char > 0) and (not done) do
		if src[last_char] = ' ' then 
			last_char := last_char - 1
		else 
			done := TRUE;

	for i := 1 to last_char do 
		dest[i-1] := src[i];

	dest[last_char] := chr(0);
end { copy_to_cstring } ;


procedure get_real_name(var realname: File_Name; var logname: alfa);

var
    envbl: char_array;
    result: Getenv_Res;
    i: integer;  
    length: longint;
    done: boolean;

begin                                         { get_real_name }
  { copy LOGnAME to ENVBL. copy only to first blank, put in a NULL for 
    GETENV.  Calculate LENGTH on the fly}

	length := 1;
	done := false;

#ifndef SVS
  	for i := 0 to max_string_length do 
		envbl[i] := ' ';
#endif SVS
  	while (length <= alfasize) and (not done) do
		if logname[length] <> ' ' then
		begin
			envbl[length-1] := logname[length];
			length := length + 1;
		end
		else 
			done := true;

	envbl[length-1] := chr(0);
	length := length - 1;

	{get value of environment variable}

	result := getenv(envbl);

	{ WARNING: result is a static that belongs to getenv.  We must make our
	own copy of it. }

	if result = nil then
	begin
		{ no environment variable for this logname }
		{ copy logName to enVal -- for loop goes up to smaller of two bounds }
		for i := 1 to length do
        begin
			realname[i] := logname[i];
        end;
    end
	else begin
		length := 1;

		while ((result^[length] <> chr(0)) and 
				(length < max_string_length)) do
		begin
			realname[length] := result^[length];
			length := length + 1; 
		end;
	end;
end { get_real_name } ;


#ifdef LENGTH_HACK
procedure copy_to_file_name(var realname : File_Name; var cname: char_array);
var
	i : string_range;
begin
	for i := 1 to max_string_length do realname[i] := ' ';

	i := 1;
	while ((cname[i-1] <> chr(0)) and (i < max_string_length)) do
	begin
		realname[i] := cname[i-1];
		i := i + 1; 
	end;
end { copy_to_file_name } ;


function munge_name_if_too_long(var name : File_Name; 
                                var code: longint): boolean;
const
	MAX_SUN_LENGTH = 75;
	SYM_NAME = '/tmp/longnameXXXXXX';
	UNROOTED_SYM_NAME = 'longnameXXXXXX';
var
	i: string_range;
	done: boolean;
	temp_name: File_Name;
	cname: char_array;
	sym: char_array;
begin
	code := 0;
	i := max_string_length;  
	done := FALSE;

	while (i > 0) and (not done) do
		if name[i] = ' ' then 
			i := i - 1
		else 
			done := TRUE;

	if i <= MAX_SUN_LENGTH then 
		munge_name_if_too_long := false
	else begin
		munge_name_if_too_long := true;
		copy_to_cstring(cname, name);

		if name[1] = '/' then 
			temp_name := SYM_NAME
		else 
			temp_name := UNROOTED_SYM_NAME;

		copy_to_cstring(sym, temp_name);
		mktemp(sym);
		unlink(sym);

		if (symlink(cname, sym) = 0) then 
			copy_to_file_name(name, sym)
		else begin
			munge_name_if_too_long := false;
			code := NameTooLong;
		end;
	end;
end; {munge_name_if_too_long}


procedure cleanup_after_length_hack(var name: File_Name);
var
	cname: char_array;
begin
	copy_to_cstring(cname, name);
	unlink(cname);
end;
#endif LENGTH_HACK


function vopen;
{ ( var fi : text;
    logname : alfa;
    strname : sstring;
    mode : open_mode;
    var ret_code : longint) : boolean 
}
var
	ret : boolean;
	realname : File_Name;
	cname: char_array;
	fd: integer;
	bufsiz : integer;
	fn: text;
#ifdef LENGTH_HACK
    length_hack: boolean;
#endif LENGTH_HACK

begin                                                { vopen }
{ get realname from the env var logname or from strname }
	if strname = nil then 
		get_real_name(realname, logname)
	else if strname^[0] = chr(0) then 
		get_real_name(realname, logname)
	else 
		copy_real_name(realname, strname);

	copy_to_cstring(cname, realname);

	ret := false; { guilty until proven innocent }

#ifdef LENGTH_HACK
	length_hack := munge_name_if_too_long(realname, ret_code);
	writeln('return from length hack', length_hack);

	if ret_code = 0 then 
	begin { continue with body }
#endif LENGTH_HACK

	if (mode = read_mode) or (mode = unbuf_read) then
    begin 

#if defined(SUN) || defined(PMAX)
		if (access(cname, R_OK) <> 0) then 
			ret_code := UXerrno
		else begin
			ret := TRUE;
			reset(fi, realname);
			
			if (mode = unbuf_read) or (realname = '/dev/tty') then
				setbuf(TextFptr(fi), nil);
        end;
#endif SUN || PMAX
	end		 
	else if (mode = write_mode) or (mode = unbuf_write) then
    begin

(***********************************************************************
	Apparently, there is a bug in the PMAX Pascal compiler.

	If the variable "realname" is in fact equal to the constant "stderrname" 
	(from vopen.h) the first comparison succeeds BUT the second comparison 
	fails???

	Making the comparison to the literal strings, as below, fixes this
	for some reason.
************************************************************************)
	
#ifdef PMAX
		if (realname = 'STANDARD_ERROR') or (realname = 'STANDARD_OUTPUT') then
#else
		if (realname = stderrname) or (realname = stdoutname) then
#endif
		begin
#ifdef PMAX
			if realname = 'STANDARD_ERROR' then 
#else
			if realname = stderrname then 
#endif
				fd := 2
			else 
				fd := 1;

#if defined(SUN) || defined (PMAX) 
			rewrite(fi, '/dev/null');
			setbuf(TextFptr(fi), nil);
			if dup2(fd, textfdsc(fi)) <> - 1 then 
				ret := true
			else 
				ret_code := DUP2_FAILS;
#endif SUN || PMAX
		end 	
		else begin
#if defined(SUN) || defined(PMAX)
			if not WRcreate(cname) then 
				ret_code := UXerrno
			else begin
				rewrite(fi, '/dev/null');
				bufsiz := 0;	
				if crewrite(fn, cname, logname, bufsiz) then;
				if (mode = unbuf_write) or (realname = '/dev/tty') then
					setbuf(TextFptr(fi), nil);

				fd := ctextfdsc(fn);
				if dup2(fd, textfdsc(fi)) <> -1 then
				    ret := TRUE
                                else ret_code := DUP2_FAILS;
                                if CPFclose(fn) then;
			end;
#endif SUN || PMAX
		end;	
	end
	else
		ret_code := INVALID_PARAM;

#ifdef LENGTH_HACK
	end;  { body after length hack succeeded }
	if length_hack then 
		cleanup_after_length_hack(realname);
#endif LENGTH_HACK
	if ret then 
		ret_code := 0;
	vopen := ret;
end { vopen } ;


function vbinopen;
{ ( var fi : binaryfile;
    logname : alfa;
    strname : sstring;
    mode : open_mode;
    var ret_code: longint) : boolean
}
var
	ret : boolean;
	realname : File_Name;
	cname: char_array;
#ifdef LENGTH_HACK
	length_hack: boolean;
#endif LENGTH_HACK

begin { vbinopen }
{ textually this is the same as fopen except that we don't allow
  unbuffered I/O.  It has to be a different procedure in order to
  get around type checking.  }

	if strname = nil then 
		get_real_name(realname, logname)
	else if strname^[0] = chr(0) then 
		get_real_name(realname, logname)
	else 
		copy_real_name(realname, strname);

	copy_to_cstring(cname, realname);
	ret := false; { guilty until proven innocent }

#ifdef LENGTH_HACK
	length_hack := munge_name_if_too_long(realname, ret_code);
	if ret_code = 0 then 
	begin { continue with body }
#endif LENGTH_HACK

	if (mode = read_mode) or (mode = unbuf_read) then
	begin

#if defined(SUN) || defined(PMAX)
		if (access(cname, R_OK) <> 0) then 
			ret_code := UXerrno
		else begin
			ret := TRUE;
			reset(fi, realname);
        end;
#endif SUN || PMAX
	end
	else if (mode = write_mode) or (mode = unbuf_write) then
    begin

#if defined(SUN) || defined(PMAX)
		if not WRcreate(cname) then 
			ret_code := UXerrno
		else begin
			rewrite(fi, realname);
			ret := TRUE;
		end;
#endif SUN || PMAX
	end
	else 
		ret_code := INVALID_PARAM;
#ifdef LENGTH_HACK
	end;  { body after length hack succeeded }
	if length_hack then 
		cleanup_after_length_hack(realname);
#endif LENGTH_HACK
	if ret then 
		ret_code := 0;
	vbinopen := ret;
end { vbinopen } ;


function ds_vopen 
{
( var fi : text;
	    logname : alfa;
	    strname : sstring;
	    appln_name : sstring;
            design_name : sstring;
	    mode : open_mode;
	    var ret_code : longint) : boolean;
};


var
	ret : boolean;
	realname : File_Name;
	cname: char_array;
	apname: char_array;
	dname: char_array;
	fd: integer;
	fn: text;
	ret_value : longint;

begin                                                { ds_vopen }
	ret := FALSE;
	if (mode = read_mode) or (mode = unbuf_read) then
          begin 

		begin
		  reset(fi, '/dev/null');	
                  if (ds_creset(fn, appln_name, design_name, strname, logname, 0)) then
		    begin	
	              if (mode = unbuf_read) then setbuf(TextFptr(fi), nil);                                 fd := ctextfdsc(fn);
                      if dup2(fd, textfdsc(fi)) <> -1 then
		        ret := TRUE
		      else ret_code := DUP2_FAILS;
	            end
		  else begin ret := FALSE; ret_code := NO_DSREAD; end;
                end;
	  end		 
	else if (mode = write_mode) or (mode = unbuf_write) then
	    begin
	      rewrite(fi, '/dev/null');
              if ds_crewrite(fn,appln_name,design_name,strname,logname,0) then
                begin
                  if (mode = unbuf_write) then
		    setbuf(TextFptr(fi), nil);
                    fd := ctextfdsc(fn);

	            if dup2(fd, textfdsc(fi)) <> -1 then
		      ret := TRUE
                    else ret_code := DUP2_FAILS;
	        end
             else begin ret := FALSE; ret_code := NO_DSWRITE; end;
            end
	else
          ret_code := INVALID_PARAM;

	if ret then 
		ret_code := 0;
	ds_vopen := ret;
end { ds_vopen } ;


function ds_vbinopen;
{ 
( var fi : binaryfile;
	    logname : alfa;
	    strname : sstring;
	    appln_name : sstring;
            design_name : sstring;
	    mode : open_mode;
	    var ret_code: longint) : boolean;
}

var
	ret : boolean;
	realname : File_Name;
	ret_value : longint;
	buf_siz : integer;
#ifdef LENGTH_HACK
	length_hack: boolean;
#endif LENGTH_HACK

begin { ds_vbinopen }
{ textually this is the same as fopen except that we don't allow
  unbuffered I/O.  It has to be a different procedure in order to
  get around type checking.  }

#ifdef LENGTH_HACK
	length_hack := munge_name_if_too_long(realname, ret_code);
	if ret_code = 0 then 
	begin { continue with body }
#endif LENGTH_HACK


	if (mode = read_mode) or (mode = unbuf_read) then
	begin

#if defined(SUN) || defined(PMAX)
		begin
			ret := FALSE;
			if (ds_cbreset(fi, appln_name, design_name, 
				strname, logname, 0)) then ret := TRUE;
                end;
#endif SUN || PMAX
	end
	else if (mode = write_mode) or (mode = unbuf_write) then
    begin

#if defined(SUN) || defined(PMAX)
		begin
			if (ds_cbrewrite(fi, appln_name, design_name, 
				strname, logname, 0)) then ret := TRUE;
		     end;
#endif SUN || PMAX
	end
	else 
		ret_code := INVALID_PARAM;

#ifdef LENGTH_HACK
	end;  { body after length hack succeeded }
	if length_hack then 
		cleanup_after_length_hack(realname);
#endif LENGTH_HACK
	if ret then 
		ret_code := 0;
	ds_vbinopen := ret;
end { ds_vbinopen } ;
#endif UNIX



procedure write_ioresult { (var fi : text; iores : integer) };
begin
  case iores of
    { see pp. 117-118 of SVS Pascal manual }
    1 : write(fi,'Parity error or CRC error.');
    2 : write(fi,'Invalid device number.');
    3 : write(fi,'Invalid input-output request.');
    4 : write(fi,'Nebulous Hardware Error.');
    5 : write(fi,'Volume went off-line.');
    6 : write(fi,'File lost in directory.');
    7 : write(fi,'Bad file name.');
    8 : write(fi,'No root on volume.');
    9 : write(fi,'Volume not found.');
    10 : write(fi,'File not found.');
    11 : write(fi,'Duplicate directory entry.');
    12 : write(fi,'File already open.');
    13 : write(fi,'File not open.');
    14 : write(fi,'Bad input information.');
    15 : write(fi,'Ring buffer overflow.');

#if defined(SUN) || defined(PMAX)
    16 : write(fi, 'Permission denied');
#endif SUN || PMAX
    17 : write(fi,'Invalid seek.');
    18 : write(fi,'Error of unknown type.');
    19 : write(fi,'Error of unknown type.');
    { these three codes are of my invention -- not SVS }
    20 : write(fi, 'Can''t open file for read.');
    21 : write(fi, 'Can''t open file for write.');
    22 : write(fi, 'Dup to stderr failed.');
    23 : write(fi, 'Invalid parameter.');
    24 : write(fi, 'Name too long and unable to create symbolic link.');
    25 : write(fi, 'Can''t open data services file for read.');	
    26 : write(fi, 'Can''t open data services file for write.');
#if defined(SVS) || defined(PMAX)
    otherwise : write(fi,'Error of unknown type.');
#else  
    otherwise write(fi,'Error of unknown type.');
#endif SVS || PMAX
  end;
end;                  { write_ioresult }



