#ifdef MKSSCANINT
#define SSCANNAME sscanint
#define MYNAME "sscanint"
#else
#define SSCANNAME sscannat
#define MYNAME "sscannat"
#endif



int SSCANNAME(stp,d,defawlt)
char *stp;
int *d;
int defawlt;		/* default value in case there is no number there */
{
    register char *p;
    register int acc;
    int ret = 0;

#   ifdef DEBUG
    fprintf(stderr, "%s(%lx,%lx,%d)\n", MYNAME, stp, d, defawlt);
#   endif
    p = stp;
    *bufend = '\0';
    acc = 0;
    while (isdigit(*p)) {
#	ifdef DEBUG
	fprintf(stderr, "*p is digit, = <%c>\n", *p);
#	endif
	acc = (10 * acc) + (*p - '0');
	p++;
    }
#   ifdef DEBUG
    fprintf(stderr, "*p is not digit, = <%c>\n", *p);
#   endif

#   ifdef MKSSCANINT
    *d = DECODNEG(acc);
#   else
    *d = acc;
#   endif

    if (p == stp) {
	*d = defawlt;
    }

    ret = p - stp;
#   ifdef DEBUG
    fprintf(stderr, "%s returns %d, *d = %d\n", MYNAME, ret, *d);
#   endif
    return(ret);
}



#undef SSCANNAME
#undef MYNAME
