#ifdef VAX
[INHERIT('VOPEN')]
#define longint integer
#define text_file_descr(f) 99
#endif VAX

#ifdef PMAX
#include "vopen.h"
#define longint integer
#define UNIX
procedure unlink(var name: char_array); external;
#endif


program foo(input, output, monitor, outfile);


#ifdef S32
#define SVS
#define UNIX
#endif
#ifdef PC_AT
#define SVS
#define UNIX
#endif

#if defined(SUN3) || defined(SUN4)
#ifndef SUN
#define SUN 1
#endif
#endif


#ifdef SUN
#define UNIX
#include "vopen.h"
#define longint integer
#define cexternal external c
#endif SUN
#ifdef SVS
  uses
    {$U vopen.obj} vopenunit;
#endif

const
  
  OUTFILE_1_1 = 'First line to outfile (pass 1)';
  OUTFILE_2_1 = 'Last line to outfile (pass 1)';
  OUTFILE_1_2 = 'First line to outfile (pass 2)';
  OUTFILE_2_2 = 'Last line to outfile (pass 2)';
  TEMP_1_1 = 'First line to temp (pass 1)';
  TEMP_2_1 = 'Last line to temp (pass 1)';
  TEMP_1_2 = 'First line to temp (pass 2)';
  TEMP_2_2 = 'Last line to temp (pass 2)';

var
  monitor: text;
  outfile: text;
  rc: longint;
  name: sstring;
  nullstring: sstring;
  env_var_value: big_env_val_str;
#ifdef SVS
  line: string[MAX_STRING_LENGTH];
#else
  line: packed array[1..MAX_STRING_LENGTH] of char;
#endif SVS


#if defined(UNIX) && !defined(PMAX)
  procedure unlink(var name: char_array); cexternal;
#endif 

#define close_file(f) if not vclose(f) then writeln('Can''t close f!!')

  procedure readline(var fi: text);
    var
      c: char;
      i: integer;
  begin
#ifdef SUN
    line := '  ';
    i := 1;
    while (not eof(fi)) and (not eoln(fi)) do
      begin
	read(fi, c);
        if i < MAX_STRING_LENGTH then
          begin
	    line[i] := c;
	    i := i + 1;
	  end;
      end;
    if (not eof(fi)) then readln(fi);
#else
    readln(fi, line);
#endif SUN
  end;


  procedure writestring(var fi: text;  s: sstring);
  var
    i: integer;
    len: integer;
  begin
    if s = NIL then write(fi, '<nil>')
    else
      begin
	len := ord(s^[0]);
	write(fi, '"':1);
	for i := 1 to len do write(fi, s^[i]:1);
	write(fi, '"':1);
      end;
  end;


  procedure copy_to_string(a: alfa; dest: sstring);
  var
    i: integer;
    done: boolean;
  begin
    i := 1;  done := FALSE;
    while (i <= 16) and not done do
      begin
	if a[i] = ' ' then done := TRUE
	else dest^[i] := a[i];
	i := i + 1;
      end;
    dest^[0] := chr(i - 1);
  end;


  function rewrite_file(var fi: text;  logical: alfa;  name: sstring;
                        buffered: boolean): boolean;
    var
      mode: open_mode;
  begin
    rewrite_file := FALSE;
    if buffered then mode := write_mode
                else mode := unbuf_write;
    write('rewrite(', logical, ', ');
    writestring(output, name);
    writeln(')');
    if vopen(fi, logical, name, mode, rc) then 
      begin
	writeln('  succeeds rc = ', rc:1, ' fd = ', text_file_descr(fi):1);
	rewrite_file := TRUE;
      end
    else 
      begin
        write('  fails -- ');
	write_ioresult(output, to_ioresult(rc));
	writeln;
      end;
  end;


  function reset_file(var fi: text;  logical: alfa;  name: sstring;
                      buffered: boolean): boolean;
    var
      mode: open_mode;
  begin
    reset_file := FALSE;
    if buffered then mode := read_mode
                else mode := unbuf_read;
    write('reset(', logical, ', ');
    writestring(output, name);
    writeln(')');
    if vopen(fi, logical, name, mode, rc) then
      begin
	writeln('  succeeds rc = ', rc:1, ' fd = ', text_file_descr(fi):1);
	reset_file := TRUE;
      end
    else writeln('  fails rc = ', rc:1);
  end;


  procedure dump_env_var(name: alfa;  var { const } val: big_env_val_str);
    var
      i,len: integer;
      done: boolean;
  begin
    len := alfasize;  done := FALSE;
    while (len > 0) and not done do
      if name[len] = ' ' then len := len - 1
      else done := TRUE;
    for i := 1 to len do write(monitor, name[i]:1);

    write(monitor, '="');

    len := bigenvalsize;  done := FALSE;
    while (len > 0) and not done do
      if val[len] = ' ' then len := len - 1
      else done := TRUE;
    for i := 1 to len do write(monitor, val[i]:1);

    writeln(monitor, '"');
  end;


  procedure remove_file(name: sstring);
    var
      cname: char_array;
      i,len: string_range;
  begin
    len := ord(name^[0]);
    for i := 1 to len do cname[i-1] := name^[i];
#ifdef UNIX
    cname[len] := chr(0);
    unlink(cname);
#endif UNIX
#ifdef VMS
    for i := len to max_string_length do cname[i] := ' ';
    delete_file(cname);
#endif VMS
  end;


#ifdef UNIX
#ifndef PC_AT
  procedure test_long_filenames;
    const
      MIN_LONG = 70;
      MAX_LONG = 90;
    var
      len,i: string_range;
  begin
    copy_to_string('junk            ', name);
    for len := MIN_LONG to MAX_LONG do
      begin
	for i := 5 to len do name^[i] := chr(ord('0') + (i mod 10));
	name^[0] := chr(len);
	if rewrite_file(outfile, 'OUTFILE         ', name, TRUE) then
	  begin
	    writeln(outfile, TEMP_1_1);
	    writeln(outfile, TEMP_2_1);
	    close_file(outfile);
	  end;
	remove_file(name);
      end;
  
    copy_to_string('/tmp/junk       ', name);
    for i := 10 to MAX_LONG do name^[i] := chr(ord('0') + (i mod 10));
    name^[0] := chr(MAX_LONG);
    if rewrite_file(outfile, 'OUTFILE         ', name, TRUE) then
      begin
	writeln(outfile, TEMP_1_1);
	writeln(outfile, TEMP_2_1);
	close_file(outfile);
      end;
    remove_file(name);
  end { test_long_filenames } ;
#else PC_AT
  procedure test_long_filenames;  begin  end;
#endif PC_AT
#else UNIX
  procedure test_long_filenames;  begin  end;
#endif UNIX

begin
  new(nullstring);  nullstring^[0] := chr(0);
  new(name);
  if rewrite_file(monitor, 'MONITOR         ', NIL, TRUE) then
    begin
      writeln(monitor, 'First line to monitor');
      if get_environment_variable('OUTFILE         ', env_var_value) then
          dump_env_var('OUTFILE         ', env_var_value)
      else writeln('OUTFILE is undefined !!');
      if rewrite_file(outfile, 'OUTFILE         ', NIL, TRUE) then
        begin
          writeln(outfile, OUTFILE_1_1);
          writeln(outfile, OUTFILE_2_1);
	  close_file(outfile);
	end;
      if rewrite_file(outfile, 'OUTFILE         ', nullstring, TRUE) then
        begin
          writeln(outfile, OUTFILE_1_2);
          writeln(outfile, OUTFILE_2_2);
	  close_file(outfile);
	  writeln(monitor, 'The next close should fail');
	  close_file(outfile);  { test close "failure" }
	end;
      copy_to_string('temp.dat        ', name);
      if rewrite_file(outfile, 'OUTFILE         ', name, TRUE) then
        begin
          writeln(outfile, TEMP_1_1);
          writeln(outfile, TEMP_2_1);
	  close_file(outfile);
	end;
      if rewrite_file(outfile, 'OUTFILE         ', name, TRUE) then
        begin
          writeln(outfile, TEMP_1_2);
          writeln(outfile, TEMP_2_2);
	  close_file(outfile);
	end;

      if reset_file(outfile, 'OUTFILE         ', nullstring, TRUE) then
        begin
	  if eof(outfile) then writeln(monitor, 'Premature EOF')
	  else
	    begin
	      readline(outfile);
	      if line <> OUTFILE_1_2 then
		writeln(monitor, 'OUTFILE 1 garbled')
	      else if eof(outfile) then
		writeln(monitor, 'Premature EOF')
	      else
	        begin
	          readline(outfile);
	          if line <> OUTFILE_2_2 then
		    writeln(monitor, 'OUTFILE 2 garbled')
	          else if eof(outfile) then
		    writeln(monitor, 'OUTFILE ok')
		  else writeln(monitor, 'EOF?!!')
	        end;
	    end;
	  close_file(outfile);
	end;
      if reset_file(outfile, 'OUTFILE         ', name, TRUE) then
        begin
	  if eof(outfile) then writeln(monitor, 'Premature EOF')
	  else
	    begin
	      readline(outfile);
	      if line <> TEMP_1_2 then
		writeln(monitor, 'TEMP 1 garbled')
	      else if eof(outfile) then
		writeln(monitor, 'Premature EOF')
	      else
	        begin
	          readline(outfile);
	          if line <> TEMP_2_2 then
		    writeln(monitor, 'TEMP 2 garbled')
	          else if eof(outfile) then
		    writeln(monitor, 'TEMP ok')
		  else writeln(monitor, 'EOF?!!')
	        end;
	    end;
	  close_file(outfile);
	end;

      test_long_filenames;

      writeln(monitor, 'Last line to monitor');
      close_file(monitor);
    end;
end.
