#include "unixtime.h"

#if defined(SUN3) || defined(SUN4)
#ifndef SUN
#define SUN 1
#endif
#endif

#ifdef S32
#define SVS
#endif
#ifdef PC_AT
#define SVS
#endif

#ifdef SVS
implementation
#else
#define longint integer
#endif SVS

#ifdef SUN
#define cexternal external c
#endif SUN

#ifdef PMAX
#define cexternal external
#endif PMAX


{ Local types are in mixed case so that they are not likely to collide
  (on the SUN) with global types defined by the program using this
  (this module being compiled case-sensitively on the SUN). }

type
    Time_Buffer_Structure = record
                              proc_user_time: longint;
                              proc_system_time: longint;
                              child_user_time: longint;
                              child_system_time: longint;
                            end;

function time(l: longint): longint; cexternal;

procedure times(var b: Time_Buffer_Structure); cexternal;

function ctime(var c: longint): time_string_ptr; cexternal;

function epochsec;
begin
  epochsec := time(0);
end;

function vclock;
var
  time_buffer: Time_Buffer_Structure;
begin
  times(time_buffer);
  vclock := time_buffer.proc_user_time + time_buffer.proc_system_time;
end;

procedure convert_time; {(var secs: longint; var s: time_string)}
var
    i : integer;
    time_ptr: time_string_ptr;

begin
    time_ptr := ctime(secs);

    for i := 1 to time_string_size-2 do
      s[i] := time_ptr^[i];

    s[time_string_size-1] := ' ';
    s[time_string_size]   := ' ';
end;

#ifdef SVS
end.
#endif SVS
