

(* NOTE -- this file now declares the constant max_string_length
   and the types string_range, char_array and sstring, so you
   should not also declare them.

   Sstring is a Valid (SCALD) string, with char count in the first byte.  
   Some of our programs use sstring for this type and some use xtring.
   There are many ways to resolve the conflict for those that use
   xtring.
*)

   
(* If platform is undefined, assume SUN *)













[INHERIT('SYS$LIBRARY:STARLET'), ENVIRONMENT('VOPEN.PEN')]
module vopen;


const
    stderrname = 'STANDARD_ERROR';
    stdoutname = 'STANDARD_OUTPUT';

    alfasize = 16;

    max_string_length = 255;
    bigenvalsize = 560;   { lcf added  & changed - used to be 255 }
    { This must be big enough to hold a termcap entry if we have to pick it
    up from the environment.  Some of the termcap entries for the Ann Arbor
    Ambassador -- which resembles the BBN window package -- are as big as
    558 chars. }
type

    alfa = packed array [1..alfasize] of char;

    binaryfile = file of integer;              { for binary output files }
    open_mode = (read_mode, write_mode, unbuf_read, unbuf_write);
    big_env_val_str = packed array [1..bigenvalsize] of char;

    string_range  = 0..max_string_length;
    char_array = packed array[string_range] of char;
    sstring = ^char_array;


function vopen(
    var fi : text;
    logname : alfa;
    strname : sstring;
    mode : open_mode;
    var ret_code : integer
    ) : boolean; forward;
{ Vopen is used by the compiler, simulator etc. to open UNIX files by treating
an environment variable for that file's name as a logical name for the file. 
It is also capable of opening files directly by name -- if strname is non-NIL
and has non-0 length, then it is used as the name of the file. 
ret_code is a system-dependent error code -- it is an ioresult code for
the S32 and an errno code for the SUN.  It can be converted into an SVS
code (for use with write_ioresult) by calling to_ioresult(ret_code). }

procedure write_ioresult(var fi : text; iores : integer); forward;
{ Given an error code returned by ioresult, print the appropriate error
message on file f. }

function to_ioresult(sys_code: integer): integer;  forward;
{ Given a system dependent error code (as returned by vopen), return
  an approximately equivalent ioresult error code }

function text_file_descr(var f: text): integer; forward;
{ Get the UNIX file descriptor for this file.  Returns meaningless garbage
if the file is not open. }

function vclose(var fi : text): boolean; forward;

function vbinopen(
    var fi : binaryfile;
    logname : alfa;
    strname : sstring;
    mode : open_mode;
    var ret_code: integer
    ) : boolean; forward;
{ Same as fopen, but for binary files.  Used for Simulator trace file. }

function vbinclose(var fi : binaryfile): boolean; forward;

function get_environment_variable(
    vbl: alfa;
    var val: big_env_val_str
    ): boolean; forward;
{ Get the contents of an environment variable; return true if the variable
was defined.  Used by the Simulator to get screen length and width from
the environment. }


(* Clean up defines *)




























[HIDDEN]

const
    R_OK = 4;
    W_OK = 2;

    WRITE_CREATE = 513;  { O_WRONLY | O_CREAT }
    RW_RW_RW = 438;      { 0666 }
    NO_WRITE = 21;       { "ioresult" error code }
    NO_READ = 20;        { "ioresult" error code }



    %include 'sys$library:passtatus.pas'
    INVALID_PARAM = PAS$K_INVARGPAS;
    NO_RMS_ERROR = 1;
    NO_OPERATION = 0;
    READING = 1;
    WRITING = 2;


{ Local types are in mixed case so that they are not likely to collide
  (on the SUN) with global types defined by the program using this
  (this module being compiled case-sensitively on the SUN). }


[HIDDEN]

type
    Getenv_Res = ^big_env_val_str;

    File_Name = packed array[1..max_string_length] of char;



[HIDDEN]
  var
    last_operation: integer;
  value
    last_operation := NO_OPERATION;



[HIDDEN]
function umask(%IMMED code: integer): integer; external;
[HIDDEN]

function util_getenv(var name : char_array): Getenv_Res; external;




{ This function has no meaning for VMS, so always returns -1 }
function text_file_descr;  begin  text_file_descr := -1;  end;



function vclose; { (var fi : text): boolean }
begin



	close(fi, ERROR := CONTINUE);
	vclose := status(fi) <= 0;

end { vclose } ;


function vbinclose; { (var fi : binaryfile): boolean }
begin



	close(fi, ERROR := CONTINUE);
	vbinclose := status(fi) <= 0;

end { vbinclose } ;



[HIDDEN]

procedure copy_real_name(
	var realname : File_Name;
	var strname : sstring);
var

	i : integer;  
	length : integer;
begin
	length := ord(strname^[0]);

	for i := 1 to max_string_length do 
		realname[i] := ' ';
	for i := 1 to length do 
		realname[i] := strname^[i];

end { copy_real_name } ;


function get_environment_variable; 
{ ( vbl: alfa; 
	var val: big_env_val_str): boolean
}
var
	i: integer;
	envbl : char_array;
	result: Getenv_Res;
	done : boolean;
begin
	i := 1;
	done := false;
	while (i <= alfasize) and (not done) do
		if vbl[i] <> ' ' then
		begin
			envbl[i-1] := vbl[i];
			i := i + 1;
		end
		else 
			done := true;

	envbl[i-1] := chr(0);

	result := util_getenv(envbl);
	{ WARNING: result is a static that belongs to util_getenv.  We must make our
	  own copy of it. }

	if (result = nil) then
	begin
	{ environment variable not defined }
		get_environment_variable := false;
		for i := 1 to bigenvalsize do 
		begin
			val[i] := ' ';
		end;
	end
	else begin
		get_environment_variable := true;

		i := 1;
		while ((result^[i] <> chr(0)) and (i <= bigenvalsize)) do
		begin
			val[i] := result^[i];  i := i + 1;
		end;

		while (i <= bigenvalsize) do
		begin
			val[i] := ' ';  i := i + 1;
		end;
	end;
end { get_environment_variable } ;






[HIDDEN]
function vms_open(var fab : FAB$TYPE; var rab : RAB$TYPE) : integer;
    { Implement additional actions to be performed upon opening the
      files for write or (especially) read/write over DECNET.
      Also -- check the value of umask (setable by C library calls)
      and use that to determine the protection to use when creating
      new files }
  type
    xab_ptr = ^XAB$TYPE;
  var 
    status : integer;
    xab: xab_ptr;
    umask_val: integer;
    found: boolean;


  function vms_prot(unix_code: integer): integer;
    { given a (3 bit) UNIX code for the permissions for one user class,
      return the corresponding (4 bit) VMS code (with the delete value
      matching the write value).  (Only the lower 3 bits of unix_code are
      examined -- rest can be garbage.)  Higher-order bits of returned
      value are always 0. }
    var
      vprot: integer; { return value }
  begin
    if odd(unix_code) then vprot := XAB$M_NOEXE
    else vprot := 0;
    unix_code := unix_code div 2;
    if odd(unix_code) then vprot := vprot + XAB$M_NOWRITE + XAB$M_NODEL;
    unix_code := unix_code div 2;
    if odd(unix_code) then vprot := vprot + XAB$M_NOREAD;
    vms_prot := vprot;
  end { vms_prot } ;


begin { vms_open }
  fab.FAB$V_SQO := FALSE;
  status := $OPEN(fab);
  if (not odd(status)) and (status <> RMS$_FLK) and (status <> RMS$_PRV) then
    begin
      xab := (fab.FAB$L_XAB)::xab_ptr;  found := FALSE;

      { Find or create the XAB that determines the protection }

      while (xab <> NIL) and not found do
        if xab^.XAB$B_COD = XAB$C_PRO then found := TRUE
	else xab := (xab^.XAB$L_NXT)::xab_ptr;

      if not found then
        begin
	  new(xab);
	  xab^ := ZERO;
	  xab^.XAB$B_COD := XAB$C_PRO;
          xab^.XAB$B_BLN := XAB$C_PROLEN;
          xab^.XAB$L_NXT := fab.FAB$L_XAB;
	  fab.FAB$L_XAB := xab::unsigned;
	end;
	
      { Set it according to the current "umask" -- this makes calls
        to umask stick on files created here }

      umask_val := umask(0);  if umask(umask_val) = 0 then ;
      xab^.XAB$V_SYS := vms_prot(umask_val div (8*8));
      xab^.XAB$V_OWN := xab^.XAB$V_SYS;
      xab^.XAB$V_GRP := vms_prot(umask_val div 8);
      xab^.XAB$V_WLD := vms_prot(umask_val);

      { now create the file and clean up }

      status := $CREATE(fab);

      if not found then
        begin
	  fab.FAB$L_XAB := xab^.XAB$L_NXT;
	  dispose(xab);
	end;
    end;
  if odd(status) then $CONNECT(rab);
  vms_open := status;
end { vms_open } ;


function vopen;
  var
    ret : boolean;
    realname : File_Name;
    cname: char_array;
    fd: integer;
begin                                                { vopen }
  if strname <> nil then
    if strname^[0] = chr(0) then strname := nil
    else copy_real_name(realname, strname);
 
  if (mode = read_mode) or (mode = unbuf_read) then
    begin
      if strname = nil then
        open(fi, HISTORY := READONLY, ERROR := CONTINUE)
      else
        open(fi, realname, HISTORY := READONLY, ERROR := CONTINUE);
      ret_code := status(fi);
      if ret_code <= 0 then
        begin
	  reset(fi, ERROR := CONTINUE);
	  ret_code := status(fi);
	end;
      ret := ret_code <= 0;
      if ret then last_operation := NO_OPERATION
             else last_operation := READING;
    end
  else if (mode = write_mode) or (mode = unbuf_write) then
    begin
      if strname = nil then ret_code := -1
      else
	begin
          open(fi, realname, HISTORY := OLD,
	           USER_ACTION := vms_open, ERROR := CONTINUE);
          ret_code := status(fi);
	end;
      if ret_code <= 0 then
        begin
	  rewrite(fi, ERROR := CONTINUE);
	  ret_code := status(fi);
	end;
      ret := ret_code <= 0;
      if ret then last_operation := NO_OPERATION
             else last_operation := WRITING;
    end
  else 
    begin
      ret_code := INVALID_PARAM;  ret := FALSE;
      last_operation := NO_OPERATION;
    end;
  vopen := ret;
end { vopen } ;


function vbinopen;
  var
    ret : boolean;
    realname : File_Name;
    cname: char_array;
begin { vbinopen }
 { textually this is the same as fopen except that we don't allow
   unbuffered I/O.  It has to be a different procedure in order to
   get around type checking.  }

  if strname <> nil then
    if strname^[0] = chr(0) then strname := nil
    else copy_real_name(realname, strname);

  if (mode = read_mode) or (mode = unbuf_read) then
    begin
      if strname = nil then
        open(fi, HISTORY := READONLY, ERROR := CONTINUE)
      else
        open(fi, realname, HISTORY := READONLY, ERROR := CONTINUE);
      ret_code := status(fi);
      if ret_code <= 0 then
        begin
	  reset(fi, ERROR := CONTINUE);
	  ret_code := status(fi);
	end;
      ret := ret_code <= 0;
      if ret then last_operation := NO_OPERATION
             else last_operation := READING;
    end
  else if (mode = write_mode) or (mode = unbuf_write) then
    begin
      if strname = nil then ret_code := -1
      else
        begin
          open(fi, realname, HISTORY := OLD,
	           USER_ACTION := vms_open, ERROR := CONTINUE);
          ret_code := status(fi);
	end;
      if ret_code <= 0 then
        begin
	  rewrite(fi, ERROR := CONTINUE);
	  ret_code := status(fi);
	end;
      ret := ret_code <= 0;
      if ret then last_operation := NO_OPERATION
             else last_operation := WRITING;
    end
  else 
    begin
      ret_code := INVALID_PARAM;  ret := FALSE;
      last_operation := NO_OPERATION;
    end;

  vbinopen := ret;
end { vbinopen } ;


function to_ioresult;
begin
  if sys_code <= 0 then to_ioresult := 0
  else case sys_code of
    PAS$K_ERRDURRES: to_ioresult := 20;
    PAS$K_ERRDURREW: to_ioresult := 21;
    PAS$K_INVARGPAS: to_ioresult := 23;
    PAS$K_INVFILSYN: to_ioresult := 7;
    PAS$K_FILALRCLO: to_ioresult := 13;
    PAS$K_FILNOTOPE: to_ioresult := 13;
    PAS$K_FILALROPE: to_ioresult := 12;
    PAS$K_RESNOTALL: to_ioresult := 20;
    PAS$K_REWNOTALL: to_ioresult := 21;
    PAS$K_FILNAMREQ: to_ioresult := 7;
    PAS$K_ERRDUROPE:
      case last_operation of
        READING: to_ioresult := 20;
        WRITING: to_ioresult := 21;
	otherwise to_ioresult := 19;
      end { case } ;
    otherwise to_ioresult := 19; { unknown }
  end { case } ;
end { to_ioresult } ;



procedure write_ioresult { (var fi : text; iores : integer) };
begin
  case iores of
    { see pp. 117-118 of SVS Pascal manual }
    1 : write(fi,'Parity error or CRC error.');
    2 : write(fi,'Invalid device number.');
    3 : write(fi,'Invalid input-output request.');
    4 : write(fi,'Nebulous Hardware Error.');
    5 : write(fi,'Volume went off-line.');
    6 : write(fi,'File lost in directory.');
    7 : write(fi,'Bad file name.');
    8 : write(fi,'No root on volume.');
    9 : write(fi,'Volume not found.');
    10 : write(fi,'File not found.');
    11 : write(fi,'Duplicate directory entry.');
    12 : write(fi,'File already open.');
    13 : write(fi,'File not open.');
    14 : write(fi,'Bad input information.');
    15 : write(fi,'Ring buffer overflow.');


    17 : write(fi,'Invalid seek.');
    18 : write(fi,'Error of unknown type.');
    19 : write(fi,'Error of unknown type.');
    { these three codes are of my invention -- not SVS }
    20 : write(fi, 'Can''t open file for read.');
    21 : write(fi, 'Can''t open file for write.');
    22 : write(fi, 'Dup to stderr failed.');
    23 : write(fi, 'Invalid parameter.');
    24 : write(fi, 'Name too long and unable to create symbolic link.');

    otherwise write(fi,'Error of unknown type.');

  end;
end;                  { write_ioresult }



end.

