static char rcsid[] = "$Header: dfs_null.c,v 820.1 86/12/04 19:44:53 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Null and echo calls.
 * Useful for testing and performance measurements.
 *
 *	Bakul Shah
 *
 * bvs 840525 -- original version
 * jht 841115,16,26-29 -- complete conversion to use prpc.
 * jht 850213 -- add dfsPktHdr_t containing version/functionality info to pkts.
 * jht 850401 -- fill out the gathering of statistics.
 */

#include "../h/param.h"
#include "../h/dir.h"
#include "../h/user.h"

#include "../vnet/vnet.h"
#include "../conn/conn.h"
#include "../rpc/rpc.h"
#include "../dfs/dfs.h"

#include "../h/inode.h"

/*
 * Test operations
 */
typedef struct dfsc_null {	/* Pkt from client --> server	    */
#ifdef	DFS_PACKETHDR
	dfsPktHdr_t	dfsPktHdr;	/* Info about DFS versions, etc	*/
#endif	DFS_PACKETHDR
	char	dummy;		/* Compiler can't have empty struct */
} dfsc_null_t;

typedef struct dfsr_null {	/* Pkt from client <-- server	    */
#ifdef	DFS_PACKETHDR
	dfsPktHdr_t	dfsPktHdr;	/* Info about DFS versions, etc	*/
#endif	DFS_PACKETHDR
	char	dummy;		/* Compiler can't have empty struct */
} dfsr_null_t;

/*
 * Null-data loop-back
 */
dfsClient_null(conn)
	register connection_t *conn;
{
	register dfsc_null_t * call;
	register dfsr_null_t * result;

	dfs_incClient(null);
	if (!dfs_enabled) {			/* DFS is not enabled */
		u.u_error = DFS_ENOTENABLED;
		return u.u_error;
	}
	call = DFSC_PACKET(null);
	result = DFS_CALL(conn,null,call);
	if (!result)
		return u.u_error;
	DFS_FREE_RESULTS(result);
	return 0;
}

dfsr_null_t *
dfsServer_null(clientConn, clientId, operation, call)
	connection_t	*	clientConn;	/* Host we are serving	*/
	u_long			clientId;	/* Specific client@host	*/
	u_short			operation;	/* Redundant: what to do*/
	register dfsc_null_t *	call;		/* Call pkt -- params	*/
{
	register dfsr_null_t * result;

	dfs_incClient(null);
	result = DFSR_PACKET(null);
	if (!result) {
		DFS_FREE_PARAMS(call);
		return NULL;		/* Say "no result pkt" */
	}
	DFS_FREE_PARAMS(call);
	DFS_RETURN(result);
}

typedef struct dfsc_echo {	/* Pkt from client --> server */
#ifdef	DFS_PACKETHDR
	dfsPktHdr_t	dfsPktHdr;	/* Info about DFS versions, etc	*/
#endif	DFS_PACKETHDR
	char		data[20];	/* Data to be echoed */
} dfsc_echo_t;

typedef struct dfsr_echo {	/* Pkt from client <-- server */
#ifdef	DFS_PACKETHDR
	dfsPktHdr_t	dfsPktHdr;	/* Info about DFS versions, etc	*/
#endif	DFS_PACKETHDR
	char		data[20];	/* Data that is echoed */
} dfsr_echo_t;

/*
 * Echo-data loop-back
 *
 * BUG: Add an ioctl so that we can specify
 * how much is to be echoed and what is to be
 * echoed.
 */
dfsClient_echo(conn)
	register connection_t *conn;
{
	register dfsc_echo_t * call;
	register dfsr_echo_t * result;

	dfs_incClient(echo);
	if (!dfs_enabled) {			/* DFS is not enabled */
		u.u_error = DFS_ENOTENABLED;
		return	u.u_error;
	}
	call = DFSC_PACKET(echo);
	result = DFS_CALL(conn,echo,call);
	if (!result)
		return u.u_error;
	/*
	 * BUG: Check that the result does indeed
	 * BUG: echo what we sent in the call packet.
	 */
	DFS_FREE_RESULTS(result);
	return 0;
}

dfsr_echo_t *
dfsServer_echo(clientConn, clientId, operation, call)
	connection_t	*	clientConn;	/* Host we are serving	*/
	u_long			clientId;	/* Specific client@host	*/
	u_short			operation;	/* Redundant: what to do*/
	register dfsc_echo_t *	call;		/* Call pkt -- params	*/
{
	register dfsr_echo_t * result;

	dfs_incServer(echo);
	result = DFSR_PACKET(echo);
	if (!result) {
		DFS_FREE_PARAMS(call);
		return NULL;		/* Say "no result pkt" */
	}
	bcopy(result->data, call->data, sizeof(call->data));
	DFS_FREE_PARAMS(call);
	DFS_RETURN(result);
}
