static char rcsid[] = "$Header: efs_null.c,v 820.1 86/12/04 19:47:43 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Null Extended File System call.  This
 * can be used to measure the overhead in
 * an extended filesystem call.
 *
 * jam 840223-28-0424
 */

#include "../h/param.h"
#include "../h/dir.h"
#include "../h/user.h"

#include "../vnet/vnet.h"
#include "../conn/conn.h"
#include "../rpc/rpc.h"
#include "../efs/efs.h"

efs_nullCall(conn)
   register connection_t *conn;
{
	register caddr_t results;

	results = (caddr_t)efs_call(conn,EFS_NULL,NULL);
	rpc_freeResults(results);
	return(0);
}

caddr_t
efs_remoteNull(clientConn, clientId, operation, params)
   connection_t *clientConn;
   u_long clientId;
   u_short operation;
   register struct efs_nullCall *params;
{
	rpc_freeParams(params);
	return(0);
}
