static char rcsid[] = "";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	fusion.c	1.0	84/06/01	*/

#ifdef FUSION
#include "../h/errno.h"
#include "../fusion/fusion.h"

char * drv_sel;
char * cookie;
char address[6];
char pktbuffer [] =
    {
     0x11, 0x22, 0x33, 0x44, 0x55, 0x66,
     0x10, 0x20, 0x30, 0x40, 0x50, 0x60,
     0x06, 0x00,
          1,  2,  3,  4,  5,  6,  7,  8,  9,
     10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
     20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
     30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
     40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
     50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
     60, 61, 62, 63, 64, 65, 66, 67, 68, 69
    };

so_init()
{
    printf("*** FUSION Interface: Coming online\n");
    fu_command(&drv_sel, FUCMD_online, 0, &cookie);
    fu_command(&drv_sel, FUCMD_getaddr, &address[0], 0);
    printf("*** FUSION Interface: Address %x-%x-%x-%x-%x-%x\n",
		address[0], address[1], address[2], 
		address[3], address[4], address[5]);
    fu_output(drv_sel, &pktbuffer[0], sizeof(pktbuffer));
}

so_open() { so_init(); }
so_read() { return(EIO); }
so_write() { return(EIO); }
so_close() { return(EIO); }
so_ioctl() { return(EIO); }

nt_init() { printf("*** FUSION Interface: network terminal init\n"); }
nt_open() { so_init(); }
nt_read() { return(EIO); }
nt_write() { return(EIO); }
nt_close() { return(EIO); }
nt_ioctl() { return(EIO); }


fu_input(fu_sel, ptr, length)
    int fu_sel;
    char * ptr;
    int length;
{
    printf("*** FUSION Interface: input on %d, %d bytes\n", fu_sel, length);

    while(length-- > 0)
	printf("%x ", *ptr++);
    printf("\n");
}
#endif FUSION
