/* rcsid[]="$Header: a.out.h,v 820.1 86/12/04 20:00:42 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */
/****************************************************************************

                          Copyright  1982

               VALID  LOGIC  SYSTEMS  INCORPORATED

This listing contains confidential proprietary information which is not to
be disclosed to unauthorized persons without written consent of an officer
of Valid Logic Systems Incorporated.

The copyright notice appearing above is included to provide statutory
protection in the event of unauthorized or unintentional public disclosure.

*****************************************************************************/

/*
 *	Layout of a.out file :
 *
 *	header of 8 longs	magic number 405, 407, 410, 411
 *				text size		)
 *				data size		) in bytes
 *				bss size		)
 *				symbol table size	)
 *				text relocation size	)
 *				data relocation size	)
 *				entry point
 *
 *
 *	header:			0
 *	text:			32
 *	data:			32+textsize
 *	symbol table:		32+textsize+datasize
 *	text relocation:	32+textsize+datasize+symsize
 *	data relocation:	32+textsize+datasize+symsize+rtextsize
 *
 */

/* various parameters */
#define SYMLENGTH	50		/* maximum length of a symbol */

/* types of files */
#define OMAGIC	0405			/* overlay */
#define	FMAGIC	0407			/* normal */
#define	NMAGIC	0410			/* read-only text */
#define	IMAGIC	0411			/* seperated I&D spaces */
#define ZMAGIC	0413

/* symbol types */
#define	EXTERN	040
#define	UNDEF	00
#define	ABS	01
#define	TEXT	02
#define	DATA	03
#define	BSS	04
#define	COMM	05	/* internal use only */
#define REG	06

/* relocation regions */
#define	RTEXT	00
#define	RDATA	01
#define	RBSS	02
#define	REXT	03

/* relocation sizes */
#define RBYTE	00
#define RWORD	01
#define RLONG	02

/* macros which define various positions in file based on a bhdr, filhdr */
#define TEXTPOS		sizeof(filhdr)
#define DATAPOS 	TEXTPOS + filhdr.tsize
#define SYMPOS		DATAPOS + filhdr.dsize
#define RTEXTPOS	SYMPOS + filhdr.ssize
#define RDATAPOS	RTEXTPOS + filhdr.rtsize
#define ENDPOS		RDATAPOS + filhdr.rdsize

/* header of a.out files */
struct exec {
	unsigned long	fmagic;
#define a_magic		fmagic
	unsigned long	tsize;
#define a_text		tsize
	unsigned long	dsize;
#define a_data		dsize
	unsigned long	bsize;
#define a_bss		bsize				/*  JDT  */
#define a_bsize		bsize
	unsigned long	ssize;
#define a_syms		ssize
	unsigned long	rtsize;
#define a_trsize	rtsize
	unsigned long	rdsize;
#define a_drsize	rdsize
	unsigned long	entry;
#define a_entry		entry
};

/* symbol management  -- symbols in a.out file look like this: */
struct sym {
	char	stype;
	long	svalue;
	/* then a string containing the symbol name */
};

/* relocation commands */
struct reloc {
	unsigned rsegment:2;	/* RTEXT, RDATA, RBSS, or REXTERN */
	unsigned rsize:2;		/* RBYTE, RWORD, or RLONG */
	unsigned rdisp:1;		/* 1 => a displacement */
	short rsymbol;		/* id of the symbol of external relocations */
	long rpos;		/* position of relocation in segment */
};

/* symbol table entry returned by the nlist routine */
struct	nlist {
	char    	n_name[8];	/* symbol name */
	int     	n_type;    	/* type flag */
	unsigned	n_value;	/* value */
};

/* values for n_type flag */
#define	N_UNDF	0	/* undefined */
#define	N_ABS	01	/* absolute */
#define	N_TEXT	02	/* text symbol */
#define	N_DATA	03	/* data symbol */
#define	N_BSS	04	/* bss symbol */
#define	N_TYPE	037
#define	N_REG	024	/* register name */
#define	N_FN	037	/* file name symbol */
#define	N_EXT	040	/* external bit, or'ed in */
#define	FORMAT	"%06o"	/* to print a value */

/*
 * Macros which take exec structures as arguments and tell whether
 * the file has a reasonable magic number or offsets to text|symbols|strings.
 */
#define	N_BADMAG(x) \
    (((x).fmagic)!=OMAGIC && ((x).fmagic)!=FMAGIC && ((x).fmagic)!=NMAGIC && ((x).fmagic)!=IMAGIC && ((x).fmagic)!=ZMAGIC)

#define	N_TXTOFF(x) \
	((x).fmagic==ZMAGIC ? getpagesize() : sizeof (struct exec))

#define N_DATAOFF(x)	(N_TXTOFF(x) + (x).tsize)

#define N_SYMOFF(x) \
	(N_TXTOFF(x) + (x).tsize+(x).dsize) /* notably different from bsd */

#define N_STROFF(x) \
	(N_SYMOFF(x) + (x).a_syms)
		/* definition added 01/29/84 -- jaa */

/* this stuff added so that 8086 assembler can use them.. Note that
the current loader doesn't understand them but the bsd4.1 loader does */
/*
 * Format of a relocation datum.
 */
struct relocation_info {
	int	r_address;	/* address which is relocated */
unsigned int	r_symbolnum:24,	/* local symbol ordinal */
		r_pcrel:1, 	/* was relocated pc relative already */
		r_length:2,	/* 0=byte, 1=word, 2=long */
		r_extern:1,	/* does not include value of sym referenced */
		:4;		/* nothing, yet */
};
