/* rcsid[] = "$Header: mouse.h,v 800.0 85/08/06 14:17:37 root Exp $" */
/* sccsid[] = "%W% %Y% %Q% %G%" */

#ifndef _MOUSE_
#define _MOUSE_
/*
 * mouse line discipline definitions
 * see co(4) for a description of commands
 * 840906 sbs
 *
 * This line explicitly does not allow for
 *	- something other than a mouse to be attached to acia#1
 *	- a device file to read the mouse directly
 * Rather, it is always used in conjunction with the console: if enabled,
 * it merges mouse button presses with keyboard input; if disabled, it
 * just throws away mouse button presses.  The idea is to create a "virtual
 * device" -- the user -- which presents all input to programs in the order
 * that the user created it, with a minimum of fuss.
 */

/*
 * Options to TIOCMERGE
 */
#define TRACK_CURSOR		1
#define INVIS_CURSOR		(1<<1)
#define DISABLE_MOUSE		(1<<2)
#define ALLOPTIONS (TRACK_CURSOR|INVIS_CURSOR|DISABLE_MOUSE)
#define PRINT_THROUGH		(1<<31)

/*
 * The argument to TIOC[SG]CURSOR
 */
struct	graphics_cursor {
	short	cur_x,
		cur_y;
};

/*
 * The first character in any button sequence is the sync pattern, which
 * has 10000 in the high five bits, and an encoding of the buttons in the
 * low-order 3 bits.
 * This character is followed by dx (msb), dy (msb), dx (lsb) and dy (lsb).
 */
#define BUTTON_BITS	0x7	/* bits in the button */
#define MSYNCMASK	0xF8
#define MSYNC		0x80

/*
 * The extents of the screen (logical coordinates; 0,0 at top left)
 */
#define XMIN		0
#define XMAX		719
/*
 * hack: keep the cursor off the bottom text line of the screen
 */
#define YMIN		17
#define YMAX		559
#endif _MOUSE_
