static char rcsid[] = "$Header: af.c,v 820.1 86/12/04 19:50:38 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	af.c	6.1	83/07/29	*/

#include "../h/param.h"
#include "../h/mbuf.h"
#include "../h/protosw.h"
#include "../h/socket.h"
#include "../h/socketvar.h"
#include "../net/af.h"

/*
 * Address family support routines
 */
int	null_hash(), null_netmatch();
#define	AFNULL \
	{ null_hash,	null_netmatch }

#ifdef INET
extern int inet_hash(), inet_netmatch();
#define	AFINET \
	{ inet_hash,	inet_netmatch }
#else
#define	AFINET	AFNULL
#endif

#ifdef PUP
extern int pup_hash(), pup_netmatch();
#define	AFPUP \
	{ pup_hash,	pup_netmatch }
#else
#define	AFPUP	AFNULL
#endif

#ifdef DECnet
extern int decnet_hash(), decnet_netmatch();
#define AFDECnet \
	{ decnet_hash,	decnet_netmatch }
#else
#define AFDECnet AFNULL
#endif

struct afswitch afswitch[AF_MAX] = {
	AFNULL,		/* AF_UNSPEC, Unspecified */
	AFNULL,		/* AF_UNIX, local to UNIX */
	AFINET,		/* AF_INET, DARPA internet protocols */
	AFINET,		/* AF_IMP, direct DARPA IMP addressing */
	AFPUP,		/* AF_PUP, XEROX PARC Universal Packet */
	AFNULL,		/* AF_CHAOS, MIT CHAOSnet  */
	AFNULL,		/* AF_NS, XEROX Network Systems protocols */
	AFNULL,		/* AF_NBS, National Bureau of Standards */
	AFNULL,		/* AF_ECMA, European Computer Manufacturers */
	AFNULL,		/* AF_DATAKIT, DataKit protocols */
	AFNULL,		/* AF_CCITT, CCITT protocols (X.25, X.29, etc) */
	AFNULL,		/* AF_SNA, IBM System Network Architecture */
	AFNULL,		/* AF_RPC, Valid's Remote Procedure Calls */
	AFNULL,		/* AF_CONN, Valid's Connection Manager */
	AFNULL,		/* AF_BCAST, Valid's Generic Broadcast */
	AFNULL,		/* AF_BULK, Valid's Bulk Data Protocol */
	AFDECnet	/* AF_DECnet, Valid's DECnet Phase-IV Endnode */
};

/*ARGSUSED*/
null_hash(addr, hp)
	struct sockaddr *addr;
	struct afhash *hp;
{

	hp->afh_nethash = hp->afh_hosthash = 0;
}

/*ARGSUSED*/
null_netmatch(a1, a2)
	struct sockaddr *a1, *a2;
{

	return (0);
}
