static char rcsid[] = "$Header: genassym.c,v 820.1 86/12/04 19:53:24 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

#ifndef s32
#define	VAX780	1
#define	VAX750	1
#else !s32

#define	STARTUP_DOT_C	/* Enable initialization of mmu_sizing */
#endif !s32

#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/buf.h"
#include "../h/vmmeter.h"
#include "../h/vmparam.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/cmap.h"
#include "../h/map.h"
#include "../h/proc.h"
#ifdef s32
#include "../s32/rpb.h"
#ifdef	M68881
#include "../s32/reg.h"		/* FPU definitions */
#endif	M68881
#else s32
#include "../vaxuba/ubareg.h"
#include "../vaxuba/ubavar.h"
#include "../vax/rpb.h"
#endif s32
#include "../h/mbuf.h"
#include "../h/msgbuf.h"

main()
{
	register struct proc *p = (struct proc *)0;
#ifdef s32
	register struct pcb *pcb = (struct pcb *)0;
#else s32
	register struct uba_regs *uba = (struct uba_regs *)0;
	register struct uba_hd *uh = (struct uba_hd *)0;
#endif s32
	register struct vmmeter *vm = (struct vmmeter *)0;
	register struct user *up = (struct user *)0;
	struct rpb *rp = (struct rpb *)0;

	printf("#ifdef LOCORE\n");
	printf("#define\tP_LINK %d\n", &p->p_link);
	printf("#define\tP_RLINK %d\n", &p->p_rlink);
	printf("#define\tP_ADDR %d\n", &p->p_addr);
	printf("#define\tP_PRI %d\n", &p->p_pri);
	printf("#define\tP_STAT %d\n", &p->p_stat);
	printf("#define\tP_WCHAN %d\n", &p->p_wchan);
	printf("#define\tP_PID %d\n", &p->p_pid);
	printf("#define\tSSLEEP %d\n", SSLEEP);
	printf("#define\tSRUN %d\n", SRUN);
#ifdef s32
	printf("#define\tPCB_P0BR %d\n", &pcb->pcb_p0br);
	printf("#define\tPCB_P0LR %d\n", &pcb->pcb_p0lr);
	printf("#define\tPCB_P1BR %d\n", &pcb->pcb_p1br);
	printf("#define\tPCB_P1LR %d\n", &pcb->pcb_p1lr);
	printf("#define\tPCB_CMAP2 %d\n", &pcb->pcb_cmap2);
	printf("#define\tPCB_SSWAP %d\n", &pcb->pcb_sswap);
	printf("#define\tPCB_PC 0x%x\n", &pcb->pcb_regs.val[12]);
	printf("#define\tPCB_SR 0x%x\n", &pcb->pcb_sr);
	printf("#define\tU_FPSAV 0x%x\n", up->u_fpsav);
	printf("#define\tU_FPPC 0x%x\n", &up->u_fppc);
#ifdef	M68881
	printf("#define\tU_FPDR   0x%x\n", &up->u_FPDR[0]); /* Data Regs      */
	printf("#define\tU_FPCR   0x%x\n", &up->u_FPCR);    /* Cntl Regs      */
	printf("#define\tU_FPSR   0x%x\n", &up->u_FPSR);    /* Stat Regs      */
	printf("#define\tU_FPIAR  0x%x\n", &up->u_FPIAR);   /* Inst Addr Reg  */
	printf("#define\tU_FPSSF  0x%x\n", &up->u_FPSSF[0]);/* Sys State Frame*/
	printf("#define\tU_FPSSFP 0x%x\n", &up->u_FPSSFp);  /* Into u_FPSSF   */
	printf("#define\tU_FPSSFL 0x%x\n", sizeof(up->u_FPSSF));/*Size u_FPSSF*/
#endif	M68881
	printf("#define\tU_PROCP 0x%x\n", &up->u_procp);
#else s32
	printf("#define\tUBA_BRRVR %d\n", uba->uba_brrvr);
	printf("#define\tUH_UBA %d\n", &uh->uh_uba);
	printf("#define\tUH_VEC %d\n", &uh->uh_vec);
	printf("#define\tUH_SIZE %d\n", sizeof (struct uba_hd));
#endif s32
	printf("#define\tRP_FLAG %d\n", &rp->rp_flag);
	printf("#define\tV_SWTCH %d\n", &vm->v_swtch);
	printf("#define\tV_TRAP %d\n", &vm->v_trap);
	printf("#define\tV_SYSCALL %d\n", &vm->v_syscall);
	printf("#define\tV_INTR %d\n", &vm->v_intr);
	printf("#define\tV_PDMA %d\n", &vm->v_pdma);
	printf("#define\tUPAGES %d\n", UPAGES);
	printf("#define\tCLSIZE %d\n", CLSIZE);
	printf("#define\tSYSPTSIZE %d\n", SYSPTSIZE);
	printf("#define\tUSRPTSIZE %d\n", USRPTSIZE);
	printf("#define\tMSGBUFPTECNT %d\n", btoc(sizeof (struct msgbuf)));
	printf("#define\tNMBCLUSTERS %d\n", NMBCLUSTERS);
#ifdef s32
	printf("#define\tNBBY %d\n", NBBY);		/* # bits per byte */
	printf("#define\tNBPG %d\n", NBPG);
	printf("#define\tNPTEPG %d\n", NPTEPG);
	printf("#define\tUPAGENUM %d\n", UPAGENUM);
#ifdef BIGUPAGE
#ifdef	M68020_REV_B
	printf("#define\tU_SMAPSNUM %d\n", U_SMAPSNUM);
#endif	M68020_REV_B
#endif BIGUPAGE
	printf("#define\tUSRTEXT %d\n", USRTEXT);
	printf("#define\tKVBASE %d\n", KVBASE);
	printf("#define\tKVSIZE %d\n", KVSIZE);
	printf("#define\tTMPSTACK %d\n", TMPSTACK);
	printf("#define\tSYM_PA %d\n", SYM_PA);
#endif s32
	printf("#else\n");
#ifdef s32
	printf("asm(\"U_ARG = %d\");\n", up->u_arg);
	printf("asm(\"U_QSAVE = %d\");\n", &up->u_qsave);
#else s32
	printf("asm(\".set\tU_ARG,%d\");\n", up->u_arg);
	printf("asm(\".set\tU_QSAVE,%d\");\n", up->u_qsave);
#endif s32
	printf("#endif\n");
	exit(0);
}
