
/*
 *	Exos Synchronization Buffer Structure Definitions
 */

/*
 * This structure defines the reply data from a message sent to the
 * board.  This is needed because of a problem with the message queues
 * on the board - they are not searched.  Once a message is sent to the
 * board, it EXPECTS the next sent message to be immediately following
 * (in the circular queue sense) the previous sent message.  Since we
 * need to save the write message until the sender can use it to find
 * the reply message, a deadlock situation arises.  To solve this problem
 * the following synchronization formula is used.  Whenever we allocate a
 * message to send to the board, we also allocate a sync. buffer.  The
 * send() routine will sleep on the address of this buffer (which will be
 * unique across any current sleepers).  Once the reply comes in, the
 * interrupt routine will put the result of the sent message into the sync.
 * buffer.	(These buffers were called kludge buffers by Excelan.)
 */

#define	NUM_EXOS_SYNC	50

typedef struct _exos_sync_
	{
	ushort xsy_state;		/* state of buffer (0 == free) */
	ushort xsy_reply;		/* reply from exos (u.u_error) */
	ushort xsy_count;		/* size of receive */
	short xsy_pid;			/* process id of the process in xsy_proc */
	struct proc *xsy_proc;	/* process using this buf */
	struct buf *xsy_baddr;	/* pointer to data buf */
	dev_t xsy_dev;			/* device using this buf */
	tiny xsy_dev_type;	/* mp->dev_type */
	tiny xsy_fd;			/* mp->fd */
	short xsy_lcn;			/* mp->lcn */
	short xsy_ret_status;	/* mp->mdata.ret_status */
	ExosBd xsy_bd;			/* mp->bd */
	} ExosSync;


/* Values for kludge.kl_state */

#define	XSY_FREE		0x00		/* pseudo flag */
#define	XSY_BUSY		0x01		/* buffer in use */
#define	XSY_WAITING	0x02		/* somebody wants an interrupt */

#ifdef	KERNEL
extern ExosSync exos_sync[NUM_EXOS_SYNC];
#endif
