/* sccsid[] = "%W% %Y% %Q% %G%" */
/* rcsid[] = "$Header: tci.h,v 800.0 85/09/30 17:04:31 root Exp $" */
/*
 *	Insert TCI standard header here
 */

/*
 *	Version 1.3
 */

#ifndef	TCI_TYPES			/* only do this if we haven't before */
#define	TCI_TYPES	1		/* so we won't redefine these */


typedef	char		tiny;		/* 1 byte signed numbers */
typedef	unsigned char	utiny;		/* 1 byte unsigned numbers */
typedef char		tbits;		/* 1 byte value for bit manipulation */
typedef	char		tbool;		/* 1 byte boolean value; 0 or 1 test */
#ifndef	s32
typedef unsigned short	ushort;		/* 16+ bit unsigned integer */
#endif
typedef short		bits;		/* 16+ bit value for bit manipulation */
typedef	short		metachar;	/* 16+ bit character (char or EOF */
typedef short		bool;		/* Boolean value 0 or 1 test */
typedef	long		lbits;		/* 32+ bit value for bit manipulation */
typedef	int		sizetype;	/* for the result of sizeof() */

/*
 *	Define limits on sizes
 */
#define	CHAR_BIT	8		/* number of bits in a char */
#define	TINY_BIT	8		/* number of bits in a tiny */
#define	TINY_MAX	127		/* Maximum value of a tiny */
#define	TINY_MIN	-128		/* Minimum value of a tiny */
#define	SHORT_BIT	16		/* number of bits in a short */
#define	SHORT_MAX	32767		/* Maximum value of a short */
#define	SHORT_MIN	-32768		/* Minimum value of a short */
#define	LONG_BIT	32		/* number of bits in a long */
#define	LONG_MAX	2147483647	/* Maximum value of a long */
#define	LONG_MIN	-2147483648	/* Minimum value of a long */


/*
 *	Conversion Macros
 */
#define	TINY(n)		(char)(n)
#define	UTINY(n)	(unsigned char)((n) & 0xFF)


#define	NOTHING				/* for null loops */

/*
 *	Long Unsigned Right Shift
 */
#define	LURSHIFT(n, b)	(((long)(n) >> (b)) & (0x7FFFFFFF >> (b-1)))

#endif	TCI_TYPES



#ifndef	NULL				/* we want NULL defined */
#define	NULL		(char *)0
#endif	NULL


#ifndef	TRUE				/* we want TRUE, FALSE, YES and NO */
#define	FALSE		0
#define	TRUE		1
#define	NO		0
#define	YES		1
#endif	TRUE

#ifndef	FAIL
#define	FAIL		1
#define	SUCCESS	0
#endif	FAIL


#ifndef	WORD_LEN			/* what is the word length */

#ifdef	MC68000
#define	WORD_LEN	32
#else
#ifdef	VAX
#define	WORD_LEN	32
#else
#ifdef	I86
#define	WORD_LEN	16
#else
#define	WORD_LEN	16
#endif	I86
#endif	VAX
#endif	MC68000

#endif	WORD_LEN
