static char rcsid[] = "$Header: kbtab.c,v 800.0 85/08/06 14:16:46 root Exp $";
static char sccsid[] = "%W% %Y% %Q% %G%";

#include "../white/acia.h"
#include "../white/kb.h"

int KEYUP = 0;
int KEYDWN = 1;
char kb_conctl = X_RCLK|X_LEN8|X_STOP1|X_B600;
char kb_ctlcode = X_RCLK|X_LEN8|X_STOP1|X_B600;	/* sbs */

unsigned char kb_stab[]= {     /* concept keyboard shift table */
/*      0/8     1/9     2/a     3/b     4/c     5/d     6/e     7/f   */

/* 0 */ FRT,	'3',	'9',	FHM,	'6',	',',	'-',	FENT,
 	FLT,	'1',	'7',	FDN,	'4',	'8',	'5',	'2',
/* 1 */ '+',	PAUSE,	'{',	'|',	FRET,	'}',	FBS,	FX1,
 	')',	'?',	'P',	'_',	':',	'~',	'"',	SHL,
/* 2 */ F1,	F2,	F3,   	F4,	F5,	FX2,	FX3,	FX4,
 	'$',	'%',	'R',	'T',	'F',	'G',	'V',	'B',
/* 3 */ '@',	'#',	'W',	'E',	'S',	'D',	'X',	'C',
 	FESC,	'!',	FBTB,	'Q',	LCK1,	'A',	SHR,	'Z',
/* 4 */ '^',	'&',	'Y',	'U',	'H',	'J',	'N',	'M',
 	CTL,	FAST,	CMD,	' ',	ALT,	'0',	FZZ,	'.',
/* 5 */ '*',	'(',	'I',	'O',	'K',	'L',	'<',	'>',
 	F6,	F7,	F8,	F9,     F10,	FUP,	ALCK1,	INV,
/* 6 */ INV,	INV,	INV,	INV,	INV,	INV,	INV,	FDEL,
 	HELP,	INV,	INV,	INV,	INV,	INV,	INV,	INV,
/* 7 */ INV,	INV,	INV,	INV,	INV,	INV,	INV,	INV,
 	INV,	INV,	INV,	INV,	LCK2,	INV,	ALCK2,	INV
};

unsigned char kb_ctab[] = {      /* concept keyboard regular table */
/*      0/8     1/9     2/a     3/b     4/c     5/d     6/e     7/f   */

/* 0 */	FRT,	'3',	'9',	FHM,	'6',	',',    '-',    FENT,
 	FLT,    '1',	'7',	FDN,	'4',	'8',	'5',	'2',
/* 1 */	'=',    PAUSE,	'[',	'\\',	FRET,	']',	FBS,	FX1,
 	'0',    '/',	'p',	'-',	';',	'`',	'\'',	SHL,
/* 2 */	F1,     F2,	F3,	F4,	F5,	FX2,	FX3,	FX4,
 	'4',    '5',	'r',	't',	'f',	'g',	'v',	'b',
/* 3 */	'2',    '3',	'w',	'e',	's',	'd',	'x',	'c',
 	FESC,   '1',	FTAB,	'q',	LCK1,	'a',	SHR,	'z',
/* 4 */	'6',    '7',	'y',	'u',	'h',	'j',	'n',	'm',
 	CTL,    FAST,	CMD,   ' ',	ALT,	'0',	FZZ,	'.',
/* 5 */	'8',    '9',	'i',	'o',	'k',	'l',	',',	'.',
 	F6,     F7,	F8,	F9,	F10,	FUP,	ALCK1,   INV,
/* 6 */ INV,	INV,	INV,	INV,	INV,	INV,	INV,	FDEL,
 	HELP,	INV,	INV,	INV,	INV,	INV,	INV,	INV,
/* 7 */ INV,	INV,	INV,	INV,	INV,	INV,	INV,	INV,
 	INV,	INV,	INV,	INV,	LCK2,	INV,	ALCK2,	INV
};
/*
 * Changes:
 *	841031 (sbs) 67 is now FDEL (was INV), 5F is now INV (was FBRK)
 *	841102 (sbs) 5E and 7E are now ALT LOCK (5E was FXX; 7E was INV)
 *		     4F is now '.' (was '"')
 *	841112 (sbs) 11 is PAUSE (was FX0)
 *		     68 is HELP (was INV)
 *	841203 (sbs) 3C is LCK1 (was LCK; actually LCK1==LCK)
 *		     7C is LCK2 (was INV)
 *		     5E is ALCK1 (was ALCK; actually ALCK1==ALCK)
 *		     7E is ALCK2 (was ALCK)
 */


char	kb_nul[] = "";		/* null function key sequence */
char *kb_ftab[] = {	/* function key table */
  	kb_nul,		/* F1 */
  	kb_nul,		/* F2 */
  	kb_nul,		/* F3 */
  	kb_nul,		/* F4 */
  	kb_nul,		/* F5 */
  	kb_nul,		/* F6 */
  	kb_nul,		/* F7 */
  	kb_nul,		/* F8 */
  	kb_nul,		/* F9 */
  	kb_nul,		/* F10 */
  	kb_nul,		/* F11 */
  	kb_nul,		/* F12 */
	"\033I",	/* FBTB */
  	kb_nul,		/* FUP was 023 (ctrl-S) */
  	kb_nul,		/* FDN was 022 (ctrl-R) */
  	kb_nul,		/* FLT was 021 (ctrl-Q) */
	kb_nul,		/* FRT was 024 (ctrl-T) */
	"\033H",        /* FHM */
  	"\177",		/* FBRK */
	kb_nul,		/* FZZ was "00" */
	"\n",		/* FENT: line feed */
	kb_nul,		/* FEOL */
	kb_nul,		/* FEOP */
  	kb_nul,		/* FX0  */
  	kb_nul,		/* FX1 */
  	kb_nul,		/* FX2 */
  	kb_nul,		/* FX3 */
	kb_nul,		/* FX4 */
	kb_nul,		/* FXX */
	kb_nul		/* INV */
};
/*
 * Changes
 *	841031 (sbs) Added FENT, as line feed
 *		nulled out most entries because they're useless anyway
 */

short kb_qtab[] = {	/* table of key qualifiers */
	KBLSHFT,		/* left shift */
	KBRSHFT,		/* right shift */
	KBCTL,			/* control */
	KBALT,			/* alt */
	KBFAST,			/* unused */
	KBCMD,			/* unused */
	KBLCK,			/* caps lock */
	KBALCK,			/* alt lock */
};
/*
 * Changes
 *	841101 (sbs) Added this table
 */


#define C(x) ((x)&0x1f)
char kb_xtab[] = {	/* take characters into their ctrl-char equivalents */
/*      0/8     1/9     2/a     3/b     4/c     5/d     6/e     7/f   */

/* 0 */ 0x0,	0x1,	0x2,	0x3,	0x4,	0x5,	0x6,	0x7,
 	0x8,	0x9,	0xa,	0xb,	0xc,	0xd,	0xe,	0xf,
/* 1 */ 0x10,	0x11,	0x12,	0x13,	0x14,	0x15,	0x16,	0x17,
 	0x18,	0x19,	0x1a,	0x1b,	0x1c,	0x1d,	0x1e,	0x1f,
/* 2 */	C(' '),	C('!'),	C('"'),	C('#'),	C('$'),	C('%'),	C('&'),	C('\''),
	C('('),	C(')'),	C('*'),	C('+'),	C(','),	C('-'),	C('.'),	C('/'),
/* 3 */ '0',	'1',	'2',	'3',	'4',	'5',	'6',	'7',
	'8',	'9',	C(':'),	C(';'),	C('<'),	C('='),	C('>'),	C('?'),
/* 4 */ C('@'),	C('A'),	C('B'),	C('C'),	C('D'),	C('E'),	C('F'),	C('G'),
	C('H'),	C('I'),	C('J'),	C('K'), C('L'),	C('M'), C('N'),	C('O'),
/* 5 */ C('P'), C('Q'), C('R'),	C('S'), C('T'),	C('U'), C('V'), C('W'),
	C('X'),	C('Y'),	C('Z'),	C('['),	C('\\'),C(']'),	C('^'),	C('_'),
/* 4 */ C('@'),	C('a'),	C('b'),	C('c'),	C('d'),	C('e'),	C('f'),	C('g'),
	C('h'),	C('i'),	C('j'),	C('k'), C('l'),	C('m'), C('n'),	C('o'),
/* 5 */ C('p'), C('q'), C('r'),	C('s'), C('t'),	C('u'), C('v'), C('w'),
	C('x'),	C('y'),	C('z'),	C('{'),	C('|'), C('}'),	C('~'),	0x7F
};
#undef C
/*
 * Changes
 *	841112 (sbs) added this table
 */
