INSERT[MPCodes];
:TITLE[GlobalDefs];	*Ed Fiala 10 September 1982

*ASSEMBLY SWITCHES

Set[CSLOverlay,1];	*1 assembles DisplayInit to read the CSLKeyboard
			*overlay if the attached keyboard is a CSL keyboard
			*and also enables the code for adjusting the TOD
			*clock to 40, 44.5, or 50 mhz crystals.
			*DisplayInitPage has an extra 57b mi in this case.
Set[FinalOverlay,1];	*1 assembles Initialize.Mc to read in a final
			*overlay before transferring control to StartNova.
  Set[NoOverlays,IFE[Or[CSLOverlay,FinalOverlay],0,1,0]];
	*NOTE: if NoOverlays is 0, map and storage init code in Initialize
	*on pg. 16b is replaced by code which delays before and after the
	*display of some MP codes; this results in 51b fewer mi on page 16b.
Set[WithMidas,0];	*1 assembles extra code for debugging with Midas:
			* 33b mi in Fault on MidasPage
			*	(+2 mi if MidasPage # 17b)
			*  7b mi in Fault on FaultPage
			*  3b mi in Timer on TimerPage
			*120b IMReserve on page 17 for Midas Kernel
			* 14b IMReserve on page 16 for Kernel timer task in
			*     AMesa, but no IMReserve in MicOverlay.
			*NOTE: Include LoadRAM.Dib and KernelOccupied.Dib and
			*omit OverlayOccupied.Dib in the MicroD loadup if no
			*Initial.
Set[SmallTalkMode,0];	*1 for SmallTalk instead of Mesa.
Set[LispMode,0];	*1 for Lisp instead of Mesa.
Set[ButteMode,0];	*1 for Butte instead of Mesa.
Set[AltoXMMode,Or[SmallTalkMode,ButteMode,1]];
			*Assembles Alto XMLDA and XMSTA opcodes and enables
			*the emulator bank register for BitBlt and the Display
			*task's bank register; adds 10b mi on xoPage, 11b mi
			*on bbXMPage, 3b mi on DisplayPage2, and 1b mi on
			*DisplayPage3.

MC[cEtherBoot,10];	*Etherboot control constant--10 for Net Exec,
			*100 for Mesa Net Exec
MC[MaxStack,10];	*Largest referenceable stack address (when StkP
			*points at MaxStack+1 to 17, trap occurs).
MC[MinPageCount,1000];	*Minimum number of pages at which to allow Initialize
			*to continue with system initialization (if less than
			*this, shows error code on MP).

%The following integers control assembly of speed improvements in the Alto
emulator that consume microstore for additional speed.  Values should be
1 to assemble faster version, 0 to use slower but smaller version.
%
Set[neFastBltBlks,1];	*1 expends 53b mi to assemble faster versions of
			*BLT and BLKS for a 4% to 9% speed improvement.
Set[neFastAGroup,1];	*1 expends 41b mi to assemble faster A-group
			*for a 5% to 10% speed improvement.
Set[neBCPLI360,1];	*1 assembles BCPL runtime for JSR @360 to 370.
			*Expends 65b mi on nePage, 26b mi on brGarbPage1,
			*6b mi on brGarbPage2, and 2b mi on brGarbPage0 for
			*a 25% speed improvement.
			*Most storage is on nePage and cannot easily be moved.
Set[neBCPLI340,And[neBCPLI360,1]];	*1 assembles BCPL runtime for
			*JSR @340 to 357.  Expends 66b mi on br340Page and
			*3b mi on nePage for a 3% to 8% speed improvement.
Set[neBCPL300,And[neBCPLI360,0]];	*1 assembles BCPL runtime for
			*JSR 300 to 332.  Expends 47b mi for a 0% to 2%
			*speed improvement.

Set[neAltoTraps,1];	*1 assembles 30b mi on nePage that cause a breakpoint
			*for illegal opcodes in the range 62000 - 67777.
Set[xoTraps,1];		*1 assembles 6b mi on xoPage for illegal opcodes
			*in the range 61000b to 61037b.

Set[WithCDC,1];		*Enable color display controller microcode

IMReserve[17,377,1];	*Reserve location 7777b, which LoadRAM can't handle.

%MICROCODE ORGANIZATION

Two debugging systems can be built from the sources: one to drive the LF
keyboard and one for the CSL keyboard (with either CSL or LF monitor); these
systems can be run directly from Midas because initialization does full map
and storage init and there are no microcode overlays.  These systems are
built with the NewAMesa.Cm and LFAMesa.Cm command files after assembling
the sources with WithMidas=1, CSLOverlay=0, and FinalOverlay=0.  The debugging
systems have their own version of LoadRAM and do not include Mesa floating
point, audio, Jasmine, or halftone microcode.

For system releases, an LF keyboard system is assembled in which extra code
for the LF keyboard and other overflow are on page 15.  Initial initializes
the map and storage, loads AMesa and its overlays in storage starting at
VM 1400, and exits via LoadRAM, which loads AMesa into the microstore and
transfers control into Initialize.Mc at EGO or KGO.  If the terminal has a
CSL keyboard (with either an LF or CSL monitor), then DisplayInit calls
LoadRAM to roll in the first overlay; otherwise, it skips this overlay.
NOTE: the LF keyboard driver is 74b mi larger than the CSL keyboard driver.
A final overlay overwrites the initialization.  The release system makes no
provision for debugging with Midas.

Pages 16 and 17 contain only initialization and Midas communication ucode,
and page 15 is sparsely populated with code that wouldn't quite fit elsewhere.
For the release system, just before jumping to StartNova, a final overlay
overwrites pp 16, 17, and unused locations in page 15; the overlay includes
MesaFP, Audio, Jasmine, and JasmineHalftone modules.  Jasmine and halftone
microcode is a natural overlay because:
(a) it almost fills one page, which is an easy unit of management;
(b) nothing in the resident calls it (it is invoked by Mesa JRAM); and
(c) it uses the Printer interface, so it could not be debugged from Midas in
any case.
MesaFP is also a convenient overlay because it is optional--FP opcodes trap
to software when no microcode is present.

If the distribution of resident and overlay code on page 15 changes, both
MicOverlayOccupied.Mc and OverlayOccupied.Mc must be edited.  Note that
Audio and Jasmine overwrite unused locations in TimerTable; these were
initialized in AMesa to crash.  MesaFP overwrites two Misc dispatch
locations in MesaX.

Any combination of WithMidas, CSLOverlay, and FinalOverlay values works, IFF
enough storage exists on pages 15b to 17b to accommodate WithMidas=1.
On October 16 1981, the final overlay was too large to allow the IMReserve
for the Midas kernel, and there were not quite enough free locations on page
15b for the 33b mi in Fault.Mc that are conditional upon WithMidas=1.
OverlayAll.Cm reassembles all files affected by these switches.  If
CSLOverlay=1 or FinalOverlay=1, map and storage init code in Initialize.Mc
will not be assembled, so the system will only be startable from Midas
indirectly, by running Initial first.  Also IMReserve for Kernel in
OverlayOccupied.Mc is not conditional upon WithMidas=1 because there is no
alternate use for the locations.
%

*TASK DEFINITIONS
Set[BootTask,1];		*Task whose T-register used for booting
  IFG[BootTask,3,ER[Initialize.requires.BootTask.be.0.to.3]];
Set[cdcTask,5];			*Color Display
Set[eoTask,6];			*Ethernet Output
Set[eiTask,Add[eoTask,1]];	*Ethernet Input
  IFE[And[eoTask,14],And[eiTask,14],,ER[eoTask.and.eiTask.inconsistent]];
Set[rdcTask,10];		*Disk
Set[DpTask,12];			*Display
Set[TTask,16];			*Timer--wired-in, don't change this one

*Other switch initialization--DON'T CHANGE THIS (init only)
Set[LFKeyBoard,0];	*Default left alone for CSL keyboard assembly,
			*overruled for LF keyboard assembly

*INITIALIZATION PAGE ASSIGNMENTS
Set[InitPage,16];		*356b mi if NoOverlays=1 else 305b mi

Loca[InitBase,InitPage,200];	*InitBase to InitBase+6 are used
**Constants unused here--possibly needed by Lisp
  MC[InitLocH,And[InitBase,7400]];
    MC[InitLocL,And[InitBase,377]];
    MC[K2InitLocL,InitLocL,0];	*7200 not presently in any .MLF files
    MC[KInitLocL,InitLocL,3];	*7203 known to MakeLoaderFile .MLF files
    MC[EInitLocL,InitLocL,4];	*7204 known to MakeLoaderFile .MLF files
Loca[DTabBase,16,240];		* 11b mi in Initialize.Mc (allow for growth)

*NOTE: Page 17 addresses should be larger than 120b to allow the Midas Kernel.
*DisplayInitLoc value known to MakeLoaderFile .Mlf files
*DisplayInitLoc must be odd; DisplayInitLoc to DisplayInitLoc+6 are used
Loca[DisplayInitLoc,17,207];	*161b mi if CSLOverlay = 1, else 102b mi
Loca[EtherInitLoc,17,221];	* 24b mi
Loca[TimerInitLoc,17,223];	* 14b mi
Loca[rdcInitLoc,17,203];	* 12b mi
Set[rdcInitPage2,15];		* 16b mi rest of disk init (MUST NOT OVERWRITE
				*with final overlay).

*FINAL OVERLAY PAGE ASSIGNMENTS
***Should move the starting addresses above the Midas Kernel.
Loca[audGoLoc,17,2];	*11b mi on page of this starting address
Set[audPage,17];	*36b mi

Set[JasPage,17];	*165b mi (not on 4 to 7) for Jasmine scanner
  Loca[JasmineOn,JasPage,10];
  Loca[JasmineOff,JasPage,11];
  Loca[JasminePulse,JasPage,12];
Set[HalftonePage,17];	*123b mi (not on 4 to 7) for Jasmine halftone ucode
  Loca[PrintLine,HalftonePage,0];


*IO DRIVER PAGE ASSIGNMENTS

*33b mi in Fault.Mc if WithMidas=1 (35b mi if CSLOverlay is 1)
Set[MidasPage,IFE[CSLOverlay,1,IFE[FinalOverlay,1,15,16],17]];
*These two locations are in the Midas Kernel (used with GoToExternal)
  Loca[MidasFaultLoc,MidasPage,112];
  Loca[MidasBreakLoc,MidasPage,110];

Set[DisplayPage,2];	*UTVFC--whole page reserved for display
  Loca[FldDoneLoc,DisplayPage,1];	*Must be odd
  Loca[dpWidthLoc,DisplayPage,2];
  Loca[BootSV,DisplayPage,362];	*2b mi in Display.Mc if LFKeyBoard=0

Loca[KeyTable,15,0];	*40b mi keyboard translation table if LFKeyBoard=1
Set[lfKBPage,15];	*34b mi for LF keyboard posting code if LFKeyBoard=1
*NOTE: Display.Mc sets DisplayPage2/3 equal to DisplayPage if LFKeyboard=0.
Set[DisplayPage2,15];	* 3b mi (AltoXMMode only)
Set[DisplayPage3,15];	* 1b mi (AltoXMMode only)

Set[eePage,3];		*15b mi (not pages 4 to 7) Ether.Mc StartIO (task 0)
  Loca[eeLocA,eePage,110];	*Overwritten location
  Loca[eeLocB,eePage,111];	*Target of overwritten mi (JA must have
				*odd parity)

*These four must be on the same page
Loca[eoStartLoc,3,120];		*Output notify
Loca[eoTimerDoneLoc,3,130];	*Output TimerDone notify
Loca[eiStartLoc,3,140];		*Input notify
Loca[eiAbortLoc,3,150];		*SIO abort notify

Set[TimerPage,3];	*36b mi if WithMidas=0 else 41b mi (not pages 4 to 7)
  Loca[TimerTable,TimerPage,0];	*0 to 25b used in this table

Set[rdcPage,14];	*Disk microcode

Set[DoIntPage,15];	*13b mi
  Loca[DoIntLoc,DoIntPage,364];	*For CSLKeyboard overlay GoToExternal

			*54b mi Color display controller
Loca[cdcInitLoc,15,222];	*(Mesa JRAM 56622 turns on)
			*Output with 0 argument to device cdcTask,,0 turns
			*it off.

*TASK 0 PAGE ASSIGNMENTS

*Page 0 allocation is extremely tricky because different code uses it.
*Old LoadRAM uses 300-337, 370-371 (new LoadRAM uses 300-331);
*Fault uses 0-1 (emulator buffer refill trap and fault entry),
*  140-157 for MC12 fault dispatch table.
*  200, 202, 204, 206 for notifies (could be moved);
*  340-357 (FixDisp in Fault.Mc).
Loca[MesaRefillLoc,0,2];	*Location of MesaRefill subroutine in MesaJ.Mc
				*(for overlays with buffer refill code)
Set[FaultPage,0];		*Body of fault handler (Not pages 4 to 7).
  Loca[FixDisp,FaultPage,340];
  Loca[MC12,FaultPage,140];
  Loca[EmuNotifyLoc,0,200];	*Must be page 0
  Loca[NonEmuNotifyLoc,0,202];	*Must be page 0
  Loca[ContNonEmuLoc,FaultPage,204];
  Loca[NonEmuPFLoc,0,206];	*205b to 210b are used; must be page 0
Set[PNIPPage,FaultPage];	*12b mi (must be FaultPage--branch to PFExit)
Set[LRJPage,0];		**Don't change without coordinating all emulators
  Loca[LRJStart,LRJpage,300];
  Loca[LRJContinue,LRJpage,301];	*Old LoadRAM
*  Set[LRJContinue,Add[LRJStart,0]];
*  Set[ExchStkPLoc,Add[LRJStart,30]];
*  Set[SetStkPLoc,Add[LRJStart,31]];

Set[QLoc,230];		*02b mi in Initialize for BadWakeup crash code


*TASK 0 PAGE ASSIGNMENTS
Set[opPage0,4];		*These cannot move since hardware forces the first mi
Set[opPage1,5];		*of each bytecode to start at 2001 + (4 * opcode)
Set[opPage2,6];
Set[opPage3,7];
  Loca[KFCRLoc,opPage3,76];
  Loca[P7TailLoc,opPage3,27];	**Don't move--used by LRJ


*Pages shared by both Alto and Mesa emulators
Set[XMiscPage,10];	* 6b mi in Timer.Mc
			*13b mi in Disk.Mc
Set[bbPage,12];		*BitBlt
  Loca[bbIE,bbPage,200];
  Loca[bbIF,bbPage,220];
  Loca[bbI,bbPage,240];
Set[bbXMPage,15];	*11b mi (not pages 4 to 7) (AltoXMMode only)


*Alto emulator page assignments
Set[nePage,1];
  Loca[neBase,nePage,0];
  Loca[JmpFinLoc,nePage,3];	**Don't move--reentry location for Alto LRJ
  Loca[OpTab,nePage,20];	*Dispatch tables
  Loca[IO0Tab,nePage,40];
  Loca[IO1Tab,nePage,60];
  Loca[OpStart,nePage,115];	*Location of neTask1st for overlays

*Pieces of the Alto emulator that can be placed on any page
Set[neStartPage,4];	*07b mi
  Loca[neStartLoc,neStartPage,3]; **2003 known to MakeLoaderFile .MLF files
Set[neStartPage1,13];	*04b mi
Set[neStartPage2,4];	*06b mi
Set[neFixBPage,5];	*06b mi
Set[ConvertPage1,4];	*17b mi
Set[ConvertPage2,0];	*27b mi
Set[ConvertPage3,6];	*03b mi
Set[neBlksPage0,10];	*06b mi if neFastBltBlks=1
Set[neIntPage1,3];	*15b mi (not on pages 4 to 7)
Set[neMulPage,3];	*14b mi
Set[neDivPage,6];	*21b mi
Set[neLRJPage,7];	*10b mi
Set[neCSPage,11];	*24b mi (not on pages 4 to 7)
Set[neIntPage0,3];	*60b mi if neFastBltBlks=1 (not on pages 4 to 7)
			* else 14b mi (pages 4 to 7 ok)

Set[aoPage,13];		*Alto A-group (not on pages 4 to 7); 140b mi if
			*neFastAGroup=1 else 77b
Set[xoPage,13];		*Alto extended ops (not on pages 4 to 7)
  Loca[xoBase,xoPage,0];
  Loca[xoTab0,xoPage,260];
  Loca[xoTab1,xoPage,300];
:IF[neBCPLI360]; ******************************
Set[brGarbPage0,6];	*02b mi
Set[brGarbPage1,15];	*26b mi (not on pages 4 to 7)
IFE[And[brGarbPage1,14],4,ER[brGarbPage1.illegal.page.4.to.7]];
Set[brGarbPage2,13];	*06b mi
  :IF[neBCPLI340]; ****************************
  Set[br340Page,13];	*66b mi; must = xoPage (uses xoWRTRAM, xoRFAC0)
  IFE[br340Page,xoPage,,ER[br340Page.ne.xoPage]];
  :ENDIF; *************************************
:ENDIF; ***************************************
:IF[neBCPL300]; *******************************
Set[brJsrPage,13];	*42b mi; can be moved without complications
:ENDIF; ***************************************

IFE[And[bbXMPage,14],4,ER[bbXMPage.illegal.page.4.to.7]];
IFE[And[eePage,14],4,ER[eePage.illegal.page.4.to.7]];
IFE[And[TimerPage,14],4,ER[TimerPage.illegal.page.4.to.7]];
IFE[And[JasPage,14],4,ER[JasPage.illegal.page.4.to.7]];
IFE[And[HalftonePage,14],4,ER[HalftonePage.illegal.page.4.to.7]];
IFE[And[neIntPage1,14],4,ER[neIntPage1.illegal.page.4.to.7]];
IFE[And[neCSPage,14],4,ER[neCSPage.illegal.page.4.to.7]];
IFE[neFastBltBlks,1,
  IFE[And[neIntPage0,14],4,ER[neIntPage0.illegal.page.4.to.7]]];
IFE[And[aoPage,14],4,ER[aoPage.illegal.page.4.to.7]];
IFE[And[xoPage,14],4,ER[xoPage.illegal.page.4.to.7]];

%Addresses for memory error display in RM 100-107 when Midas is connected
(These are smashed only on a crash, not on simple breakpoints, so it should
be ok for these to overlap useful registers.).
%
SetTask[4];

RV4[MapEntry,TaskNumber,RefType,CrashCode,0];
RV4[CardNumber,MapFlags,QuadAddr,Syndrome,4];


SetTask[TTask];		*Registers for timer task.

*Storage testing results from Initial--**DON'T MOVE**.
RV4[xPageCount,xStorageFaults,xHardBadPages,xSoftBadPages,44];
*For backward compatibility, initialization copies xPageCount into
*StoragePages RM 326) also--eventually remove this after Lisp and Smalltalk
*are converted.
RV[StoragePages,26];	*Copy of xPageCount (counts number of 400b-word pages
			*in which the storage diagnostic found no errors).

*Although only the top ~7 bits of RTCLow are accurate (i.e., the clock counts
*every 2560 cycles), ~35d lower-order bits reduce long-term clock drift to
*about crystal quality (1 part in 10^6? or less than 3 seconds/month).
RV[RTCLowLow,22];	*Sublow word of Alto RealTime clock
RV[RTCLow,23];		*Low half of Alto RealTime clock
*RConstantLo/Hi and StoragePages must be consecutive for DisplayInit.Mc
*(which fixes up RConstantLo/Hi for variable processor clock periods) and
*for Initialize.Mc.
RV2[RConstantLo,RConstantHi,24];	*Addend for RTCLowLow,,RTCLow
RV2[TimerBase,TimerBasehi,40];	*Base register containing 400b
RV[RSImage,42];		*RS232 Image Register
RV[TimerTemp,43];	*Temporary
RM[PNIPSmash0,352];	*Register smashed by PNIP calls in Fault.Mc
RM[PNIPSmash1,353];	*Register smashed by PNIP calls in Fault.Mc (because
			*PNIP defined for task 0 but called by task 17).
RV[RTimer,57];		*Constant for memory refresh timer
RV[Refr,77];		*Refresh Address (Don't move--used in Kernel, Fault)

*Kernel/Initial/Fault registers
SetTask[17];

RV4[PipeReg,PipeReg1,PipeReg2,PipeReg3,60];	*Pipe Ram Entry goes here
RV2[PipeReg4,PipeReg5,64];
RV[FFault,66];		*Flags for faults (Also used by LoadRam)
RV[FaultParm,67];	*For passing page fault info from task 17 to emu
			***Have to fix assignment conflict with Jasmine.Mc
RV[RTMP,71];		*temporary
RV[RXSTK,72];		*Stackpointer
RV[RXPPB,73];		*Page,Parity,BootReason
RV[RXCTASK,74];		*CTASK.NCIA
RV[RXAPC,75];		*APCTask&APC
RV[RXALU,76];		*ALU result and SALUF

*The following Kernel registers should not be smashed by any code which
*might be debugged with Midas, but OK to reuse them by Printer interface
*devices such as Jasmine scanner and Audio board.
RV[RW1,62];	RV[RW0,63];	RV[RCNT,64];	RV[RADDR,65];
RV[RDATA,67];	RV[RWSTAT,70];	*Kernel only


SetTask[0];

*Task 0 registers used during initialization only
RV[xCNT,35];

%Alto emulator registers:

Each AC is a base register (ACnhi, PCBhi, and DMAhi are initialized by
FixNBases called from StartNova).  The stack predecessor to each AC must be
smashable by the A-group opcodes (since the StkP counter is 4 bits,
predecessor to 60, for example, is 77--watch out).  rpACn registers point at
the StkP predecessor to ACn (for PFetch1's, which do a push) and rwpACn
points at ACn.

For Alto, RM 3, 6-7, 21, 25, 40-53, 56-57, 64, 66-67, and 72-73 are temps;
RM 0, 12-13, 20, 62-63 are unused; all other RM locations have values that
must survive across opcodes; RM 6, 40-42, 51, 66, 70-71 used only by BitBlt.
**Note: although RM 63 is unused by Alto (xfWDC for Mesa), it seems necessary
to preserve it for Mesa traps to the Alto emulator.

If more registers are needed, modify BitBlt to use some of the Alto emulator's
constants and restore them before exit (R177400-R177402 are good choices since
these are Mesa temporaries); using these for BitBlt instead of any of the
registers named above as used only by BitBlt would free these registers for
the Alto emulator.
%
*R177400 to R177403 must be in a quadword since PCF[R177400] is used as
*the equivalent to PCF.word + 177400; similarly for SkipPCF0 to SkipPCF3.
RV4[R177400,R177401,R177402,R177403,14];
RV4[SkipPCF0,SkipPCF1,SkipPCF2,SkipPCF3,74];

RV[CARRY,1];		*Alto carry bit in bit 0

*Also, the values are chosen so that the low 3 bits of the four will enumerate
*0, 2, 4, and 6, which allows the rwpACx pointers to be coincident with the
*four SkipPCFx registers.
RV2[AC2,AC2hi,4];	*3 smashed by A-group opcodes (used by Mesa BitBlt)
RV2[AC0,AC0hi,10];	*7 smashed by A-group (used by Mesa BitBlt, StartIO)
RV2[AC1,AC1hi,26];	*25 smashed by A-group
RV2[AC3,AC3hi,22];	*21 smashed by A-group

RV[rpAC0,54];		*Pointer to AC0-1
RV[rpAC1,2];
RV[rpAC2,IP[R177403]];
RV[rpAC3,55];
RV[rwpAC0,IP[SkipPCF2]];	*Pointer to AC0 in bits 8:15
RV[rwpAC1,IP[SkipPCF1]];
RV[rwpAC2,IP[SkipPCF0]];
RV[rwpAC3,IP[SkipPCF3]];

RV[NWW,24];		*Both Alto and Mesa
RV2[PCB,PCBhi,30];	*Alto and Mesa
RV2[MDS,MDShi,32];	*Alto and Mesa

RV4[IBuf,IBuf1,IBuf2,IBuf3,34];	*4 word bytecode buffer for both Alto & Mesa

RV4[wBuf,wBuf1,wBuf2,wBuf3,40];	*wBuf temporary buffer
				*(wBuf3 must be at xBuf-1 for Alto BLT)
RV4[xBuf,xBuf1,xBuf2,xBuf3,44];	*Temporary buf (used by old LRJ--cannot move)
				*Also used as temporaries by Fault.Mc
RV4[yBuf,yBuf1,yBuf2,yBuf3,50];	*Temporary buf (used by new LRJ--don't move)
				*(yBuf must be at xBuf3+1 for Alto BLT)

RV[SMA,7];		*Temporary for CONVERT
RV[xnXH,56];		*Temporary for CONVERT
RV[XBI,57];		*Temporary for CONVERT

*WW, ACTIVE, and DMA must not coincide with any registers that must survive
*across interrupt checks for BLT or BLKS.
RV2[WW,ACTIVE,56];	*WW also used by Mesa

*Constants
RM[RMZero,IP[MDS]];	*Contains 0 for both Mesa and Alto
RM[RZero,IP[MDS]];	*Contains 0 for both Mesa and Alto
RV[R400,60];		*400 for both Alto and Mesa
RV[AllOnes,61];		*-1 for both Alto and Mesa (Only BitBlt uses AllOnes
			*for Alto, so could eliminate)

RV[MemStat,62];		*Directs page fault handling by Fault.Mc

RV2[DMA,DMAhi,64];

RV2[LP,LPhi,66];	*Long pointer base pair. (used by LRJ--cannot move)
			*(Used for Alto XMLDA & XMSTA)

RV4[zBuf,zBuf1,zBuf2,zBuf3,70];	*Quadword used by MesaFP
			*(Don't move unless xfTemp def changed--see below)

*RTemp and RTemp1 are used by PNIP, which might be called by any task,
*so these registers must not overlay any Kernel registers (x62-x77).  PNIP
*is most commonly called by task 17, so no conflicts on task 14-17 assignments
*is most important.
RV[RTemp,IP[yBuf2]];	*Both Alto and Mesa
RV[RTemp1,IP[yBuf3]];	*Both Alto and Mesa (used by LRJ--cannot move)
RV2[xfTemp,xfTemp1,IP[zBuf2]];	*(used by LRJ--cannot move)

Macro[StkPCheck,IFG[IP[#1],MaxStack!,
  IFG[20,IP[#1],ER[#1.not.referenceable.by.StkP]]]];
StkPCheck[AC0]; StkPCheck[AC1]; StkPCheck[AC2]; StkPCheck[AC3];
*See the code at StartNova in Alto.Mc if any of these errors occurs
IFE[IP[AC2],4,,ER[rpAC2.and.rwpAC2.became.no.good]];
IFE[IP[AC0],10,,ER[rwpAC0.became.non-coincident.with SkipPCF2]];
IFE[IP[AC1],26,,ER[rwpAC1.became.non-coincident.with SkipPCF1]];
IFE[IP[AC3],22,,ER[rwpAC3.became.non-coincident.with SkipPCF3]];

%BitBlt registers--these must not conflict with any inter-opcode storage
used by either Alto or Mesa emulators.  Uses AC0, AC2, and AC2hi, which
must not conflict with Mesa; must not smash Stack0-1 which are holding Mesa
arguments, but may smash Stack2 up; may smash AC3; restores IBuf-IBuf3 before
exit; LocalCache0-3 restored for Mesa exit.

RM 0, 12-13, 20, and, 62 are available; bbDty is available after init;
RM 22 is available for the Alto emulator but not for Mesa;
RM 11, 14-16 are available for the Mesa emulator but not for Alto.
%
RV[bbDest,IP[xBuf]];		*Quadword buffer

RV2[bbSlx,bbSty,IP[IBuf]];
RV[bbSLast,IP[IBuf1]];

RV2[bbDlx,bbDty,IP[IBuf2]];
*bbDty available after init

RV[bbSrc,IP[yBuf]];		*Quadword buffer
RV[bbYHi,IP[yBuf]];		*Init temporary

RV2[bbSrcQLo,bbSrcQHi,56];
RV2[bbDestQLo,bbDestQHi,IP[zBuf]];

RV[bbGray,IP[wBuf]];		*Quadword buffer
RV[bbGray1,IP[wBuf1]];
RV[bbGray2,IP[wBuf2]];

RV[bbDLast,6];
RV2[bbItemWid,bbItemsLeft,6];	*bbItemWid only needed during early init

*Registers which need not be paired
RV[bbNegBitsLeft,3];
RV[bbDBMR,21];
RV[bbFunction,25];
RV[bbNegItemWid,64];
RV[bbSrcWLo,66];
RV[bbSBMR,67];
RV[bbNegSDNonOverlap,IP[zBuf2]];
RV[bbDestWLo,IP[zBuf3]];



*Constants

MC[IntPendingBit,10];


INSERT[MesaDefs];

:END[GlobalDefs];(1795)\8214f5 150f0 1295f1 38f0 4f1 12f0 1f1 23f0 5f1 15f0 1f1 32f0 4f1 12f0 1f1 22f0 4f1 12f0 1f1 26f0
