% File SA4000Boot.mc(2048)
Last edit by Ev Neely August 26, 1980  11:49 AM Check for end of boot chain so InitialPilot will not need dummy file after it.
Last edit by Ev Neely Aug 15, 1980  3:57 PM New ".sb" format
Last edit by Ev Neely Aug 13, 1980  9:35 AM 48PID
Last edit by HGM March 8, 1980  1:55 PM
	Bold down FatalRdcError.
Last edit by HGM March 6, 1980  6:51 PM
	Initial MP, touch up find device, retry some errors, emulator timeout,
	Fixup interface to EtherBoot
Last edit by Jim Frandeen March 2, 1980  2:02 PM assure Font 0
Last edit by Jim Frandeen February 13, 1980  12:50 PM
%****************************************************************
Insert[PromDefs];e12
Title[SA4000Boot];
*RDC  CONTROLLER REGISTER DEFINITIONSe12(0,11712)
Set[RdcAddr,LSHIFT[RdcTask,4]];	*Device address of RDCe12
Set[RdcGeneralReset,0];	*General Reset
Set[RdcStatus,1];	*Controller and drive status
Set[RdcInput,17];	*Presents Buffer[RdcMemBuffAdr]
MC[RdcInputAddress,ADD[RdcAddr,RdcInput]];	
Set[RdcDrive/Head,1];	*Drive is in bits 12-13
	*Head is in bits 14-17
Set[RdcErrorReset,2];	*Error reset 
Set[RdcDevOp,3];	*Disk commands and allow wake
Set[RdcOutput,4];	*write to buffer[RdcMemBufAddr]
Set[RdcMemBuffAdr,6];	*current pointer into the Rdc bufferl11968d2998
Set[RdcPrimeIData,7];		*Must be accessed before reading from the RdcBufferl11968d2998(1,11200)
*CONSTANTSe12(1,65535)
MC[RdcMaxHead, 7];	*max head address for boot chain address.l11968d2998(1,6048)(2,14016)
MC[RdcMaxSector, 33];	*max head address for boot chain address.l11968d2998
MC[RdcDevSelOK, 20];	*Device is selected and ready.l11456d2998
MC[RdcIDHigh,1400];	*Upper half of Rdc ID(1,65535)(2,65535)
MC[RdcAllowWake,4000];
MC[RdcSeek-D,6000];	*Seek in negative direction plus allow wakel11968d2998
MC[RdcReadLabelAndData,122];
MC[RdcAllowWakeAndSeekDirection,5000];
MC[RdcSeekComplete,40];
MC[RdcTrack0,100];
MC[RdcSeekTimeOutWakeUps, 1000];
MC[RdcHeadSettlingTimeWakeUps,37];
MC[RdcSectorTimeOutWakeUps,50];
*Microcode begins at [0,1,0] and continues on sequential sectors. Bad pages are simply skipped. l4268e12(2048)
MC[FirstCylinder, 0];
MC[FirstHeadSector, 400];

Set Task[BootTask];l4268
OnPage[DiskBootPage];l4268
SET[InitRdcLoc,ADD[LSHIFT[InitPage,10],0]];	*Must be first word of a page in order for APC&APCTask to fit in 8 bits. l15552d2998(0,11712)
MC[InitRdcAPC&APCTask,ADD[LSHIFT[RdcTask,14],InitRdcLoc]];e12
*Come here from Boot l4268e12(2048)
DiskBoot:
ResetMemErrs;l4268
btTemp_InitRdcAPC&APCTask;l4268(0,11712)
APC&APCTask_btTemp,l4268
   Call[DiskPageTaskSwitch];l11968d4268
%
A full control store is 3*4096/256 = 48 pages, or 2 revolutions.  Thus we can retry quite a few times without slowint anything down much.  (The main delay is probably waiting for the arm to get back to cyl 0.)
%e12(0,6848)
btTemp1 _ 100C;	* Adjusted to be a second or twol4268e12(0,11712)
DiskEmulatorLoop:
btTemp _ 60000C;l4268
NOP;l4268
Call[DiskPageTaskSwitch];l4268
btTemp _ (btTemp)-1, GOTO[.-2,R>=0];l4268
btTemp1 _ (btTemp1)-1, GOTO[DiskEmulatorLoop,R>=0];l4268
* Timeout, go try Ether
LoadPage[DiskBootPage3];l4268
GoToP[DiskTimedOut];l4268
DiskPageTaskSwitch:e12
RETURN;l4268(0,6848)
e12(0,11712)
Set Task[RdcTask];l4268
OnPage[InitPage];l4268
*Definitions that depend on this page address:e12
*SET[InitRdcLoc,ADD[LSHIFT[DiskBootPage1,10],0]];	*Defined above l15552d2998
*MC[InitRdcAPC&APCTask,ADD[LSHIFT[RdcTask,14],InitRdcLoc]];	*Defined abovel15552d2998e12
InitRdc:e12
LoadPage[SetPanelPage],	* Show the world that we got this farl4268
   AT[InitRDCLoc];l4268
T_MPCodeStartRdcBoot,l4268
   CallP[SetPanel];l4268
*Find the Rdc and initialize its task to RdcTask. First we shift 0 into every controller task (there are 48 possible controllers). Then we do an Input of the device ID register until a Controller answers with the correct device ID. l4268e12
T_0C;	*Shift out zerol4268
RdcCount_(77C);	*16=64/4 decimal max controllersl4268
RdcCount_(RdcCount)-1,l4268
   GenSRClock,	*Shift out of bit 17 of Tl4268
   GoTo[.,ALU>=0];	*Do this 64 times.l4268
* Note that this is testing after shifting out each bit rather than every 4 bits.
* It seems to work ok.  /HGM
RdcCount_(100C);l4268
T_RdcRdcTask_(RdcTaskNumberComplement);l4268
InputControllerID:e12
*RdcTask will be shifted out. The value in the Controller task register is in complement form.l4268
GenSRClock;	*Shift next bit from T[17]l4268
Input@[RdcControllerID,0];	*Read ID from controllerl4268
RdcControllerID_(LHMask[RdcControllerID]);l4268
LU_(RdcControllerID) XOR (RdcIDHigh);l4268
RdcCount_(RdcCount)-1,l4268
   GoTo[RdcFound,ALU=0];	*If RdcControllerID=RdcIDl4268
T_RdcRdcTask_RSH[RdcRdcTask,1],l4268
   GoTo[InputControllerID,ALU#0];	*If not last controllerl4268
NoRdcController:e12
*Continue if the Rdc controller cannot be found.l4268
LoadPage[DiskBootPage3];l4268
RdcMPCode_MPCodeNoRdcController,l4268
   GoToP[FatalRdcError];l4268
RdcFound:e12
*We have found the Rdc Controller and initialized its task register so that we can talk to it. Initialize the Controller and all registers that need to be initialized. Initialize HeadSector to the first disk address to read. The first cylinder will be zero.   l4268
RdcZero_0C;l4268
LoadPage[DiskBootPage2];l4268
Output@[RdcZero,RdcGeneralReset],	*Reset the Controllerl4268
   GoToP[StartSA4000Boot];l4268
l4268
OnPage[DiskBootPage2];l4268
StartSA4000Boot:e12
*Check to be sure the device is ready. We must wait for two sector pulses to go by before we check.  Also come back here to retry various errors.l4268
Output@[RdcZero,RdcDrive/Head];l4268
RdcTemp_(Zero)+1;	l4268
RdcTemp_(RdcTemp)+1,l4268
   GoTo[.,ALU#0];l4268
Input@[RdcDiskStatus,RdcStatus];	*Get status from Controllerl4268
LU_(RdcDiskStatus) AND (RdcDevSelOK);l4268
GoTo[DiskReady,ALU#0];l4268
*Continue if the disk is not ready. l4268e12
LoadPage[DiskBootPage3];l4268
RdcMPCode_MPCodeDiskNotReady,l4268
   GoToP[FatalRdcError];l4268
DiskReady:e12
RdcWhichWord_(-400C);	*Set to skip first 256 wordsl4268
RdcHeadSector_FirstHeadSector;l4268
RdcChecksum_0C;	*Initialize checksuml4268
RdcHeadSettleCount_RdcHeadSettlingTimeWakeUps;l4268
Output@[RdcZero,RdcGeneralReset];	*Reset the Controllerl4268
RdcCommand_RdcAllowWake;l4268
SendAllowWake:e12
Output@[RdcCommand,RdcDevOp];	*Send allow wakel4268
RdcSectorTimeOutCount_RdcSeekTimeOutWakeUps;l4268
Recalibrate:e12
RdcTemp_20C,	*For seek delayl4268
   Call[DiskBootPage2Strobe];	*Clear wakeupl4268
*Continue here after the next sector wakeup. See if we are at track 0 yet.l4268e12
Input@[RdcDiskStatus,RdcStatus];	*Get status from Controllerl4268e12
LU_(RdcDiskStatus) AND (RdcTrack0);l4268
RdcCommand_RdcSeek-D,	*Seek in negative directionl4268
   GoTo[RecalibrateComplete,ALU#0];l4268
*Continue if we are not at track zero yet. See if the seek has completed.l4268e12
LU_(RdcDiskStatus) AND (RdcSeekComplete);l4268
RdcSectorTimeOutCount_(RdcSectorTimeOutCount)-1,l4268
   GoTo[Seek,ALU#0];	*If seek has completedl4268
*The seek has not yet completed. Check to see if the seek has timed out.l4268e12
GoTo[Recalibrate,ALU#0];	*If seek has not timed outl4268
*Continue if the seek has timed out. l4268e12
LoadPage[DiskBootPage3];l4268
RdcMPCode_MPCodeSeekTimeOut,l4268
   GoToP[FatalRdcError];l4268
Seek:e12
Output@[RdcCommand,RdcDevOp];	*Send seek commandl4268
*Now we need to delay at least one microsecond before issuing another Output command.l4268e12
RdcTemp_(RdcTemp)-1,	*Delay loop;l4268
   GoTo[.,R>=0];l4268
*Turn off the seek bit in the command, but leave AllowWake and Direction bits on.l4268e12
RdcCommand_(RdcCommand) AND (RdcAllowWakeAndSeekDirection),l4268
   GoTo[SendAllowWake];l4268
RecalibrateComplete:e12
RdcHeadSettleCount_(RdcHeadSettleCount)-1;l4268
RdcSectorTimeOutCount_RdcSectorTimeOutWakeUps,	*We try every sector until we find the right one.l11968d4268
   Skip[ALU=0];l4268
GoTo[Recalibrate];l5538
LoadPage[DiskBootPage1];l4268
GoToP[ReadSector];l4268
DiskBootPage2Strobe:e12
IOStrobe,l4268
   GoTo[DiskPage2TaskSwitch];l4268
l4268e12
OnPage[DiskBootPage1];l4268e12
ReadSectorAgain:e12
*Come here from HeaderIOAtten to read the sector again.l4268
Call[RdStrobe];	*Wait for the next sector wakeup.l4268
ReadSector:e12
*Continue here at the next sector wakeup when it is time to read a sector. RdcHeadsector has the disk address of the next sector to read. We try every sector until we find the right one. First, select the drive and head we are about to access.l4268
T_(LDF[RdcHeadSector,0,10]);	*Head is in bits 14-17l4268
RdcTemp_T;	*Drive is in bits 12-13l4268
	*Assume drive 0l4268
Output@[RdcTemp,RdcDrive/Head];	*send drive and headl4268
RdcCommand_RdcReadLabelAndData;l4268
RdcCommand_(RdcCommand) OR (RdcAllowWake);l4268
Output@[RdcCommand,RdcDevOp];	*Send read commandl4268
Output@[RdcZero,RdcMemBuffAdr];	*Set MemBufAdr to zerol4268
RdcZero_RdcZero;	*Interlock Output. NOTE: it does not work without this interlock!l11968d4268
Output@[RdcZero,RdcOutput];	*Send cylinder 0l4268
Output@[RdcHeadSector,RdcOutput];	*Send head sectorl4268
*Now fill the label area with zero. We must fill the label area of the controller buffer with something; otherwise we will get IOAtten.l4268e12
RdcTemp_15C;	*Loop 14 Decimal timesl4268
FillLabelArea:e12
*This NOP is to allow the write of Temp to complete; otherwise the bypassed value written is the result of the base register addition of the Output instruction. This is D0Gotcha number 11, which got me again!l4268
NOP;l4268
RdcTemp_(RdcTemp)-1;l4268
Output@[RdcZero,RdcOutput],	l4268
   GoTo[FillLabelArea,ALU>=0];l4268
Call[RdStrobe];	*Turn off wakeupl4268
*Continue here when the Controller has read the header field from the disk into its buffer. Wait one instruction before testing IOAtten. l4268e12
NOP;l4268
RdcSectorTimeOutCount_(RdcSectorTimeOutCount)-1,l4268
   GoTo[HeaderAtten,IOAtten];l4268
*Come here when the header has been successfully read from the disk. Now we will get 2 label field field wakeups. l4268e12
T_17C,	*Initialize data wakeup count.l4268
   Call[RdStrobe];	*Turn off wakeupl4268
*Continue after the first label field wakeup. Ignore this wakeup. Initialize wakeup count to -17 to count up to zero.l4268e12
RdcWakeupCount_(zero)-T,	*WakeupCount= -17l4268
   Call[RdStrobe];	*Turn off wakeup.l4268
*Continue after the second label field wakeup. The last word of the label contains the packed address of the next boot sector. Assume cylinder zero. Read the last word into HeadSector.l4268e12
T_15C,l4268
   Call[PrimeIData];	*Start the controllerl4268
Input@[RdcHeadSector,RdcInput];l4268
*Convert packed HeadSector to form needed by the controller.
*Also Test boot chain address to see if it is valid.l4268e12
T_(zero)-1;	*Begin test for eof
LU_(RdcHeadSector) XOR T;	l4268e12
RdcTemp_RdcMaxSector,l4268
   Skip[ALU#0];	l4268
   GoTo[WaitForData];	*EOF is valid bootchainl4268
l4268
T_(LDF[RdcHeadSector,13,5]);	*Unpack sectorl4268
LU_(RdcTemp)-(T);	*(max sector address) - (sector address)l11968d4268
RdcTemp_RdcMaxHead,l4268
   GoTo[InvalidBootAddress,ALU<0];	*If sector is too bigl4268
RdcHeadSector_(LDF[RdcHeadSector,10,3]);	*Unpack headl4268e12
RdcHeadSector_(LSH[RdcHeadSector,10]) OR T;  *Format HeadSectorl4268e12
T_LDF[RdcHeadSector,0,10];	*T=boot chain head addressl4268
LU_(RdcTemp)-(T);	*(max head address) - (head address)l11968d4268
Skip[ALU<0];	*If head is too bigl4268
GoTo[WaitForData];	*Boot chain link is OKl4268
GoTo[InvalidBootAddress];l4268
InvalidBootAddress:e12
RdcMPCode_MPCodeBadBootFile;	*Boot chain link is badl4268
GoTo[RetryableRDCError];l4268
WaitForData:e12
Call[RdStrobe];	*Turn off wakeupl4268
*Continue after the first data field wakeup. Set MemBufAdr to 21B. Do PrimeIData to start the Controller.l4268e12
T_21C,l4268
   Call[PrimeIData];l4268
RdcWordCount_17C,	*Initialize word count.l4268
   GoTo[NextDataWord];l4268
*Now we will get 15 more data wakeups and a sector wakeup. After each wakeup, process 16 words of data.l4268e12
NextDataWakeup:e12
RdcWordCount_17C,	*Initialize word count.l4268
   Call[RdStrobe];l4268
*Continue after the next data wakeup. Test for the sector wakeup following the last data wakeup.l4268e12
RdcWakeupCount_(RdcWakeupCount)+1,l4268e12
   GoTo[NextDataWord, R<0];l4268
NOP;	*Placement for belowl4268e12
Call[RdStrobe];	*One more, just to see if it worksl4268
*Continue after the 17th wakeup.l4268e12
GoTo[DataAtten,IOAtten];l4268
*Continue if the page has been successfully read and loaded. Go read the next page. l4268e12
RdcSectorTimeOutCount_RdcSectorTimeOutWakeUps,l4268e12
   GoTo[ReadSector];l4268
NextDataWord:e12
LoadPage[DiskBootPage2];l4268
GoToP[GetNextDataWord];l4268
l4268
OnPage[DiskBootPage2];l4268
*Definitions that depend on this page address:e12
SET[RdcWordDisp,ADD[LSHIFT[DiskBootPage2,10],20]];	*Arbitrary location for dispatch tablel15552d2998e12
GetNextDataWord:e12
RdcWordCount_(RdcWordCount)-1,l4268
   GoTo[InputNextDataWord,R>=0];	*If not last word this wakeupl4268
LoadPage[DiskBootPage1];	*If last word this wakeupl4268
GoToP[NextDataWakeup];l4268
InputNextDataWord:e12
Input@[RdcWord,RdcInput];	*RdcWord contains the next word read from the disk.l11968d4268
RdcWhichWord_(RdcWhichWord)+1,l4268
   GoTo[RealData,R>=0];	*After Skipping the 1st 256 wordsl4268
GoTo[GetNextDataWord];l4268
RealData:e12
Dispatch[RdcWhichWord,16,2];l4268
T_RdcWord,	*T=word just readl4268
   Disp[saWord1];l4268
saWord1:e12
* Bits 0-13 are the CS address. 7777 means end of file.l4268
* Bits 14-17 are bits 32-35 of the CS word.l4268
RdcWord0_T,l4268
   GoTo[GetNextDataWord],l4268
   AT[RdcWordDisp,1];l4268
saWord2:e12
* Bits 0-15 of the CS wordl4268
RdcWord1_T,l4268
   GoTo[GetNextDataWord],l4268
   AT[RdcWordDisp,2];l4268
Word3:e12
*Bits 16-31 of the CS word.l4268
RdcWhichWord_0c,l4268
   AT[RdcWordDisp,3];l4268
LoadPage[DiskBootPage];l4268
RdcWord2_T,l4268
   CallP[LoadCS];l4268
*On return, ALUA indicates the return code.l4268e12
GoTo[GetNextDataWord,ALU=0],l4268
   FreezeResult;l4268
GoTo[ChecksumError,ALU<0];l4268
*Come here if the CSAddress is bad, i.e., it would cause a store in the EPROM area..l4268e12
LoadPage[DiskBootPage1];l4268
RdcMPCode_MPCodeBadCSAddress,l4268
   GoToP[RetryableRdcError];l4268
ChecksumError:e12
*Come here if the computed checksum does not match the checksum from the boot file.l4268
LoadPage[DiskBootPage1];l4268
RdcMPCode_MPCodeChecksumError,l4268
   GoToP[RetryableRdcError];l4268
DiskPage2TaskSwitch:e12
RETURN;	l4268
e12
OnPage[DiskBootPage1];l4268e12
PrimeIData:e12
*This subroutine sets MemBuffAdr to the value in T and primes the Controller by Output to PrimeIdata. We then interlock to insure that the Output has been completed.l4268e12
RdcTemp_T;	*Value to write to MembuffAdrl4268
Output@[RdcTemp,RdcMemBuffAdr];	*Set MemBuffAdrl4268
Output@[RdcTemp,RdcPrimeIdata];	*Start the Controller.l4268
RdcTemp_RdcTemp,	*Wait for Outputl4268
   UseCTask,l4268
   GoTo[DiskPage1TaskSwitch];l4268
*Terminate the wakeup and go to sleep until the next sector wakeup. Note: This does not work if IOStrobe and RETURN are on the same statement. This is a mystery to me.l4268e12
RdStrobe:
IOStrobe,l4268
   GoTo[DiskPage1TaskSwitch];l4268
DiskPage1TaskSwitch:e12
RETURN;	l4268

*ERRORS COME THROUGH HERE
HeaderAtten:e12
*Come here if we get header IOAtten. This is usually because we are not at the right sector yet.l4268
GoTo[HeaderRetry,ALU=0];	*If sector time outl4268
Output@[RdcTemp,RdcErrorReset],l4268
   GoTo[ReadSectorAgain];	*Try again after the next sector wakeup.l11968d4268
HeaderRetry:e12
NOP;l4268
DataAtten:e12
RdcMPCode_MPCodeReadError;l4268
RetryableRdcError:e12
*Come here if a reasonable error occurs.  That includes things like bad CS addr since we have not had a chance to check the CRC on this page yet.  RdcMPCode contains the value to display in the maintenance panel. Display the error code in the Maintenance Panel and then try again.  This gives us a chance to recover from a transient read error.  If the error persists, the retry count will run out or the emulator task will timeout.l4268
Output@[RdcZero,RdcGeneralReset];l4268
LoadPage[SetPanelPage];l4268
T_RdcMPCode,l4268
   CallP[SetPanel];l4268
LoadPage[DiskBootPage2];l4268
GoToP[StartSA4000Boot];l4268
OnPage[DiskBootPage3];l4268e24
Set[DiskTimedOut2Loc,ADD[LSHIFT[DiskBootPage3,10],70]];e12
Set[DiskTimedOutAPC&APCTask,ADD[LSHIFT[RdcTask,14],DiskTimedOut2Loc]];
Set[GetToEtherLoc,ADD[LSHIFT[DiskBootPage3,10],72]];
SetTask[0];l4268e12
DiskTimedOut:e12
btTemp_AND[377,DiskTimedOutAPC&APCTask]C;l4268
btTemp_(btTemp) OR (AND[177400,DiskTimedOutAPC&APCTask]C);l4268
APC&APCTask_btTemp,l4268
  GOTO[DiskPage3Return];l4268
SetTask[RdcTask];l4268e12
DiskTimedOut2:e12
RdcMPCode_MPCodeRdcTimeout,l4268
   GoTo[FatalRdcError],l4268
   AT[DiskTimedOut2Loc];l4268
FatalRdcError:e12
*Come here (in RdcTask) if a fatal error occurs. RdcMPCode contains the value to display in the maintenance panel. Display the error code in the Maintenance Panel. Turn off the RDC Controller. Then transfer (in Task 0) to EtherBoot.l4268
Output@[RdcZero,RdcGeneralReset],l4268
   AT[FatalRdcErrorLoc];l4268
LoadPage[SetPanelPage];l4268
T_RdcMPCode,l4268
   CallP[SetPanel];l4268
RdcTemp_AND[377,GetToEtherLoc]C;l4268
RdcTemp_(RdcTemp) OR (AND[177400,GetToEtherLoc]C);l4268
APC&APCTask_RdcTemp,l4268
  GOTO[DiskPage3Return];l4268

GetToEther:e12
RdcTemp_IP[RdcMPCode]C,	* Need a pointer to RdcMPCodel4268
  AT[GetToEtherLoc];l4268
Stkp _ RdcTemp;l4268
Loadpage[EMPage];l4268
T _ Stack,l4268
   GOTOP[EtherBoot];l4268
DiskPage3Return:e12
RETURN;l4268
l4268
%l4268e12
This subroutine loads one word of Control Store. On Entry:
   Word0 Bits 0-13 are the CS address. 7777 means end of file.
   Word0 Bits 14-17 are bits 32-35 of the CS word
   Word1 Bits 0-15 of the CS word 
   Word2 Bits 16-31 of the CS word 
   Checksum is the running checksum.
The condition code of ALUA indicates the return code:l4268
ALUA = 0 for a normal return.
ALUA < 0 If the CSAddress is the last address and the checksum is wrong.
ALUA > 0 If the CSAddress is a bad address (i.e., it would destroy the EPROM area).l4268

This subroutine is also used by EtherBoot. EtherBoot must have the same registers allocated. Registers are as follows:l4268
R3:	Word0l5538e12(0,7328)
R7:	Word1l5538
R13:	Word2l5538
R17:	running checksuml5538
R23:	temporary used for CSAddressl5538
R27:	temporary l5538
%l5538
OnPage[DiskBootPage];l4268e12(0,11712)
SET[RdcEvenLoc,ADD[LSHIFT[DiskBootPage,10],40]];	*Arbitrary even location for CSopl15552d2998
SET[RdcEvenLoc1,ADD[LSHIFT[DiskBootPage,10],42]];	*Arbitrary even location for CSopl15552d2998
LoadCS:e12
T_RdcWord0;l4268
RdcChecksum_(RdcChecksum)+T;l4268
T_RdcWord1;l4268
RdcChecksum_(RdcChecksum)+T;l4268
T_RdcWord2;l4268
RdcChecksum_(RdcChecksum)+T;l4268
T_LDF[RdcWord0,0,14];l4268
RdcCSAddress_T;l4268
LU_(RdcCSAddress) XNOR (170000C);	*Test for CSAddress = 7777l4268
GoTo[LoadEOF,ALU=0],	*If last addressl4268
   LU_(RdcCSAddress) AND (300C);	*Test for page displacement < 100l11968d4268
GoTo[LoadCSWord,ALU#0],	*If not EPROM areal11968d4268
   T_(RdcCSAddress) AND (7400C);	*T is page number.l11968d4268
*Continue if CSAddress is in a page displacement less than 100. Test to see if the page is one of the EPROM pages.l4512d4268e12
RdcTemp_LSHIFT[LastEPROMpage,10]C;	l11968d4268e12
LU_(RdcTemp)-T;	*(Last EPROM page) - (page to store in)l11968d4268
T_RdcWord0,	*T is data for bits 32-35l4268
   GoTo[LoadCSWord1,ALU<0];	*If address is not in EPROM areal11968d4268
UseCTask;l4268
LU_1C,	*ALUA > 0 for error return: CSAddress is in EPROM areal11968d4268
   RETURN;l4268
*Continue if the CS address is OK.l4512d4268e12
LoadCSWord:
T_RdcWord0;	*T is data for bits 32-35l4268
LoadCSWord1:
LU_RdcWord1;	*ALUA is data for bits 00-15l4268
APC&APCTask_RdcCSAddress;	*APC is CS addressl4268
WriteCS0&2;	*Write bits 32-35, bits 00-15l4268
LU_RdcWord2,	*ALUA is data for bits 16-1l4268
   AT[RdcEvenLoc];	*Must be even locationl4268
APC&APCTask_RdcCSAddress;	*APC is CS addressl4268
WriteCS1;	*Write bits 16-31l4268
UseCTask,l4268
   AT[RdcEvenLoc1];	*Must be even locationl4268
LoadCSJump:
LU_0C,	*ALUA = 0 for normal returnl4268
   RETURN;l4268
*Come here when 7777 has been found in the CSAddress.l4268e12
LoadEOF:
RdcTemp_0C;l4268
Output@[RdcTemp,RdcGeneralReset];	*Turn off the controller. NOTE: this also resets the Ethernet controller when this routine is called by Etherboot.l11968d4268
LU_RdcChecksum;	*Checksum should be zerol11968d4268
APCTask&APC_RdcWord2,l11968d4268
   GoTo[LoadCSJump,ALU=0];	*Jump to code if checksum is OKl11968d4268
UseCTask;l4268
LU_(zero)-1,	*Set ALU <0 to indicate checksum errorl11968d4268
   RETURN;l11968d4268
:END[SA4000Boot];l4268e12
