@echo off
rem -------------------------------------------------------------------------
rem remote2 - coordinate the Remote2 applications
rem usage: remote2 application
rem where: application = { r2host, r2call, r2mgr }
rem -------------------------------------------------------------------------

if "%1"=="r2host" goto host
if "%1"=="R2HOST" goto host
if "%1"=="r2call" goto call
if "%1"=="R2CALL" goto call
if "%1"=="r2mgr"  goto mgr
if "%1"=="R2MGR"  goto mgr
goto usage

rem - configure the host software
:mgr
cd \remote2\r2host
r2mgr
if errorlevel 1 pause
menux \tools\menut.txt
goto exit

rem - call an analyzer host
:call
cd \remote2\r2call
r2call
goto menu

rem - load the host software
:host

rem - Token Ring monitor loaded?
call wchkmon tr
if errorlevel 1 goto menu

rem - Ethernet monitor loaded?
call wchkmon en
if errorlevel 1 goto menu

set scrmode=noscroll
cd \remote2\r2host
r2check
if errorlevel 1 goto loaded

rem - host software not yet loaded
:notloaded
r2host a
goto menu

rem - host software already loaded (display stops at the menu pause!)
:loaded
echo.
echo The host software is already loaded.  Follow the directions
echo to return to the main selection menu, then use the key sequence
echo 'Ctrl-ESC' to pop-up the remote2 host menu system.
echo.
goto menu

rem - invalid parameter
:usage
echo.
echo Error: unknown parameter on remote2.bat command line
echo The error is an internal inconsistency error.  Please
echo contact Network General Technical support for assistance.
echo.
pause
goto menu

rem - back to the menu
:menu
cd \
if errorlevel 1 pause
menu

:exit

