@echo off
rem -------------------------------------------------------------------------
rem upmain.bat: installation batch file for Sniffer R4.52 install
rem usage: called by install.bat or update.bat
rem -------------------------------------------------------------------------

rem - user reassurance
echo.
echo Processing files.  Please wait...
echo.

c:
cd \
set path=c:\tools;%PATH%


rem - remove old-style files from the root
if exist c:\??start.bat  del c:\??start.bat 
if exist c:\decstart.bat del c:\decstart.bat 
if exist c:\??demo.bat   del c:\??demo.bat 
if exist c:\ts*.bat      del c:\ts*.bat 
if exist c:\menu.bat     del c:\menu.bat 
if exist c:\setmode.bat  del c:\setmode.bat 
if exist c:\dos.bat      del c:\dos.bat 
if exist c:\menu*.txt    del c:\menu*.txt 

rem - cleanup the TeleSniffer files
if not exist \telesnif\host\*.* goto host
del \telesnif\host\*.exe
del \telesnif\host\*.cfg
del \telesnif\host\*.dsc
rmdir \telesnif\host
:host
if not exist \telesnif\remote\*.* goto remote
del \telesnif\remote\*.exe
del \telesnif\remote\*.cfg
del \telesnif\remote\*.dsc
rmdir \telesnif\remote
rmdir \telesnif
:remote

rem - save remote 2 user directories

if exist c:\remote2\r2call\r2call.usr copy c:\remote2\r2call\r2call.usr c:\remote2\r2call\r2call.tmp > NUL
if exist c:\remote2\r2host\r2.usr     copy c:\remote2\r2host\r2.usr c:\remote2\r2host\r2.tmp > NUL

rem - reset previous errors
if exist c:\update.err del c:\update.err

rem - remove leftover check programs
if exist \tools\????addr.exe del \tools\????addr.exe

rem - load the installation tools
if not exist \tools\NUL md tools >NUL
copy a:\*.bat \tools > NUL
copy a:\????addr.exe \tools > NUL
copy a:\ngrestor.exe \tools > NUL
copy a:\fedit.exe  \tools > NUL
copy a:\choice.com \tools > NUL
copy a:\chkstr.exe \tools > NUL
copy a:\input.exe  \tools >NUL
copy a:\deldir.exe \tools > NUL

set err_cfg=
call plcfg.bat
if "%err_cfg%"=="y" goto err_cfg
if "%err_cfg%"=="q" goto exit

rem - load the build info file
if exist a:\release.txt copy a:\release.txt \ > NUL

if "%2"=="update" goto skip_2
rem - load the network files
if not exist \config\NUL md config >NUL
copy a:\??sniff.cfg \config > NUL
if exist a:\nwaddr.?? copy a:\nwaddr.?? \config > NUL
:skip_2

if exist c:\tools\enpcaddr.exe call cleanup.bat EN
if exist c:\tools\trpcaddr.exe call cleanup.bat TR
if exist c:\tools\en3caddr.exe call cleanup.bat EN 
if exist c:\tools\encgaddr.exe call cleanup.bat EN 
if exist c:\tools\fdnpaddr.exe call cleanup.bat FD
if exist c:\tools\tibmaddr.exe call cleanup.bat TR
if exist c:\tools\hssyaddr.exe call cleanup.bat SY 
if exist c:\tools\trmaaddr.exe call cleanup.bat TR

rem - load the Platform software

:retry
cls
echo.
if "%2"=="update" goto upd_msg
echo Proceeding with 'Diskette 01' labeled 'Installation Software'...
ngrestor a: c: /TPlatform /A
goto msg_done
:upd_msg
echo Proceeding with 'Diskette 01' labeled 'Update Software'...
ngrestor a: c: /TPlatform /A
:msg_done

if errorlevel 99 goto err_disk
if errorlevel  2 goto err_quit
if errorlevel  1 goto err_load

rem - copy back saved remote2 user files

if exist c:\remote2\r2call\r2call.tmp copy c:\remote2\r2call\r2call.tmp c:\remote2\r2call\r2call.usr > NUL
if exist c:\remote2\r2host\r2.tmp     copy c:\remote2\r2host\r2.tmp c:\remote2\r2host\r2.usr > NUL
if exist c:\remote2\r2call\r2call.tmp del c:\remote2\r2call\r2call.tmp
if exist c:\remote2\r2host\r2.tmp     del c:\remote2\r2host\r2.tmp

rem - load the Sniffer software, one at a time
rem   Note: network names MUST match the NGBACKUP diskette tags!

if exist c:\tools\enpcaddr.exe call upload.bat ENPC EN Ethernet-III %2
if exist c:\update.err goto err_update

if exist c:\tools\trpcaddr.exe call upload.bat TRPC TR Token-Ring-III %2
if exist c:\update.err goto err_update

if exist c:\tools\en3caddr.exe call upload.bat EN3C EN Ethernet %2
if exist c:\update.err goto err_update

if exist c:\tools\encgaddr.exe call upload.bat ENCG EN Ethernet-II %2
if exist c:\update.err goto err_update

if exist c:\tools\fdnpaddr.exe call upload.bat FDNP FD FDDI %2
if exist c:\update.err goto err_update

if exist c:\tools\tibmaddr.exe call upload.bat TIBM TR Token-Ring-16/4 %2
if exist c:\update.err goto err_update

if exist c:\tools\hssyaddr.exe call upload.bat HSSY SY Internetwork %2
if exist c:\update.err goto err_update

if exist c:\tools\lmsyaddr.exe call upload.bat LMSY LM LM2000 %2
if exist c:\update.err goto err_update

if exist c:\tools\trmaaddr.exe call upload.bat TRMA TR Token-Ring-II %2
if exist c:\update.err goto err_update

if exist c:\tools\????addr.exe goto err_nic

set err_cfg=
call plload.bat
if "%err_cfg%"=="y" goto err_cfg
if "%err_cfg%"=="q" goto exit

if not "%2"=="update" goto skipmem
if not exist c:\tools\pa-5?x.cfg goto skipmem
if exist c:\tools\pa-50x.cfg call \tools\cfgmem50.bat
if exist c:\tools\pa-50x.cfg goto skipmem
call \tools\cfgmem.bat
:skipmem

copy c:\config.sys c:\tools   >NUL
copy c:\autoexec.bat c:\tools >NUL
if "%err%"=="Y" goto errtrcfg

cd \
if exist c:\snfcfg\nul deldir snfcfg /c >NUL

cd \
cls
echo.
echo ------------------------------------------------------------------------
echo              Sniffer R4.52 %2 completed successfully
echo ------------------------------------------------------------------------
echo.
echo     Remove any diskette from the floppy drive and reboot the Sniffer.
echo.


goto exit

rem - ngrestor failure
:err_load
echo.
echo Fatal Error: NGRESTOR failed to load the Sniffer platform software.
echo Please contact Network General Technical Support for assistance.
echo.
goto exit

rem - user quit at ngrestore prompt
:err_quit
echo.
echo The NGRESTOR process was terminated.  If you are experiencing
echo difficulties, please contact Network General Technical Support for 
echo assistance.
echo.
goto exit

rem - need to install another NIC
:err_nic
echo.
echo Reminder: The Sniffer %2 is not yet complete.
echo.
echo To complete the Sniffer %2, you must reinstall  
echo the software off of the original diskettes.
echo.
goto exit

rem - error configuring madge token ring
:errtrcfg
echo.
type c:\tools\cfg.err
echo.
echo To complete the Sniffer %2 you must correct the adapter configuration 
echo error. You do not need to reinstall the software. Contact Network 
echo General Technical Support if you need assistance.
echo.
goto exit

:err_cfg
echo.
echo There was a problem loading the Sniffer Network Analyzer software due 
echo to a configuration problem.  The details are shown in the previous 
echo message. Correct the problem or contact Network General 
echo Technical Support for assistance.
echo.
goto exit

rem - failed to insert the correct first diskette
:err_disk
echo.
echo The diskette you inserted is not the Platform Software diskette.
echo.
echo To continue the %2, insert the Platform Software diskette.
echo To abort the %2, answer NO at the next prompt.
echo.

input "Do you wish to continue the %2?"
if errorlevel 1 goto retry

rem - note: we don't exit on purpose, we want the next message!
echo Aborted trying to load the Platform Software diskette > c:\update.err
cls

rem - failed to install analyzer; see c:\update.err file
:err_update
echo.
echo The Sniffer %2 did not complete due to the previous error.
echo.
echo Please consult your %2 instructions for suggestions on how 
echo to resolve this problem.  If you require further assistance, please
echo contact Network General Technical Support for assistance.
echo.
goto exit

rem - common exit
:exit
