@echo off
rem -------------------------------------------------------------------------
rem wchkmon - checks for an installed monitor
rem usage:  wchkmon NN
rem where:  NN = network { en, fd, tr }
rem return: DOS errorlevel 0 = monitor removed/not loaded
rem                        1 = monitor not removed
rem -------------------------------------------------------------------------

rem - no such monitor loaded on the system
if not exist \%1sniff\%1mon.exe goto return0

rem - work in the Sniffer directory
cd \%1sniff

rem - check if the monitor is loaded in memory
if exist \config\%1mon.rem goto return0

if "%1"=="en" set mon=Ethernet
if "%1"=="fd" set mon=FDDI
if "%1"=="tr" set mon=Token-Ring

rem - let the user decide to remove the monitor driver
echo The %mon% monitor is about to be terminated.
echo Continuing will cause its data to be discarded.
input "Do you wish to continue?"
if not errorlevel 1 goto return1

rem - remove the monitor driver
%1mondrv unload
if errorlevel 1 goto unload_error
if "%1"=="fd" fixemm clear > nul

rem - update the monitor semaphore file
if exist \config\%1mon.ins del \config\%1mon.ins
echo removed > \config\%1mon.rem
goto return0

rem - unable to unload the monitor, inform user
:unload_error
echo Fatal Error: Unable to unload the monitor from memory.
echo Re-boot the system and configure the monitor again.
echo If the problem persists, contact Technical Support.
pause
goto return1

rem - monitor driver removed/not loaded
:return0
errorlvl 0
goto exit

rem - monitor driver not removed
:return1
errorlvl 1
goto exit

rem - back to the menu
:exit
cd \
set mon=

