#include <krnl.h>
#include <types.h>
#include <ether.h>
#include <error.h>
#include <netbuf.h>
#include <tcpip.h>
#include <pkt.h>
#include <bsi.h>

extern ushort chnl_flk_rx_led;
extern ushort chnl_flk_tx_led;

int DumpFddiPkt = FALSE;

#define	BSI_NUM	0

/*-------------------------------------------------------------------
* Used by both protocol stack and bridging module
* Return:
*	0 if ok
*	1 otherwise
*-------------------------------------------------------------------*/
fddi_transmit_pkt( pp, dummy )
PKT	*pp;
int dummy;
{
	pp->pktXmtPort = 0x08;
	/*
	* send with mac 0, async
	*/
	chnl_flk_tx_led |= 0x08;
	DRV_SendFrameBr(pp, 8);
	return 0;
}

/*-------------------------------------------------------------------
* PKT *GetFddiPkt()
*-------------------------------------------------------------------*/


PKT *GetFddiPkt()
{
	PKT* pp = 0;
	static int cnt = 0;
	extern unsigned drv_init_flag;

	if(!drv_init_flag)
	    return(pp);

	if( cnt++ < 1 )	
		/* get a rcvd ch2 frame from FDDI */
		pp = (PKT *)DRV_GetOneRxPkt(BSI_NUM);

	if( !pp ) {
		cnt=0;
		pp = (PKT *)RxLLCFrameIsr(BSI_NUM);
		if(pp) {
		}
	}

	if( pp )		/* if we got one */
	{
	   
		/* This is for the boot code only */
		if( DumpFddiPkt == TRUE ) {
			(pp->pktFree)(pp);
			return((PKT *)0);
		}

    	chnl_flk_rx_led  |= 0x08;
		pp->pktTotalSize += 4; /* Need to do this because the fddi driver */
								/* reduces the pkt size by this much.      */
		pp->pktDataSize  += 4; 
		pp->pktRcvPort    = 3;
		pp->pktDataPtr   -= 1;
	}
	return( pp );
}	

void ProcessFddiFrames() {

	extern BSI_ADDR_TYPE bsi_dev[];
	volatile BSI_REG_TYPE *r_ptr;
	register byte mar, rar;

	r_ptr = bsi_dev[BSI_NUM].base_addr;
	mar = r_ptr->mar;
	if (mar & BSI_MAR_NSA)    /* take care of the BSI no space attention */
		NoSpaceAtten(BSI_NUM,r_ptr);
 
	BSI_ProcessCNF(BSI_NUM);
	/* take care of the request attention */
	if (mar & BSI_MAR_RQA) {
		rar = r_ptr->rar;
		ReqAttenISR(BSI_NUM,r_ptr,rar);
	}
}
